/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.util.ArrayList;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekPhoenix
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "PHOENIX";
    private MSStringBuilder seite = new MSStringBuilder(65536);

    public MediathekPhoenix(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 4, 250, startPrio);
    }

    @Override
    public void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        this.addToList_();
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void addToList_() {
        String MUSTER = "<li><strong><a href=\"/content/";
        MSGetUrl getUrl = new MSGetUrl(this.wartenSeiteLaden);
        this.seite = getUrl.getUri(SENDERNAME, "http://www.phoenix.de/content/78905", "ISO-8859-15", 6, this.seite, "");
        if (this.seite.length() == 0) {
            MSLog.fehlerMeldung(487512369, "Leere Seite f\u00fcr URL: ");
        }
        int pos = 0;
        while ((pos = this.seite.indexOf("<li><strong><a href=\"/content/", pos)) != -1) {
            String url;
            int pos1 = pos += "<li><strong><a href=\"/content/".length();
            int pos2 = this.seite.indexOf("\"", pos);
            if (pos2 == -1 || (url = this.seite.substring(pos1, pos2)).isEmpty()) continue;
            url = "http://www.phoenix.de/content/" + url;
            String thema = this.seite.extract(">", "<", pos);
            thema = thema.replace("\"", "");
            this.listeThemen.addUrl(new String[]{url, thema});
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private final MSStringBuilder seite1;
        private final MSStringBuilder seite3;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekPhoenix.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekPhoenix.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekPhoenix.this.listeThemen.getListeThemen()) != null) {
                    this.seite1.setLength(0);
                    this.addFilme1(link[0], link[1]);
                    MediathekPhoenix.this.meldungProgress(link[0]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(825263641, ex);
            }
            MediathekPhoenix.this.meldungThreadUndFertig();
        }

        private void addFilme1(String url, String thema) {
            try {
                this.getUrl.getUri_Iso(MediathekPhoenix.SENDERNAME, url, this.seite1, "Thema: " + thema);
                ArrayList<String> liste = new ArrayList<String>();
                this.seite1.extractList("<div class=\"linkliste2\">", "", "<li><a href=\"/content/", "\"", "http://www.phoenix.de/content/", liste);
                for (String urlThema : liste) {
                    if (!MSConfig.getStop()) {
                        MediathekPhoenix.this.meldung(urlThema);
                        this.addFilme2(thema, urlThema);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(741258410, ex, url);
            }
        }

        private void addFilme2(String thema, String filmWebsite) {
            this.getUrl.getUri_Iso(MediathekPhoenix.SENDERNAME, filmWebsite, this.seite1, "");
            String urlId = this.seite1.extract("<div class=\"phx_vod\" id=\"phx_vod_", "\"", 0, "http://www.phoenix.de/php/mediaplayer/data/beitrags_details.php?ak=web&id=");
            String title = this.seite1.extract("<title>", "<");
            title = title.replace("phoenix  -", "").trim();
            if (!urlId.isEmpty()) {
                this.filmHolenId(thema, filmWebsite, urlId, title);
            } else {
                MSLog.fehlerMeldung(912546987, filmWebsite);
            }
        }

        public void filmHolenId(String thema, String filmWebsite, String urlId, String title_) {
            String beschreibung;
            if (MSConfig.getStop()) {
                return;
            }
            MediathekPhoenix.this.meldung(urlId);
            this.getUrl.getUri_Utf(MediathekPhoenix.SENDERNAME, urlId, this.seite3, "");
            if (this.seite3.length() == 0) {
                MSLog.fehlerMeldung(825412874, "url: " + urlId);
                return;
            }
            String titel = this.seite3.extract("<title>", "<");
            if (titel.isEmpty()) {
                titel = title_;
            }
            if ((titel = titel.replaceAll("\u0096", "-")).startsWith("\"") && titel.endsWith("\"")) {
                titel = titel.substring(1, titel.length() - 2);
            }
            if ((beschreibung = this.seite3.extract("<detail>", "<")).startsWith(titel)) {
                beschreibung = beschreibung.replaceFirst(titel, "");
            }
            beschreibung = beschreibung.replaceAll("\n", "");
            beschreibung = beschreibung.replaceAll("\u0096", "-");
            String laenge = this.seite3.extract("<lengthSec>", "<");
            String datum = this.seite3.extract("<airtime>", "<");
            if (datum.startsWith("01.01.1970")) {
                datum = this.seite3.extract("<onlineairtime>", "<");
            }
            String zeit = "";
            if (datum.contains(" ")) {
                zeit = datum.substring(datum.lastIndexOf(" ")).trim() + ":00";
                datum = datum.substring(0, datum.lastIndexOf(" ")).trim();
            }
            String url = "";
            String urlKlein = "";
            String urlHd = "";
            int posAnfang = 0;
            int posEnde = 0;
            int pos1 = 0;
            String URL_ANFANG = "<formitaet basetype=\"h264_aac_mp4_http_na_na\"";
            String URL_ENDE = "</formitaet>";
            String URL2 = "<url>";
            String URL_ANFANG_HD = "<formitaet basetype=\"wmv3_wma9_asf_mms_asx_http\"";
            while ((posAnfang = this.seite3.indexOf("<formitaet basetype=\"h264_aac_mp4_http_na_na\"", posAnfang)) != -1 && (posEnde = this.seite3.indexOf("</formitaet>", posAnfang += "<formitaet basetype=\"h264_aac_mp4_http_na_na\"".length())) != -1) {
                pos1 = this.seite3.indexOf("<quality>high</quality>", posAnfang);
                if (pos1 != -1 && pos1 < posEnde) {
                    if (!urlKlein.isEmpty() && !urlKlein.contains("metafilegenerator")) continue;
                    urlKlein = this.seite3.extract("<url>", "<", posAnfang, posEnde);
                }
                if ((pos1 = this.seite3.indexOf("<quality>veryhigh</quality>", posAnfang)) == -1 || pos1 >= posEnde || !url.isEmpty() && !url.contains("metafilegenerator") && !url.contains("podfiles")) continue;
                url = this.seite3.extract("<url>", "<", posAnfang, posEnde);
            }
            posAnfang = 0;
            while ((posAnfang = this.seite3.indexOf("<formitaet basetype=\"wmv3_wma9_asf_mms_asx_http\"", posAnfang)) != -1 && (posEnde = this.seite3.indexOf("</formitaet>", posAnfang += "<formitaet basetype=\"wmv3_wma9_asf_mms_asx_http\"".length())) != -1 && ((pos1 = this.seite3.indexOf("<quality>hd</quality>", posAnfang)) == -1 || pos1 <= posEnde && (urlHd = this.seite3.extract("<url>", "<", posAnfang, posEnde)).isEmpty())) {
            }
            if (url.isEmpty() && !urlKlein.isEmpty()) {
                url = urlKlein;
                urlKlein = "";
            }
            if (url.isEmpty()) {
                MSLog.fehlerMeldung(952102014, "keine URL: " + filmWebsite);
            } else {
                if (url.startsWith("http://tvdl.zdf.de")) {
                    url = url.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                }
                if (urlKlein.startsWith("http://tvdl.zdf.de")) {
                    urlKlein = urlKlein.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                }
                if (urlHd.startsWith("http://tvdl.zdf.de")) {
                    urlHd = url.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                }
                DatenFilm film = new DatenFilm(MediathekPhoenix.SENDERNAME, thema, filmWebsite, titel, url, "", datum, zeit, MediathekReader.extractDuration(laenge), beschreibung);
                MediathekPhoenix.this.addFilm(film);
                film.addUrlKlein(urlKlein, "");
                film.addUrlHd(urlHd, "");
            }
        }
    }
}

