/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekKika
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "KiKA";
    private MSStringBuilder seite = new MSStringBuilder(65536);
    MediathekReader.LinkedListUrl listeAllVideos = new MediathekReader.LinkedListUrl(this);

    public MediathekKika(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 5, 200, startPrio);
    }

    @Override
    void addToList() {
        this.meldungStart();
        if (MSConfig.loadLongMax()) {
            this.addToListNormal();
        }
        this.addToListAllVideo();
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0 && this.listeAllVideos.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeAllVideos.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    void addToListNormal() {
        String ADRESSE = "http://www.kika.de/sendungen/sendungenabisz100.html";
        String MUSTER_URL = "<a href=\"/sendungen/sendungenabisz100_";
        ArrayList<String> liste1 = new ArrayList<String>();
        ArrayList<String> liste2 = new ArrayList<String>();
        this.listeThemen.clear();
        try {
            this.seite = this.getUrlIo.getUri(SENDERNAME, "http://www.kika.de/sendungen/sendungenabisz100.html", "UTF-8", 3, this.seite, "KiKA: Startseite");
            this.seite.extractList("<a href=\"/sendungen/sendungenabisz100_", "\"", 0, "http://www.kika.de/sendungen/sendungenabisz100_", liste1);
            for (String s : liste1) {
                this.seite = this.getUrlIo.getUri_Utf(this.sendername, s, this.seite, "KiKa-Sendungen");
                String MUSTER_SENDUNGEN_1 = "<h4 class=\"headline\">";
                String MUSTER_SENDUNGEN_2 = "<a href=\"/";
                this.seite.extractList("", "<!--The bottom navigation -->", "<h4 class=\"headline\">", "<a href=\"/", "\"", "http://www.kika.de/", liste2);
            }
            for (String ss : liste2) {
                this.listeThemen.add(new String[]{ss});
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(302025469, ex);
        }
    }

    void addToListAllVideo() {
        String ADRESSE = "http://www.kika.de/videos/allevideos/allevideos-buendelgruppen100.html";
        String MUSTER_URL = "<a href=\"/videos/allevideos/allevideos-buendelgruppen100_page-";
        ArrayList<String> liste1 = new ArrayList<String>();
        ArrayList<String> liste2 = new ArrayList<String>();
        try {
            this.seite = this.getUrlIo.getUri(SENDERNAME, "http://www.kika.de/videos/allevideos/allevideos-buendelgruppen100.html", "UTF-8", 3, this.seite, "KiKA: Startseite alle Videos");
            this.seite.extractList("<a href=\"/videos/allevideos/allevideos-buendelgruppen100_page-", "\"", 0, "http://www.kika.de/videos/allevideos/allevideos-buendelgruppen100_page-", liste1);
            for (String s1 : liste1) {
                this.seite = this.getUrlIo.getUri_Utf(this.sendername, s1, this.seite, "KiKa-Sendungen");
                this.seite.extractList("<div class=\"media mediaA\">\n<a href=\"/", "\"", 0, "http://www.kika.de/", liste2);
            }
            for (String s2 : liste2) {
                this.listeAllVideos.add(new String[]{s2});
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(732120256, ex);
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private MSStringBuilder seite3;
        private final SimpleDateFormat sdf;
        private final SimpleDateFormat sdfOutTime;
        private final SimpleDateFormat sdfOutDay;
        private final ArrayList<String> liste1;
        private final ArrayList<String> liste2;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekKika.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            this.sdfOutTime = new SimpleDateFormat("HH:mm:ss");
            this.sdfOutDay = new SimpleDateFormat("dd.MM.yyyy");
            this.liste1 = new ArrayList();
            this.liste2 = new ArrayList();
        }

        @Override
        public synchronized void run() {
            try {
                String[] link;
                MediathekKika.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekKika.this.listeAllVideos.getListeThemen()) != null) {
                    MediathekKika.this.meldungProgress(link[0]);
                    this.loadAllVideo_1(link[0]);
                }
                while (!MSConfig.getStop() && (link = MediathekKika.this.listeThemen.getListeThemen()) != null) {
                    MediathekKika.this.meldungProgress(link[0]);
                    this.ladenSerien_1(link[0]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(915236791, ex);
            }
            MediathekKika.this.meldungThreadUndFertig();
        }

        public void ladenSerien_1(String filmWebsite) {
            try {
                this.liste1.clear();
                this.liste2.clear();
                this.seite1 = MediathekKika.this.getUrlIo.getUri(MediathekKika.SENDERNAME, filmWebsite, "UTF-8", 1, this.seite1, "Themenseite");
                String thema = this.seite1.extract("<title>", "<");
                thema = thema.replace("KiKA -", "").trim();
                String url = "";
                if (url.isEmpty()) {
                    url = this.seite1.extract("<h2 class=\"conHeadline\">Alle Folgen</h2>", "<a href=\"", "\"");
                }
                if (url.isEmpty()) {
                    url = this.seite1.extract("<h2 class=\"conHeadline\">Alle Sendungen</h2>", "<a href=\"", "\"");
                }
                if (url.isEmpty()) {
                    url = this.seite1.extract("<h2 class=\"conHeadline\">N\u00e4chste Folge</h2>", "<span class=\"moreBtn\">", "<a href=\"", "\"", "");
                }
                if (url.isEmpty()) {
                    MSLog.fehlerMeldung(721356987, "keine URL: " + filmWebsite);
                    return;
                }
                if (!url.startsWith("http://www.kika.de")) {
                    url = "http://www.kika.de" + url;
                }
                this.seite1 = MediathekKika.this.getUrlIo.getUri(MediathekKika.SENDERNAME, url, "UTF-8", 1, this.seite1, "Themenseite");
                this.seite1.extractList("", "<!--The bottom navigation -->", "<div class=\"shortInfos\">", "<a href=\"", "\"", "http://www.kika.de", this.liste1);
                this.seite1.extractList("", "", "<div class=\"bundleNaviItem \">", "<a href=\"", "\"", "http://www.kika.de", this.liste2);
                for (String s : this.liste2) {
                    this.seite1 = MediathekKika.this.getUrlIo.getUri(MediathekKika.SENDERNAME, s, "UTF-8", 1, this.seite1, "Themenseite");
                    this.seite1.extractList("", "<!--The bottom navigation -->", "<div class=\"shortInfos\">", "<a href=\"", "\"", "http://www.kika.de", this.liste1);
                }
                if (this.liste1.isEmpty()) {
                    MSLog.fehlerMeldung(794512630, "keine Filme: " + filmWebsite);
                    return;
                }
                int count = 0;
                int err = 0;
                for (int i = this.liste1.size() - 1; i >= 0; --i) {
                    String s = this.liste1.get(i);
                    if (!MSConfig.loadLongMax() && ++count > 4) {
                        return;
                    }
                    if (MSConfig.getStop()) {
                        return;
                    }
                    if (!this.ladenSerien_2(s, thema)) {
                        if (MSConfig.loadLongMax() || ++err <= 2) continue;
                        break;
                    }
                    err = 0;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(915263147, ex);
            }
        }

        boolean ladenSerien_2(String filmWebsite, String thema) {
            boolean ret = false;
            try {
                MediathekKika.this.meldung(filmWebsite);
                this.seite1 = MediathekKika.this.getUrlIo.getUri(MediathekKika.SENDERNAME, filmWebsite, "UTF-8", 1, this.seite1, "Themenseite");
                String xml = this.seite1.extract("<div class=\"av-playerContainer\"", "setup({dataURL:'", "'");
                if (!xml.isEmpty()) {
                    ret = true;
                    xml = "http://www.kika.de" + xml;
                    this.ladenXml(xml, thema, false);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(801202145, ex);
            }
            return ret;
        }

        boolean ladenSerien_3(String thema) {
            boolean ret = false;
            try {
                this.liste1.clear();
                this.seite1.extractList("", "", "setup({dataURL:'", "'", "http://www.kika.de", this.liste1);
                if (this.liste1.isEmpty()) {
                    MSLog.fehlerMeldung(495623014, "keine XML: ");
                }
                int count = 0;
                for (String xml : this.liste1) {
                    if (MSConfig.loadLongMax() || count <= 4) {
                        ret = true;
                        this.ladenXml(xml, thema, false);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(821012459, ex);
            }
            return ret;
        }

        void loadAllVideo_1(String url) {
            ArrayList<String> liste = new ArrayList<String>();
            try {
                this.seite2 = MediathekKika.this.getUrlIo.getUri_Utf(MediathekKika.this.sendername, url, this.seite2, "KiKa-Sendungen");
                this.loadAllVideo_2(this.seite2);
                if (MSConfig.loadLongMax()) {
                    this.seite2.extractList("<div class=\"bundleNaviItem active\">\n<a href=\"/videos/allevideos/", "\"", 0, "http://www.kika.de/videos/allevideos/", liste);
                    this.seite2.extractList("<div class=\"bundleNaviItem \">\n<a href=\"/videos/allevideos/", "\"", 0, "http://www.kika.de/videos/allevideos/", liste);
                }
                for (String u : liste) {
                    if (!MSConfig.getStop()) {
                        this.seite2 = MediathekKika.this.getUrlIo.getUri_Utf(MediathekKika.this.sendername, u, this.seite2, "KiKa-Sendungen");
                        this.loadAllVideo_2(this.seite2);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(825412369, ex);
            }
        }

        void loadAllVideo_2(MSStringBuilder sStringBuilder) {
            ArrayList<String> liste = new ArrayList<String>();
            try {
                String thema = sStringBuilder.extract("<h1 class=\"headline\">", "<").trim();
                if (thema.isEmpty()) {
                    thema = sStringBuilder.extract("<title>KiKA -", "<").trim();
                }
                sStringBuilder.extractList(".setup({dataURL:'/", "'", 0, "http://www.kika.de/", liste);
                for (String s : liste) {
                    if (!MSConfig.getStop()) {
                        this.ladenXml(s, thema, true);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(201036987, ex);
            }
        }

        void ladenXml(String xmlWebsite, String thema, boolean urlPruefen) {
            try {
                String titel;
                this.seite3 = MediathekKika.this.getUrlIo.getUri_Utf(MediathekKika.this.sendername, xmlWebsite, this.seite3, "");
                if (thema.isEmpty()) {
                    thema = MediathekKika.this.sendername;
                }
                if ((titel = this.seite3.extract("<title>", "<")).toLowerCase().equals(thema.toLowerCase())) {
                    titel = this.seite3.extract("<headline>", "<");
                }
                if (titel.toLowerCase().equals(thema.toLowerCase()) && (titel = this.seite3.extract("<topline>", "<")).isEmpty()) {
                    titel = this.seite3.extract("<title>", "<");
                }
                String beschreibung = this.seite3.extract("<broadcastDescription>", "<");
                String date = this.seite3.extract("<broadcastDate>", "<");
                String datum = "";
                String zeit = "";
                if (!date.isEmpty()) {
                    datum = this.convertDatum(date);
                    zeit = this.convertTime(date);
                } else {
                    date = this.seite3.extract("<webTime>", "<");
                    if (!date.isEmpty()) {
                        datum = date.substring(0, date.indexOf(" ")).trim();
                        zeit = date.substring(date.indexOf(" ")).trim() + ":00";
                    }
                }
                String urlSendung = this.seite3.extract("<broadcastURL>", "<");
                if (urlSendung.isEmpty()) {
                    urlSendung = this.seite3.extract("<htmlUrl>", "<");
                }
                long duration = 0L;
                try {
                    String dauer = this.seite3.extract("<duration>", "<");
                    if (!dauer.equals("")) {
                        String[] parts = dauer.split(":");
                        long power = 1L;
                        for (int i = parts.length - 1; i >= 0; --i) {
                            duration += Long.parseLong(parts[i]) * power;
                            power *= 60L;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    MSLog.fehlerMeldung(201036547, (Exception)ex, xmlWebsite);
                }
                String MUSTER_URL_MP4 = "<progressiveDownloadUrl>";
                String urlHD = this.seite3.extract("| MP4 Web XL |", "<progressiveDownloadUrl>", "<");
                String urlMp4 = this.seite3.extract("| MP4 Web L |", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = this.seite3.extract("| MP4 Web L+ |", "<progressiveDownloadUrl>", "<");
                }
                String urlMp4_klein = this.seite3.extract("| MP4 Web M |", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = urlMp4_klein;
                    urlMp4_klein = "";
                }
                if (thema.isEmpty() || urlSendung.isEmpty() || titel.isEmpty() || urlMp4.isEmpty() || date.isEmpty() || zeit.isEmpty() || duration == 0L) {
                    MSLog.fehlerMeldung(735216987, "leer: " + xmlWebsite);
                }
                if (!urlMp4.equals("")) {
                    MediathekKika.this.meldung(urlMp4);
                    DatenFilm film = new DatenFilm(MediathekKika.SENDERNAME, thema, urlSendung, titel, urlMp4, "", datum, zeit, duration, beschreibung);
                    film.addUrlKlein(urlMp4_klein, "");
                    film.addUrlHd(urlHD, "");
                    MediathekKika.this.addFilm(film, urlPruefen);
                } else {
                    MSLog.fehlerMeldung(963215478, " xml: " + xmlWebsite);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(784512365, ex);
            }
        }

        private String convertDatum(String datum) {
            try {
                Date filmDate = this.sdf.parse(datum);
                datum = this.sdfOutDay.format(filmDate);
            }
            catch (ParseException ex) {
                MSLog.fehlerMeldung(731025789, (Exception)ex, "Datum: " + datum);
            }
            return datum;
        }

        private String convertTime(String zeit) {
            try {
                Date filmDate = this.sdf.parse(zeit);
                zeit = this.sdfOutTime.format(filmDate);
            }
            catch (ParseException ex) {
                MSLog.fehlerMeldung(915423687, (Exception)ex, "Time: " + zeit);
            }
            return zeit;
        }
    }
}

