/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSFunktionen;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekHr
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "HR";
    private MSStringBuilder seite = new MSStringBuilder(65536);
    private MSStringBuilder rubrikSeite = new MSStringBuilder(65536);

    public MediathekHr(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 500, startPrio);
    }

    @Override
    public void addToList() {
        this.meldungStart();
        this.seite = this.getUrlIo.getUri_Utf(SENDERNAME, "http://www.hr-online.de/website/fernsehen/sendungen/index.jsp", this.seite, "");
        this.bearbeiteRubrik(this.seite);
        this.bearbeiteTage(this.seite);
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void bearbeiteTage(MSStringBuilder seite) {
        String TAGE_PREFIX = "http://www.hr-online.de/website/includes/medianew-playlist.xml.jsp?logic=start_multimedia_document_logic_";
        String TAGE_MUSTER = "http://www.hr-online.de/website/includes/medianew-playlist.xml.jsp?logic=start_multimedia_document_logic_";
        ArrayList<String> erg = new ArrayList<String>();
        seite.extractList("http://www.hr-online.de/website/includes/medianew-playlist.xml.jsp?logic=start_multimedia_document_logic_", "&", 0, "http://www.hr-online.de/website/includes/medianew-playlist.xml.jsp?logic=start_multimedia_document_logic_", erg);
        for (String url : erg) {
            String[] add = new String[]{url, "", "http://www.hr-online.de/website/fernsehen/sendungen/index.jsp"};
            if (this.istInListe(this.listeThemen, url, 0)) continue;
            this.listeThemen.add(add);
        }
    }

    private void bearbeiteRubrik(MSStringBuilder seite) {
        String RUBRIK_PREFIX = "http://www.hr-online.de/website/fernsehen/sendungen/index.jsp?rubrik=";
        String RUBRIK_MUSTER = "<option value=\"/website/fernsehen/sendungen/index.jsp?rubrik=";
        ArrayList<String> erg = new ArrayList<String>();
        seite.extractList("<option value=\"/website/fernsehen/sendungen/index.jsp?rubrik=", "\"", 0, "http://www.hr-online.de/website/fernsehen/sendungen/index.jsp?rubrik=", erg);
        for (String s : erg) {
            if (MSConfig.getStop()) break;
            this.rubrik(s);
        }
    }

    private void rubrik(String rubrikUrl) {
        String url;
        String MUSTER = "/website/includes/medianew-playlist.xml.jsp?logic=start_multimedia_document_logic_";
        String MUSTER_TITEL = "<meta property=\"og:title\" content=\"";
        this.rubrikSeite = this.getUrlIo.getUri_Iso(SENDERNAME, rubrikUrl, this.rubrikSeite, "");
        String thema = this.rubrikSeite.extract("<meta property=\"og:title\" content=\"", "\"");
        if (thema.contains("|")) {
            thema = thema.substring(0, thema.indexOf("|")).trim();
        }
        if (!(url = this.rubrikSeite.extract("/website/includes/medianew-playlist.xml.jsp?logic=start_multimedia_document_logic_", "&")).equals("")) {
            url = "http://www.hr-online.de/website/includes/medianew-playlist.xml.jsp?logic=start_multimedia_document_logic_" + url;
            String[] add = new String[]{url, thema, rubrikUrl};
            if (!this.istInListe(this.listeThemen, url, 0)) {
                this.listeThemen.add(add);
            }
        } else {
            MSLog.fehlerMeldung(653210697, "keine URL");
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder seite1;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekHr.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekHr.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekHr.this.listeThemen.getListeThemen()) != null) {
                    MediathekHr.this.meldungProgress(link[0]);
                    MediathekHr.this.seite.setLength(0);
                    this.addFilme(link[0], link[1], link[2]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(894330854, ex);
            }
            MediathekHr.this.meldungThreadUndFertig();
        }

        private void addFilme(String xmlWebsite, String thema_, String filmSite) {
            String MUSTER_ITEM_1 = "<videos>";
            String MUSTER_TITEL = "<title>";
            String MUSTER_URL = "<url type=\"mp4\">";
            String MUSTER_URL_LOW = "<url type=\"mp4-small\">";
            String MUSTER_DATUM = "<date>";
            String MUSTER_THEMA = "<author>";
            String MUSTER_DURATION = "<duration>";
            String MUSTER_DESCRIPTION = "<description>";
            String END = "</";
            MediathekHr.this.meldung(xmlWebsite);
            this.seite1 = this.getUrl.getUri_Iso(MediathekHr.SENDERNAME, xmlWebsite, this.seite1, "");
            try {
                int posItem1 = 0;
                String url = "";
                String zeit = "";
                long duration = 0L;
                while (!MSConfig.getStop() && (posItem1 = this.seite1.indexOf("<videos>", posItem1)) != -1) {
                    String url_low;
                    String d = this.seite1.extract("<duration>", "</", posItem1 += "<videos>".length());
                    try {
                        if (!d.equals("")) {
                            duration = 0L;
                            String[] parts = d.split(":");
                            long power = 1L;
                            for (int i = parts.length - 1; i >= 0; --i) {
                                duration += Long.parseLong(parts[i]) * power;
                                power *= 60L;
                            }
                        }
                    }
                    catch (Exception ex) {
                        MSLog.fehlerMeldung(708096931, "d: " + d);
                    }
                    String description = this.seite1.extract("<description>", "</", posItem1);
                    String datum = this.seite1.extract("<date>", "</", posItem1);
                    if (datum.contains(" ")) {
                        zeit = datum.substring(datum.indexOf(" ")).trim() + ":00";
                        datum = datum.substring(0, datum.indexOf(" "));
                    }
                    String titel = this.seite1.extract("<title>", "</", posItem1);
                    String thema = this.seite1.extract("<author>", "</", posItem1);
                    if (thema.isEmpty()) {
                        thema = thema_;
                    }
                    if (thema.isEmpty()) {
                        thema = titel;
                    }
                    if ((url = this.seite1.extract("<url type=\"mp4\">", "</", posItem1)).equals(url_low = this.seite1.extract("<url type=\"mp4-small\">", "</", posItem1))) {
                        url_low = "";
                    }
                    if (!url.isEmpty()) {
                        String subtitle;
                        if (datum.equals("")) {
                            datum = this.getDate(url);
                        }
                        DatenFilm film = new DatenFilm(MediathekHr.SENDERNAME, thema, filmSite, titel, url, "", datum, zeit, duration, description);
                        if (!url_low.isEmpty()) {
                            film.addUrlKlein(url_low, "");
                        }
                        if (MediathekReader.urlExists(subtitle = url.replace(".mp4", ".xml"))) {
                            film.addUrlSubtitle(subtitle);
                        }
                        MediathekHr.this.addFilm(film);
                        continue;
                    }
                    MSLog.fehlerMeldung(649882036, "keine URL");
                }
                if (url.isEmpty()) {
                    MSLog.fehlerMeldung(761236458, "keine URL f\u00fcr: " + xmlWebsite);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(487774126, ex);
            }
        }

        private String getDate(String url) {
            String ret = "";
            try {
                String tmp = MSFunktionen.getDateiName(url);
                if (tmp.length() > 8) {
                    tmp = tmp.substring(0, 8);
                    SimpleDateFormat sdfIn = new SimpleDateFormat("yyyyMMdd");
                    Date filmDate = sdfIn.parse(tmp);
                    SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
                    ret = sdfOut.format(filmDate);
                }
            }
            catch (Exception ex) {
                ret = "";
                MSLog.fehlerMeldung(356408790, "kein Datum");
            }
            return ret;
        }
    }
}

