/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.util.ArrayList;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekArd
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "ARD";
    MSStringBuilder seiteFeed = new MSStringBuilder(65536);
    private final String THEMA_TAGE = "TAGE";

    public MediathekArd(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 5, 250, startPrio);
    }

    @Override
    void addToList() {
        this.listeThemen.clear();
        this.addThema();
        this.listeThemen.addUrl(new String[]{"TAGE", ""});
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            MediathekArd.listeSort(this.listeThemen, 1);
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void addThema() {
        String ADRESSE = "http://www.ardmediathek.de/tv";
        String MUSTER_URL = "<a href=\"/tv/sendungen-a-z?buchstabe=";
        this.listeThemen.clear();
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.meldungStart();
        seite = this.getUrlIo.getUri(SENDERNAME, "http://www.ardmediathek.de/tv", "UTF-8", 5, seite, "");
        if (seite.length() == 0) {
            MSLog.systemMeldung("ARD: Versuch 2");
            this.warten(120);
            seite = this.getUrlIo.getUri(SENDERNAME, "http://www.ardmediathek.de/tv", "UTF-8", 5, seite, "");
            if (seite.length() == 0) {
                MSLog.fehlerMeldung(104689736, "wieder nichts gefunden");
            }
        }
        int pos = 0;
        String url = "";
        while ((pos = seite.indexOf("<a href=\"/tv/sendungen-a-z?buchstabe=", pos)) != -1) {
            try {
                int pos1 = pos += "<a href=\"/tv/sendungen-a-z?buchstabe=".length();
                int pos2 = seite.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                if (url.equals("")) continue;
                url = "http://www.ardmediathek.de/tv/sendungen-a-z?buchstabe=" + url;
                this.feedSuchen1(url);
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(698732167, ex, "kein Thema");
            }
        }
    }

    private void feedSuchen1(String strUrlFeed) {
        String MUSTER = "<div class=\"media mediaA\">";
        this.seiteFeed = this.getUrlIo.getUri(SENDERNAME, strUrlFeed, "UTF-8", 2, this.seiteFeed, "");
        if (this.seiteFeed.length() == 0) {
            MSLog.fehlerMeldung(207956317, "Leere Seite: " + strUrlFeed);
            return;
        }
        int pos = this.seiteFeed.indexOf("<div class=\"media mediaA\">");
        pos += "<div class=\"media mediaA\">".length();
        while (!MSConfig.getStop() && (pos = this.seiteFeed.indexOf("<div class=\"media mediaA\">", pos)) != -1) {
            try {
                String url = this.seiteFeed.extract("<a href=\"/tv/", "\"", pos += "<div class=\"media mediaA\">".length());
                if (url.equals("")) continue;
                url = "http://www.ardmediathek.de/tv/" + url;
                String thema = this.seiteFeed.extract("<h4 class=\"headline\">", "<", pos);
                if (thema.isEmpty()) {
                    thema = this.seiteFeed.extract("title=\"", "\"", pos);
                }
                if (thema.isEmpty()) {
                    MSLog.fehlerMeldung(132326564, "Thema: " + strUrlFeed);
                }
                String[] add = new String[]{url, thema};
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(732154698, ex, "Weitere Seiten suchen");
            }
        }
    }

    private synchronized void warten(int i) {
        try {
            long warten = i * 1000;
            this.wait(warten);
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(369502367, ex, "2. Versuch");
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        ArrayList<String> liste;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private MSStringBuilder seite3;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekArd.this.wartenSeiteLaden);
            this.liste = new ArrayList();
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
        }

        @Override
        public synchronized void run() {
            try {
                String[] link;
                MediathekArd.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekArd.this.listeThemen.getListeThemen()) != null) {
                    MediathekArd.this.meldungProgress(link[0]);
                    if (link[0].equals("TAGE")) {
                        this.addTage();
                        continue;
                    }
                    this.filmSuchen1(link[0], link[1], true);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(487326921, ex);
            }
            MediathekArd.this.meldungThreadUndFertig();
        }

        private void addTage() {
            for (int i = 0; i <= 6; ++i) {
                String urlTage = "http://www.ardmediathek.de/tv/sendungVerpasst?tag=" + i;
                String MUSTER = "<span class=\"date\">";
                this.seite1 = this.getUrl.getUri_Utf(MediathekArd.SENDERNAME, urlTage, this.seite1, "");
                if (this.seite1.length() == 0) {
                    MSLog.fehlerMeldung(765323214, "Leere Seite: " + urlTage);
                    return;
                }
                int pos = 0;
                String zeit = "";
                long d = 0L;
                while (!MSConfig.getStop() && (pos = this.seite1.indexOf("<span class=\"date\">", pos)) != -1) {
                    String urlSendung;
                    zeit = this.seite1.extract("<span class=\"date\">", "<", pos) + ":00";
                    String url = this.seite1.extract("documentId=", "&", pos += "<span class=\"date\">".length());
                    if (url.contains("\"")) {
                        url = url.substring(0, url.indexOf("\""));
                    }
                    if (url.equals("")) continue;
                    url = url.replace("&amp;", "&");
                    String thema = this.seite1.extract("<span class=\"titel\">", "<", pos);
                    if (thema.endsWith("Uhr") && thema.contains(",")) {
                        thema = thema.substring(0, thema.indexOf(","));
                    }
                    String datum = this.seite1.extract("<title>Videos (TV-Sendungen) des Senders Das Erste vom", "- ARD").trim();
                    String titel = this.seite1.extract("<h4 class=\"headline\">", "<", pos);
                    String dauer = this.seite1.extract("<p class=\"subtitle\">", "<", pos);
                    try {
                        dauer = dauer.replace("Min.", "").trim();
                        dauer = dauer.replace("| UT", "").trim();
                        d = Long.parseLong(dauer) * 60L;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (d == 0L) {
                        MSLog.fehlerMeldung(915263621, "Dauer==0: " + urlTage);
                    }
                    if (!(urlSendung = this.seite1.extract("<a href=\"/tv/", "\"", pos)).isEmpty()) {
                        urlSendung = "http://www.ardmediathek.de/tv/" + urlSendung;
                        urlSendung = urlSendung.replace("&amp;", "&");
                    }
                    this.filmSuchen2(url, thema, titel, d, datum, zeit, urlSendung);
                }
            }
        }

        private void filmSuchen1(String strUrlFeed, String thema, boolean weiter) {
            String MUSTER = "<div class=\"mediaCon\">";
            String MUSTER_START = "Beitr\u00e4ge der Sendung";
            this.seite1 = this.getUrl.getUri_Utf(MediathekArd.SENDERNAME, strUrlFeed, this.seite1, "");
            if (this.seite1.length() == 0) {
                MSLog.fehlerMeldung(765323214, "Leere Seite: " + strUrlFeed);
                return;
            }
            int pos = 0;
            String zeit = "";
            long d = 0L;
            int count = 0;
            pos = this.seite1.indexOf("Beitr\u00e4ge der Sendung");
            if (pos != -1) {
                pos += "Beitr\u00e4ge der Sendung".length();
            } else {
                return;
            }
            while (!MSConfig.getStop() && (pos = this.seite1.indexOf("<div class=\"mediaCon\">", pos)) != -1 && (MSConfig.loadLongMax() || ++count <= 5 || thema.equalsIgnoreCase("alpha-Centauri"))) {
                String urlSendung;
                String url = this.seite1.extract("documentId=", "&", pos += "<div class=\"mediaCon\">".length());
                if (url.contains("\"")) {
                    url = url.substring(0, url.indexOf("\""));
                }
                if (url.equals("")) continue;
                url = url.replace("&amp;", "&");
                String datum = this.seite1.extract("<p class=\"dachzeile\">", "<", pos);
                if ((datum = datum.replace("Uhr", "").trim()).contains("|")) {
                    zeit = datum.substring(datum.indexOf("|") + 1).trim();
                    zeit = zeit + ":00";
                    datum = datum.substring(0, datum.indexOf("|")).trim();
                }
                String titel = this.seite1.extract("<h4 class=\"headline\">", "<", pos);
                String dauer = this.seite1.extract("<p class=\"subtitle\">", "<", pos);
                try {
                    dauer = dauer.replace("Min.", "").trim();
                    dauer = dauer.replace("| UT", "").trim();
                    d = Long.parseLong(dauer) * 60L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d == 0L) {
                    MSLog.fehlerMeldung(915263621, "Dauer==0: " + strUrlFeed);
                }
                if (!(urlSendung = this.seite1.extract("<a href=\"/tv/", "\"", pos)).isEmpty()) {
                    urlSendung = "http://www.ardmediathek.de/tv/" + urlSendung;
                    urlSendung = urlSendung.replace("&amp;", "&");
                }
                this.filmSuchen2(url, thema, titel, d, datum, zeit, urlSendung);
            }
            if (weiter && MSConfig.loadLongMax() || weiter && thema.equalsIgnoreCase("alpha-Centauri")) {
                int maxWeiter = 0;
                int maxTh = 10;
                String urlWeiter = strUrlFeed + "&mcontents=page.";
                int i = 2;
                while (i < maxTh && this.seite1.indexOf("&amp;mcontents=page." + i) != -1) {
                    maxWeiter = i++;
                }
                for (i = 2; i < maxTh && i <= maxWeiter; ++i) {
                    this.filmSuchen1(urlWeiter + i, thema, false);
                }
            }
        }

        private void filmSuchen2(String urlFilm_, String thema, String titel, long dauer, String datum, String zeit, String urlSendung) {
            try {
                String subtitle;
                String urlFilm = "http://www.ardmediathek.de/play/media/" + urlFilm_ + "?devicetype=pc&features=flash";
                MediathekArd.this.meldung(urlFilm);
                this.seite2 = this.getUrl.getUri_Utf(MediathekArd.SENDERNAME, urlFilm, this.seite2, "");
                if (this.seite2.length() == 0) {
                    MSLog.fehlerMeldung(915263621, "Leere Seite: " + urlFilm);
                    return;
                }
                String url = "";
                String urlMid = "";
                String urlKl = "";
                String urlHD = "";
                String urlTest = "";
                this.liste.clear();
                url = this.getUrl(this.seite2, 2);
                this.seite2.extractList("{\"_quality\":3,\"_server\":\"\",\"_cdn\":\"default\",\"_stream\":\"", "\"", this.liste);
                this.seite2.extractList("_quality\":3,\"_stream\":[\"", "\"", this.liste);
                this.seite2.extractList("\"_quality\":3,\"_server\":\"\",\"_cdn\":\"akamai\",\"_stream\":\"", "\"", this.liste);
                if (this.seite2.indexOf("quality\":3") < 0 || this.liste.size() <= 0) {
                    // empty if block
                }
                for (String s : this.liste) {
                    if (!s.startsWith("http")) continue;
                    urlHD = s;
                    break;
                }
                this.liste.clear();
                this.seite2.extractList("\"_quality\":2", "\"_stream\":\"", "\"", this.liste);
                this.seite2.extractList("\"_quality\":2", "\"_stream\":[\"", "\"", this.liste);
                for (String s : this.liste) {
                    if (!s.startsWith("http")) continue;
                    if (url.isEmpty()) {
                        url = s;
                        break;
                    }
                    urlMid = s;
                    break;
                }
                this.liste.clear();
                this.seite2.extractList("\"_quality\":1", "\"_stream\":\"", "\"", this.liste);
                this.seite2.extractList("\"_quality\":1", "\"_stream\":[\"", "\"", this.liste);
                for (String s : this.liste) {
                    if (!s.startsWith("http")) continue;
                    urlKl = s;
                    break;
                }
                if (!urlTest.isEmpty() && (urlTest.equals(url) || urlTest.equals(urlKl))) {
                    urlHD = "";
                }
                if (urlTest.isEmpty() || urlTest.equals(url) || !urlTest.equals(urlMid)) {
                    // empty if block
                }
                if (!(url.isEmpty() && urlMid.isEmpty() && urlKl.isEmpty() && thema.equals("alpha-Centauri"))) {
                    // empty if block
                }
                if (urlMid.isEmpty()) {
                    // empty if block
                }
                if (urlKl.isEmpty()) {
                    // empty if block
                }
                if (url.isEmpty()) {
                    url = urlMid;
                    urlMid = "";
                }
                if (url.isEmpty()) {
                    url = urlKl;
                    urlKl = "";
                }
                if (url.isEmpty() && !urlHD.isEmpty()) {
                    url = urlHD;
                    urlHD = "";
                }
                if (urlKl.isEmpty()) {
                    urlKl = urlMid;
                }
                if (!(subtitle = this.seite2.extract("subtitleUrl\":\"", "\"")).isEmpty() && !subtitle.startsWith("http://www.ardmediathek.de")) {
                    subtitle = "http://www.ardmediathek.de" + subtitle;
                }
                if (!url.isEmpty()) {
                    if (url.contains("?url=")) {
                        url = url.substring(0, url.indexOf("?url="));
                    }
                    if (urlKl.contains("?url=")) {
                        urlKl = url.substring(0, urlKl.indexOf("?url="));
                    }
                    if (urlHD.contains("?url=")) {
                        urlHD = url.substring(0, urlHD.indexOf("?url="));
                    }
                    String beschreibung = this.beschreibung(urlSendung);
                    DatenFilm f = new DatenFilm(MediathekArd.SENDERNAME, thema, urlSendung, titel, url, "", datum, zeit, dauer, beschreibung);
                    if (!urlKl.isEmpty()) {
                        f.addUrlKlein(urlKl, "");
                    }
                    if (!urlHD.isEmpty() && !urlHD.equals(url)) {
                        f.addUrlHd(urlHD, "");
                    }
                    if (!subtitle.isEmpty()) {
                        f.addUrlSubtitle(subtitle);
                    }
                    MediathekArd.this.addFilm(f);
                } else {
                    this.filmSuchen_old(urlSendung, thema, titel, dauer, datum, zeit);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(762139874, ex);
            }
        }

        private String getUrl(MSStringBuilder seite, int q) {
            String ret = "";
            seite.extractList("\"_quality\":2,\"_stream\":[", "]", this.liste);
            for (String s : this.liste) {
                if ((s = s.replace("\"", "")).contains(",")) {
                    String[] ar;
                    for (String ss : ar = s.split(",")) {
                        if (!ss.startsWith("http")) continue;
                        ret = ss;
                    }
                }
                if (ret.isEmpty()) continue;
                break;
            }
            this.liste.clear();
            return ret;
        }

        private void filmSuchen_old(String urlSendung, String thema, String titel, long dauer, String datum, String zeit) {
            try {
                MediathekArd.this.meldung(urlSendung);
                this.seite2 = this.getUrl.getUri_Utf(MediathekArd.SENDERNAME, urlSendung, this.seite2, "");
                if (this.seite2.length() == 0) {
                    MSLog.fehlerMeldung(612031478, "Leere Seite: " + urlSendung);
                    return;
                }
                String url = this.seite2.extract("</li><li data-ctrl-", "http://", ".m3u8");
                if (!url.isEmpty()) {
                    url = "http://" + url + ".m3u8";
                }
                if (!url.isEmpty()) {
                    String beschreibung = this.beschreibung(urlSendung);
                    DatenFilm f = new DatenFilm(MediathekArd.SENDERNAME, thema, urlSendung, titel, url, "", datum, zeit, dauer, beschreibung);
                    MediathekArd.this.addFilm(f);
                } else {
                    MSLog.fehlerMeldung(974125698, "keine URL: " + urlSendung);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(102054784, ex);
            }
        }

        private String beschreibung(String strUrlFeed) {
            this.seite3 = this.getUrl.getUri_Utf(MediathekArd.SENDERNAME, strUrlFeed, this.seite3, "");
            if (this.seite3.length() == 0) {
                MSLog.fehlerMeldung(784512036, "Leere Seite: " + strUrlFeed);
                return "";
            }
            return this.seite3.extract("<p class=\"subtitle\">", "<p class=\"teasertext\" itemprop=\"description\">", "<");
        }
    }
}

