/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beans.editors;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jdesktop.beans.editors.PainterPropertyEditor;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.Painter;

public class PainterUtil {
    private PainterUtil() {
    }

    public static Painter loadPainter(File file) throws FileNotFoundException, MalformedURLException, IOException {
        return PainterUtil.loadPainter(file.toURI().toURL(), file.toURI().toURL());
    }

    private static Painter loadPainter(URL in, URL baseURL) throws FileNotFoundException, IOException {
        Thread.currentThread().setContextClassLoader(PainterUtil.class.getClassLoader());
        XMLDecoder dec = new XMLDecoder(in.openStream());
        dec.setOwner(new PersistenceOwner(baseURL));
        dec.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        });
        Object obj = dec.readObject();
        return (Painter)obj;
    }

    public static Painter loadPainter(URL url) throws IOException {
        return PainterUtil.loadPainter(url, url);
    }

    public static void savePainterToFile(Painter compoundPainter, File file) throws IOException {
        PainterUtil.savePainterToFile(compoundPainter, file, file.getParentFile().toURI().toURL());
    }

    public static void savePainterToFile(Painter compoundPainter, File file, URL baseURL) throws IOException {
        PainterUtil.setTransient(ImagePainter.class, "image");
        PainterUtil.setTransient(ImagePainter.class, "imageString");
        XMLEncoder e = new XMLEncoder(new FileOutputStream(file));
        e.setOwner(new PersistenceOwner(baseURL));
        e.setPersistenceDelegate(AbstractPainter.Interpolation.class, new TypeSafeEnumPersistenceDelegate());
        e.setPersistenceDelegate(AbstractAreaPainter.Style.class, new TypeSafeEnumPersistenceDelegate());
        e.setPersistenceDelegate(AbstractLayoutPainter.HorizontalAlignment.class, new TypeSafeEnumPersistenceDelegate());
        e.setPersistenceDelegate(AbstractLayoutPainter.VerticalAlignment.class, new TypeSafeEnumPersistenceDelegate());
        e.setPersistenceDelegate(AbstractPainter.class, new AbstractPainterDelegate());
        e.setPersistenceDelegate(ImagePainter.class, new ImagePainterDelegate());
        e.setPersistenceDelegate(RenderingHints.class, new RenderingHintsDelegate());
        e.setPersistenceDelegate(GradientPaint.class, new PainterPropertyEditor.GradientPaintDelegate());
        e.setPersistenceDelegate(Arc2D.Float.class, new PainterPropertyEditor.Arc2DDelegate());
        e.setPersistenceDelegate(Arc2D.Double.class, new PainterPropertyEditor.Arc2DDelegate());
        e.setPersistenceDelegate(CubicCurve2D.Float.class, new PainterPropertyEditor.CubicCurve2DDelegate());
        e.setPersistenceDelegate(CubicCurve2D.Double.class, new PainterPropertyEditor.CubicCurve2DDelegate());
        e.setPersistenceDelegate(Ellipse2D.Float.class, new PainterPropertyEditor.Ellipse2DDelegate());
        e.setPersistenceDelegate(Ellipse2D.Double.class, new PainterPropertyEditor.Ellipse2DDelegate());
        e.setPersistenceDelegate(Line2D.Float.class, new PainterPropertyEditor.Line2DDelegate());
        e.setPersistenceDelegate(Line2D.Double.class, new PainterPropertyEditor.Line2DDelegate());
        e.setPersistenceDelegate(Point2D.Float.class, new PainterPropertyEditor.Point2DDelegate());
        e.setPersistenceDelegate(Point2D.Double.class, new PainterPropertyEditor.Point2DDelegate());
        e.setPersistenceDelegate(QuadCurve2D.Float.class, new PainterPropertyEditor.QuadCurve2DDelegate());
        e.setPersistenceDelegate(QuadCurve2D.Double.class, new PainterPropertyEditor.QuadCurve2DDelegate());
        e.setPersistenceDelegate(Rectangle2D.Float.class, new PainterPropertyEditor.Rectangle2DDelegate());
        e.setPersistenceDelegate(Rectangle2D.Double.class, new PainterPropertyEditor.Rectangle2DDelegate());
        e.setPersistenceDelegate(RoundRectangle2D.Float.class, new PainterPropertyEditor.RoundRectangle2DDelegate());
        e.setPersistenceDelegate(RoundRectangle2D.Double.class, new PainterPropertyEditor.RoundRectangle2DDelegate());
        e.setPersistenceDelegate(Area.class, new PainterPropertyEditor.AreaDelegate());
        e.setPersistenceDelegate(GeneralPath.class, new PainterPropertyEditor.GeneralPathDelegate());
        e.setPersistenceDelegate(AffineTransform.class, new PainterPropertyEditor.AffineTransformDelegate());
        e.setPersistenceDelegate(RadialGradientPaint.class, new PainterPropertyEditor.RadialGradientPaintDelegate());
        e.setPersistenceDelegate(LinearGradientPaint.class, new PainterPropertyEditor.LinearGradientPaintDelegate());
        e.setPersistenceDelegate(Insets.class, new PainterPropertyEditor.InsetsDelegate());
        e.writeObject(compoundPainter);
        e.close();
    }

    private static void setTransient(Class clazz, String property) {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (!pd.getName().equals(property)) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void savePainterToImage(JComponent testPanel, CompoundPainter compoundPainter, File file) throws IOException {
        BufferedImage img = new BufferedImage(testPanel.getWidth(), testPanel.getHeight(), 2);
        Graphics2D g = img.createGraphics();
        PainterUtil.setBGP(testPanel, (Painter)compoundPainter);
        testPanel.paint(g);
        ImageIO.write((RenderedImage)img, "png", file);
    }

    public static void setBGP(JComponent comp, Painter painter) {
        if (comp instanceof JXPanel) {
            ((JXPanel)comp).setBackgroundPainter(painter);
        }
        if (comp instanceof JXButton) {
            ((JXButton)comp).setBackgroundPainter(painter);
        }
    }

    public static void setFGP(JComponent comp, Painter painter) {
        if (comp instanceof JXLabel) {
            ((JXLabel)comp).setForegroundPainter(painter);
        }
        if (comp instanceof JXButton) {
            ((JXButton)comp).setForegroundPainter(painter);
        }
    }

    public static Painter getFGP(JComponent comp) {
        if (comp instanceof JXLabel) {
            return ((JXLabel)comp).getForegroundPainter();
        }
        if (comp instanceof JXButton) {
            return ((JXButton)comp).getForegroundPainter();
        }
        return null;
    }

    public static Painter getBGP(JComponent comp) {
        if (comp instanceof JXPanel) {
            return ((JXPanel)comp).getBackgroundPainter();
        }
        if (comp instanceof JXButton) {
            return ((JXButton)comp).getBackgroundPainter();
        }
        return null;
    }

    public static class PersistenceOwner {
        private URL baseURL;

        public PersistenceOwner(URL baseURL) {
            this.baseURL = baseURL;
        }

        public URL getBaseURL() {
            return this.baseURL;
        }

        public String toXMLURL(String url) {
            if (url.startsWith(this.baseURL.toString())) {
                url = url.substring(this.baseURL.toString().length());
            }
            return url;
        }

        public String fromXMLURL(String url) throws MalformedURLException {
            String s = new URL(this.baseURL, url).toString();
            return s;
        }
    }

    public static final class ImagePainterDelegate
    extends DefaultPersistenceDelegate {
        protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            PersistenceOwner owner = (PersistenceOwner)((XMLEncoder)out).getOwner();
            ImagePainter ip = (ImagePainter)oldInstance;
            out.writeStatement(new Statement(oldInstance, "setResolver", new Object[]{owner}));
        }
    }

    public static final class AbstractPainterDelegate
    extends DefaultPersistenceDelegate {
        protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
        }
    }

    public static final class RenderingHintsDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{null});
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            RenderingHints rh = (RenderingHints)oldInstance;
            out.writeStatement(new Statement(oldInstance, "put", new Object[]{RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON}));
        }
    }

    static class TypeSafeEnumPersistenceDelegate
    extends PersistenceDelegate {
        TypeSafeEnumPersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Class<?> type = oldInstance.getClass();
            if (!Modifier.isPublic(type.getModifiers())) {
                throw new IllegalArgumentException("Could not instantiate instance of non-public class: " + oldInstance);
            }
            for (Field field : type.getFields()) {
                int mod = field.getModifiers();
                if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod) || type != field.getDeclaringClass()) continue;
                try {
                    if (oldInstance != field.get(null)) continue;
                    return new Expression(oldInstance, field, "get", new Object[]{null});
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalArgumentException("Could not get value of the field: " + field, exception);
                }
            }
            throw new IllegalArgumentException("Could not instantiate value: " + oldInstance);
        }
    }
}

