/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.lsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.LabelUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class LSBOutputStream
extends OutputStream {
    private static LabelUtil labelUtil = LabelUtil.getInstance("LSB");
    private ImageHolder image = null;
    private int channelBitsUsed = 1;
    private int dataLength = 0;
    private String fileName = null;
    private int x = 0;
    private int y = 0;
    private int currBit = 0;
    private byte[] bitSet = null;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private OpenStegoConfig config = null;

    public LSBOutputStream(ImageHolder image, int dataLength, String fileName, OpenStegoConfig config) throws OpenStegoException {
        if (image == null || image.getImage() == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.dataLength = dataLength;
        this.imgWidth = image.getImage().getWidth();
        this.imgHeight = image.getImage().getHeight();
        this.config = config;
        BufferedImage newImg = new BufferedImage(this.imgWidth, this.imgHeight, 1);
        this.image = new ImageHolder(newImg, image.getMetadata());
        for (int x = 0; x < this.imgWidth; ++x) {
            for (int y = 0; y < this.imgHeight; ++y) {
                newImg.setRGB(x, y, image.getImage().getRGB(x, y));
            }
        }
        this.channelBitsUsed = 1;
        this.fileName = fileName;
        this.bitSet = new byte[3];
        this.writeHeader();
    }

    private void writeHeader() throws OpenStegoException {
        int channelBits = 1;
        int noOfPixels = 0;
        int headerSize = 0;
        LSBDataHeader header = null;
        try {
            noOfPixels = this.imgWidth * this.imgHeight;
            header = new LSBDataHeader(this.dataLength, channelBits, this.fileName, this.config);
            headerSize = header.getHeaderSize();
            while ((double)(noOfPixels * 3 * channelBits) / 8.0 < (double)(headerSize + this.dataLength)) {
                if (++channelBits <= ((LSBConfig)this.config).getMaxBitsUsedPerChannel()) continue;
                throw new OpenStegoException(null, "LSB", 3);
            }
            header.setChannelBitsUsed(channelBits);
            this.write(header.getHeaderData());
            if (this.currBit != 0) {
                this.currBit = 0;
                this.writeCurrentBitSet();
                this.nextPixel();
            }
            this.channelBitsUsed = channelBits;
            this.bitSet = new byte[3 * channelBits];
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    @Override
    public void write(int data) throws IOException {
        for (int bit = 0; bit < 8; ++bit) {
            this.bitSet[this.currBit] = (byte)(data >> 7 - bit & 1);
            ++this.currBit;
            if (this.currBit != this.bitSet.length) continue;
            this.currBit = 0;
            this.writeCurrentBitSet();
            this.nextPixel();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeCurrentBitSet();
    }

    @Override
    public void close() throws IOException {
        if (this.currBit != 0) {
            for (int i = this.currBit; i < this.bitSet.length; ++i) {
                this.bitSet[i] = 0;
            }
            this.currBit = 0;
            this.writeCurrentBitSet();
            this.nextPixel();
        }
        super.close();
    }

    public ImageHolder getImage() throws OpenStegoException {
        try {
            this.flush();
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
        return this.image;
    }

    private void writeCurrentBitSet() throws IOException {
        int pixel = 0;
        int offset = 0;
        int mask = 0;
        int maskPerByte = 0;
        int bitOffset = 0;
        if (this.y == this.imgHeight) {
            throw new IOException(labelUtil.getString("err.image.insufficientSize"));
        }
        maskPerByte = (int)(Math.pow(2.0, this.channelBitsUsed) - 1.0);
        mask = (maskPerByte << 16) + (maskPerByte << 8) + maskPerByte;
        pixel = this.image.getImage().getRGB(this.x, this.y) & -1 - mask;
        for (int bit = 0; bit < 3; ++bit) {
            bitOffset = 0;
            for (int i = 0; i < this.channelBitsUsed; ++i) {
                bitOffset = (bitOffset << 1) + this.bitSet[bit * this.channelBitsUsed + i];
            }
            offset = (offset << 8) + bitOffset;
        }
        this.image.getImage().setRGB(this.x, this.y, pixel + offset);
    }

    private void nextPixel() {
        ++this.x;
        if (this.x == this.imgWidth) {
            this.x = 0;
            ++this.y;
        }
    }
}

