/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.internal.ShareOption;
import org.xmind.ui.internal.ShareOptionRegistry;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class ShareDialog
extends Dialog {
    private static final String ID_KEY = "org.xmind.share.option.id";
    private static final String COLOR_BACKGROUND = "#FFFFFF";
    private static final String COLOR_SEPARATOR = "#D9D9D9";
    private static final String COLOR_TEXT = "#555555";
    private ShareOptionRegistry optionRegistry;
    private ShareOption selectedOption;
    private ResourceManager resources;
    private Listener eventHandler = new Listener(){

        public void handleEvent(Event event) {
            ShareDialog.this.handleWidgetEvent(event);
        }
    };

    public ShareDialog(Shell parentShell, ShareOptionRegistry optionRegistry) {
        super(parentShell);
        this.optionRegistry = optionRegistry;
        this.selectedOption = null;
        this.setBlockOnOpen(true);
    }

    public ShareOption getSelectedOption() {
        return this.selectedOption;
    }

    public void create() {
        super.create();
        this.getShell().setText(DialogMessages.ShareDialog_dialog_title);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)newShell);
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_BACKGROUND)));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        ShareDialog.applyDialogFont((Control)composite);
        boolean hasTopItem = this.hasEnabledItem("popular");
        boolean hasBottomItem = this.hasEnabledItem("normal");
        if (hasTopItem) {
            this.createTopSection(composite);
        }
        if (hasTopItem && hasBottomItem) {
            this.createSeparator(composite);
        }
        if (hasBottomItem) {
            this.createBottomSection(composite);
        }
        return composite;
    }

    private void createTopSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayout layout = new GridLayout(3, true);
        layout.marginWidth = 31;
        layout.marginHeight = 26;
        layout.marginTop = 10;
        layout.horizontalSpacing = 20;
        composite.setLayout((Layout)layout);
        List<ShareOption> options = this.optionRegistry.getOptionsByCategory("popular");
        for (ShareOption option : options) {
            boolean disabled;
            boolean bl = disabled = this.isCnUser() && "cn".equals(option.getDisabledSite());
            if (disabled) continue;
            this.createShareItem(composite, option.getLabel(), (Image)this.resources.get((DeviceResourceDescriptor)option.getImage()), option.getId(), 3, 8);
        }
    }

    private void createSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Composite separator = new Composite(composite, 0);
        GridData layoutData2 = new GridData(4, 0x1000000, true, false);
        separator.setLayoutData((Object)layoutData2);
        layoutData2.heightHint = 1;
        separator.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_SEPARATOR)));
        separator.setLayout((Layout)new GridLayout());
    }

    private void createBottomSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 1024, true, false));
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayout layout = new GridLayout(4, true);
        layout.marginWidth = 22;
        layout.marginHeight = 28;
        layout.marginBottom = 16;
        layout.horizontalSpacing = 38;
        layout.verticalSpacing = 24;
        composite.setLayout((Layout)layout);
        List<ShareOption> options = this.optionRegistry.getOptionsByCategory("normal");
        for (ShareOption option : options) {
            boolean disabled;
            boolean bl = disabled = this.isCnUser() && "cn".equals(option.getDisabledSite());
            if (disabled) continue;
            this.createShareItem(composite, option.getLabel(), (Image)this.resources.get((DeviceResourceDescriptor)option.getImage()), option.getId(), 0, 5);
        }
    }

    private Control createShareItem(Composite parent, String text, Image image, String id, int relativeHeight, int verticalSpacing) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = verticalSpacing;
        composite.setLayout((Layout)layout);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setBackground(composite.getBackground());
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        imageLabel.setImage(image);
        Label textLabel = new Label(composite, 64);
        textLabel.setBackground(composite.getBackground());
        GridData layoutData = new GridData(0x1000000, 128, false, false);
        layoutData.widthHint = image.getBounds().width + 20;
        textLabel.setLayoutData((Object)layoutData);
        textLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_TEXT)));
        textLabel.setAlignment(0x1000000);
        textLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])textLabel.getFont().getFontData(), (int)relativeHeight))));
        textLabel.setText(text);
        composite.setCursor(parent.getDisplay().getSystemCursor(21));
        imageLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        textLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        composite.setData(ID_KEY, (Object)id);
        imageLabel.setData(ID_KEY, (Object)id);
        textLabel.setData(ID_KEY, (Object)id);
        this.hookWidget((Widget)composite, 3);
        this.hookWidget((Widget)imageLabel, 3);
        this.hookWidget((Widget)textLabel, 3);
        return composite;
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, this.eventHandler);
    }

    private void handleWidgetEvent(Event event) {
        String id = (String)event.widget.getData(ID_KEY);
        if (id == null) {
            return;
        }
        this.selectedOption = this.optionRegistry.getOptionById(id);
        if (this.selectedOption == null) {
            return;
        }
        this.okPressed();
    }

    private boolean hasEnabledItem(String category) {
        List<ShareOption> options = this.optionRegistry.getOptionsByCategory(category);
        for (ShareOption option : options) {
            boolean disabled;
            boolean bl = disabled = this.isCnUser() && "cn".equals(option.getDisabledSite());
            if (disabled) continue;
            return true;
        }
        return false;
    }

    private boolean isCnUser() {
        String cnUser = System.getProperty("account.cnUser");
        boolean isCnUser = "true".equals(cnUser);
        return isCnUser;
    }
}

