/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.IEditorHistory;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;

@Deprecated
public class EditorHistoryPersistenceService
implements IEditorHistory.IEditorHistoryListener,
IWorkbenchListener {
    public static final String VALUE_SEPARATOR = "#$#";
    private static final String KEY_PREFIX = "item.";
    private static final String FILE_NAME = "workbookHistory.properties";
    private Thread thread = null;
    private URI[] contentToSave = null;
    private Object contentNotifier = new Object();
    private static EditorHistoryPersistenceService INSTANCE = new EditorHistoryPersistenceService();

    public static EditorHistoryPersistenceService getInstance() {
        return INSTANCE;
    }

    public void preStartup() {
        IWorkbench wb = PlatformUI.getWorkbench();
        wb.addWorkbenchListener((IWorkbenchListener)this);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                EditorHistoryPersistenceService.this.runLoop();
            }
        });
        thread.setName("EditorHistoryPersistenceThread");
        thread.setPriority(1);
        thread.setDaemon(true);
        this.thread = thread;
        thread.start();
        MindMapUI.getEditorHistory().addEditorHistoryListener(this);
        this.editorHistoryChanged();
    }

    public void postShutdown(IWorkbench workbench) {
        MindMapUI.getEditorHistory().removeEditorHistoryListener(this);
        Thread thread = this.thread;
        this.thread = null;
        if (thread != null) {
            thread.interrupt();
        }
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editorHistoryChanged() {
        URI[] inputURIs = MindMapUI.getEditorHistory().getAllInputURIs();
        URI[] content = new URI[inputURIs.length];
        System.arraycopy(inputURIs, 0, content, 0, inputURIs.length);
        Object object = this.contentNotifier;
        synchronized (object) {
            this.contentToSave = content;
            this.contentNotifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoop() {
        try {
            Object object = this.contentNotifier;
            synchronized (object) {
                while (this.thread != null) {
                    this.contentNotifier.wait();
                    URI[] content = null;
                    if (this.contentToSave != null) {
                        content = new URI[this.contentToSave.length];
                        System.arraycopy(this.contentToSave, 0, content, 0, this.contentToSave.length);
                    }
                    if (content != null) {
                        EditorHistoryPersistenceService.save(content);
                    }
                    Thread.sleep(0L);
                }
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private static void save(URI[] content) {
        Properties repository = new Properties();
        IEditorHistory editorHistory = MindMapUI.getEditorHistory();
        int index = 0;
        while (index < content.length) {
            URI input = content[index];
            String info = editorHistory.getInfo(input);
            if (input != null && info != null) {
                String key = KEY_PREFIX + index;
                repository.setProperty(key, String.valueOf(input.toString()) + VALUE_SEPARATOR + info);
            }
            ++index;
        }
        File file = EditorHistoryPersistenceService.getHistoryFile();
        if (file != null) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                FileWriter writer = new FileWriter(file);
                try {
                    repository.store(writer, "Generated by org.xmind.ui.internal.editor.EditorHistoryService");
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                Logger.log(e, "Failed to save workbook history to " + file.getAbsolutePath());
            }
        }
    }

    public static List<String> load() {
        Properties repository = new Properties();
        File file = EditorHistoryPersistenceService.getHistoryFile();
        if (file != null && file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                try {
                    repository.load(reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logger.log(e, "Failed to load workbook history from " + file.getAbsolutePath());
            }
        }
        int count = 0;
        ArrayList<String> items = new ArrayList<String>();
        int size = repository.size();
        int i = 0;
        while (i < size) {
            if (count >= 100) {
                return items;
            }
            Object key = KEY_PREFIX + i;
            String value = repository.getProperty((String)key);
            if (value != null) {
                items.add(value);
                repository.remove(key);
                ++count;
            }
            ++i;
        }
        Set<Object> oldVersionKeys = repository.keySet();
        for (Object key : oldVersionKeys) {
            if (count >= 100) {
                return items;
            }
            String input = (String)key;
            String info = repository.getProperty(input);
            items.add(String.valueOf(input) + VALUE_SEPARATOR + info);
            ++count;
        }
        return items;
    }

    private static File getHistoryFile() {
        IPath basePath = MindMapUIPlugin.getDefault().getStateLocation();
        if (basePath == null) {
            return null;
        }
        IPath filePath = basePath.append(FILE_NAME);
        return filePath.toFile();
    }
}

