/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import org.json.JSONObject;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;

public class SeawindHttpException
extends HttpException {
    public static final int FORBIDDEN_BY_STORAGE_CAPACITY = 4301;
    public static final int FORBIDDEN_FOR_UNACTIVATED = 4032;
    private static final long serialVersionUID = 3237129745059862848L;
    private int subCode;
    private String errorName;
    private String errorDescription;
    private JSONObject additionalData;

    public SeawindHttpException(HttpException cause, int subCode, String errorName, String errorDescription, JSONObject additionalData) {
        super(cause.getRequest(), cause.getCode(), String.format("%s (%s %s: %s)", cause.getStatus(), subCode, errorName, errorDescription), (Throwable)cause);
        this.subCode = subCode;
        this.errorName = errorName;
        this.errorDescription = errorDescription;
        this.additionalData = additionalData;
    }

    public int getSubCode() {
        return this.subCode;
    }

    public String getErrorName() {
        return this.errorName;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public JSONObject getAdditionalData() {
        return this.additionalData;
    }

    public static HttpException unwrap(HttpException e) {
        JSONObject errorInfo;
        JSONObject data;
        HttpRequest request = e.getRequest();
        if (request != null && (data = request.getResponseAsJSON()) != null && (errorInfo = data.optJSONObject("error")) != null) {
            int subCode = errorInfo.optInt("code", 0);
            String errorName = errorInfo.optString("name", null);
            String errorDescription = errorInfo.optString("description", null);
            if (subCode > 0 && errorName != null) {
                return new SeawindHttpException(e, subCode, errorName, errorDescription, errorInfo);
            }
        }
        return e;
    }
}

