/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.Workbook;

public class SettingEntry
implements ISettingEntry {
    private final Workbook ownerWorkbook;
    private final String path;
    private Sheet targetSheet;
    private boolean orphan;
    private final Map<String, String> attributes;

    public SettingEntry(Workbook ownerWorkbook, String path) {
        this.ownerWorkbook = ownerWorkbook;
        this.path = path;
        this.targetSheet = null;
        this.orphan = true;
        this.attributes = new HashMap<String, String>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        return null;
    }

    public ISheet getOwnedSheet() {
        return this.targetSheet;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getPath() {
        return this.path;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        String oldValue = this.attributes.get(key);
        if (value == oldValue || value != null && value.equals(oldValue)) {
            return;
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        if (this.targetSheet != null) {
            CoreEvent event = new CoreEvent((ICoreEventSource)this.targetSheet, "sheetSettings", (Object)key, (Object)oldValue, (Object)value);
            event.setData((Object)this.path);
            this.targetSheet.getCoreEventSupport().dispatch((ICoreEventSource)this.targetSheet, event);
        }
    }

    public Set<String> getAttributeKeys() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    protected void setTargetSheet(Sheet targetSheet) {
        this.targetSheet = targetSheet;
    }

    protected void onParented() {
        this.orphan = false;
    }

    protected void onOrphan() {
        this.orphan = true;
    }
}

