/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IFileEntryFilter;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.plain.Manifest;
import org.xmind.core.plain.Workbook;

public class FileEntry
implements IFileEntry {
    private final Workbook ownerWorkbook;
    private final String path;
    private String mediaType;
    private int refCount;
    private boolean everReferred;

    public FileEntry(Workbook ownerWorkbook, String path, String mediaType) {
        this.ownerWorkbook = ownerWorkbook;
        this.path = path;
        this.mediaType = mediaType;
        this.refCount = 0;
        this.everReferred = false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    private Manifest getManifest() {
        return (Manifest)this.ownerWorkbook.getManifest();
    }

    public boolean isOrphan() {
        return this.refCount <= 0;
    }

    public String getPath() {
        return this.path;
    }

    public String getMediaType() {
        return this.mediaType == null ? "" : this.mediaType;
    }

    public boolean hasBeenReferred() {
        return this.everReferred;
    }

    public int getReferenceCount() {
        return this.refCount;
    }

    public void increaseReference() {
        boolean isReferred;
        boolean wasReferred = this.refCount > 0;
        ++this.refCount;
        this.everReferred = true;
        boolean bl = isReferred = this.refCount > 0;
        if (!wasReferred && isReferred) {
            this.getManifest().addFileEntry(this);
        }
    }

    public void decreaseReference() {
        boolean isReferred;
        boolean wasReferred = this.refCount > 0;
        --this.refCount;
        boolean bl = isReferred = this.refCount > 0;
        if (wasReferred && !isReferred) {
            this.getManifest().removeFileEntry(this);
        }
    }

    public InputStream getInputStream() {
        try {
            return this.openInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.openOutputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean canRead() {
        IInputSource source = this.ownerWorkbook.getStorage().getInputSource();
        return source.hasEntry(this.path) && source.isEntryAvailable(this.path);
    }

    public boolean canWrite() {
        IOutputTarget target = this.ownerWorkbook.getStorage().getOutputTarget();
        return target.isEntryAvaialble(this.path);
    }

    public InputStream openInputStream() throws IOException {
        return this.ownerWorkbook.getStorage().getInputSource().openEntryStream(this.path);
    }

    public OutputStream openOutputStream() throws IOException {
        return this.ownerWorkbook.getStorage().getOutputTarget().openEntryStream(this.path);
    }

    public boolean isDirectory() {
        return this.path.endsWith("/");
    }

    public List<IFileEntry> getSubEntries() {
        if (!this.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<IFileEntry> list = new ArrayList<IFileEntry>();
        Iterator<IFileEntry> it = this.iterSubEntries();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public Iterator<IFileEntry> iterSubEntries() {
        final String parentPath = this.path;
        return this.getManifest().iterFileEntries(new IFileEntryFilter(){

            public boolean select(String path, String mediaType, boolean isDirectory) {
                return path.length() > parentPath.length() && path.startsWith(parentPath);
            }
        });
    }

    public long getTime() {
        IInputSource source = this.ownerWorkbook.getStorage().getInputSource();
        if (source.hasEntry(this.path)) {
            return source.getEntryTime(this.path);
        }
        return -1L;
    }

    public void setTime(long time) {
        this.ownerWorkbook.getStorage().getOutputTarget().setEntryTime(this.path, time);
    }

    public long getSize() {
        IInputSource source = this.ownerWorkbook.getStorage().getInputSource();
        if (source.hasEntry(this.path)) {
            return source.getEntrySize(this.path);
        }
        return -1L;
    }

    public IEncryptionData getEncryptionData() {
        return null;
    }

    public IEncryptionData createEncryptionData() {
        return null;
    }

    public void deleteEncryptionData() {
    }
}

