/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.ui.tabfolder.MTabFolder;
import org.xmind.ui.tabfolder.MTabItem;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContent {
    private static final String CONTENT_URI = "platform:/plugin/org.xmind.ui.xmindresource/xmindresource/xmindresource.xml";
    private static final String NLS_PATH_BASE = "xmindresource/xmindresource";
    private static final String TAG_XMINDRESOURCE = "xmindresource";
    private static final String TAG_PAGE = "page";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_ICON_URI = "iconURI";
    private static final String ATTR_CONTRIBUTION_URI = "contributionURI";
    private static final String DATA_ID = "org.xmind.ui.xmindresource.itemId";
    private final MTabFolder tabFolder;
    private Properties nlsProperties = new Properties();
    private List<DialogPage> pages = new ArrayList<DialogPage>();

    public ResourceContent(MTabFolder tabFolder) {
        this.tabFolder = tabFolder;
        this.loadFromDefaultLocation();
    }

    private void loadFromDefaultLocation() {
        this.nlsProperties = XMindResourcePlugin.getDefault().loadNLSProperties(NLS_PATH_BASE);
        try {
            URL docURL = new URL(CONTENT_URI);
            this.loadFromURL(docURL);
        }
        catch (Exception exception) {}
    }

    private void loadFromURL(URL docURL) throws Exception {
        InputStream docStream = docURL.openStream();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(docStream);
            Element rootElement = doc.getDocumentElement();
            if (rootElement == null || !TAG_XMINDRESOURCE.equals(rootElement.getNodeName())) {
                throw new IllegalArgumentException("No xmindresource' element in platform:/plugin/org.xmind.ui.xmindresource/xmindresource/xmindresource.xml");
            }
            this.readElement(rootElement, this.tabFolder);
        }
        finally {
            docStream.close();
        }
    }

    private void readElement(Element element, Object parent) throws Exception {
        String tagName = element.getTagName();
        Object item = parent;
        if (parent instanceof MTabFolder) {
            if (TAG_PAGE.equals(tagName)) {
                item = this.readPage(element, (MTabFolder)parent);
            }
        } else {
            boolean cfr_ignored_0 = parent instanceof MTabItem;
        }
        this.readChildren(element.getChildNodes(), item);
    }

    private void readChildren(NodeList children, Object parent) throws Exception {
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1) {
                this.readElement((Element)childNode, parent);
            }
            ++i;
        }
    }

    private MTabItem readPage(Element element, MTabFolder tabFolder) throws Exception {
        Class cls;
        String id = element.getAttribute(ATTR_ID);
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("No id for page.");
        }
        String contributionURI = element.getAttribute(ATTR_CONTRIBUTION_URI);
        if (contributionURI == null || !contributionURI.startsWith("bundleclass://")) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String[] contributionPaths = contributionURI.substring(14).split("/");
        if (contributionPaths.length != 2) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String bundleId = contributionPaths[0];
        String className = contributionPaths[1];
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                throw new ClassNotFoundException();
            }
            cls = bundle.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object contribution = cls.newInstance();
        if (!(contribution instanceof DialogPage)) {
            throw new IllegalArgumentException("Invalid contribution type: " + contribution);
        }
        final DialogPage page = (DialogPage)contribution;
        String label = this.readLabel(element);
        page.setTitle(label);
        ImageDescriptor icon = this.readIcon(element);
        page.setImageDescriptor(icon);
        MTabItem item = new MTabItem(tabFolder, 2064);
        item.setText(page.getTitle());
        item.setImage(page.getImage());
        page.createControl(this.tabFolder.getBody());
        item.setControl(page.getControl());
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control control = page.getControl();
                if (control != null) {
                    page.dispose();
                }
                page.dispose();
            }
        });
        this.pages.add(page);
        item.setData((Object)page);
        item.setData(DATA_ID, (Object)id);
        return item;
    }

    private ImageDescriptor readIcon(Element element) throws MalformedURLException {
        String iconURI = element.getAttribute(ATTR_ICON_URI);
        ImageDescriptor icon = iconURI == null || "".equals(iconURI) ? null : ImageDescriptor.createFromURL((URL)new URL(iconURI));
        return icon;
    }

    private String readLabel(Element element) {
        String nativeLabel;
        String label = element.getAttribute(ATTR_LABEL);
        if (label.startsWith("%") && (nativeLabel = this.nlsProperties.getProperty(label.substring(1))) != null) {
            label = nativeLabel;
        }
        return label;
    }

    public List<DialogPage> getPages() {
        return this.pages;
    }
}

