/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.ui.mindmap.IWorkbookRef;

public class URIUtils {
    public static final String WORKBOOK_ID = "workbookId";
    private static final String WORKBOOK_URI_SCHEME = "seawind";
    private static final String WORKBOOK_URI_PATH_TEMPLATE = "/workbooks/%s";
    private static final Pattern WORKBOOK_URI_PATH_PATTERN = Pattern.compile("/workbooks/([^/]+)");

    private URIUtils() {
    }

    public static URI toWorkbookRefURI(String workbookId) {
        Assert.isLegal((workbookId != null ? 1 : 0) != 0);
        String path = EncodingUtils.format((String)WORKBOOK_URI_PATH_TEMPLATE, (Object[])new Object[]{workbookId});
        try {
            return new URI(WORKBOOK_URI_SCHEME, null, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static Map<String, String> parseWorkbookRefURI(URI uri) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (uri == null) {
            return result;
        }
        String path = uri.getPath();
        if (path == null) {
            return result;
        }
        Matcher m = WORKBOOK_URI_PATH_PATTERN.matcher(path);
        if (!m.matches()) {
            return result;
        }
        result.put(WORKBOOK_ID, m.group(1));
        return result;
    }

    public static String getWorkbookIdFromURI(URI uri) {
        Map<String, String> result = URIUtils.parseWorkbookRefURI(uri);
        return result.get(WORKBOOK_ID);
    }

    public static boolean isSeawindWorkbookRef(Object obj) {
        return obj instanceof IWorkbookRef && URIUtils.isSeawindURI(((IWorkbookRef)obj).getURI());
    }

    public static boolean isSeawindURI(URI uri) {
        return uri != null && WORKBOOK_URI_SCHEME.equals(uri.getScheme());
    }

    public static boolean isSeawindURI(String uri) {
        try {
            return URIUtils.isSeawindURI(new URI(uri));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

