/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.xmind.ui.color.ColorBlockImageDescriptor;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.internal.properties.LinePattern;
import org.xmind.ui.internal.properties.LineWidth;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.ILabelDescriptor;

public class StylePropertyLabelDescriptor
implements ILabelDescriptor {
    private static final ColorDescriptor grayColor = ColorDescriptor.createFrom((RGB)new RGB(192, 192, 192));
    private static final ILabelDescriptor defaultInstance = new StylePropertyLabelDescriptor();
    private static final ILabelDescriptor forBlank = new StylePropertyLabelDescriptor(){

        public String getText(Object element) {
            return null;
        }
    };
    private static final ILabelDescriptor forMultiBranchColor = new StylePropertyLabelDescriptor(){

        public String getText(Object element) {
            if (element != null && !"none".equals(element)) {
                return StyleEditorMessages.StyleProperty_PropertyValue_MultiBranchColors_MultipleColors;
            }
            return super.getText(element);
        }
    };
    private static final ILabelDescriptor forDecorations = new StylePropertyLabelDescriptor(){

        private IDecorationDescriptor findDecoration(Object element) {
            if (element instanceof IDecorationDescriptor) {
                return (IDecorationDescriptor)element;
            }
            if (element instanceof String) {
                return MindMapUI.getDecorationManager().getDecorationDescriptor((String)element);
            }
            return null;
        }

        public String getText(Object element) {
            IDecorationDescriptor descriptor = this.findDecoration(element);
            if (descriptor != null) {
                return descriptor.getName();
            }
            return super.getText(element);
        }

        public ImageDescriptor getImage(Object element) {
            IDecorationDescriptor descriptor = this.findDecoration(element);
            if (descriptor != null) {
                return descriptor.getIcon();
            }
            return super.getImage(element);
        }
    };
    private static final ILabelDescriptor forAlignments = new StylePropertyLabelDescriptor(){

        public String getText(Object element) {
            if ("left".equals(element)) {
                return PropertyMessages.TextAlignLeft_text;
            }
            if ("center".equals(element)) {
                return PropertyMessages.TextAlignCenter_text;
            }
            if ("right".equals(element)) {
                return PropertyMessages.TextAlignRight_text;
            }
            return super.getText(element);
        }

        public ImageDescriptor getImage(Object element) {
            if ("left".equals(element)) {
                return MindMapUI.getImages().get("align_left.png", true);
            }
            if ("center".equals(element)) {
                return MindMapUI.getImages().get("align_center.png", true);
            }
            if ("right".equals(element)) {
                return MindMapUI.getImages().get("align_right.png", true);
            }
            return super.getImage(element);
        }
    };
    private static final ILabelDescriptor forTextCase = new StylePropertyLabelDescriptor(){

        public String getText(Object element) {
            if ("manual".equals(element)) {
                return PropertyMessages.TextManual_text;
            }
            if ("uppercase".equals(element)) {
                return PropertyMessages.TextUppercase_text;
            }
            if ("lowercase".equals(element)) {
                return PropertyMessages.TextLowercase_text;
            }
            if ("capitalize".equals(element)) {
                return PropertyMessages.TextCapitalize_text;
            }
            return super.getText(element);
        }

        public ImageDescriptor getImage(Object element) {
            if ("manual".equals(element)) {
                return MindMapUI.getImages().get("text_manual.png", true);
            }
            if ("uppercase".equals(element)) {
                return MindMapUI.getImages().get("text_uppercase.png", true);
            }
            if ("lowercase".equals(element)) {
                return MindMapUI.getImages().get("text_lowercase.png", true);
            }
            if ("capitalize".equals(element)) {
                return MindMapUI.getImages().get("text_capitalize.png", true);
            }
            return super.getImage(element);
        }
    };
    private static final ILabelDescriptor forLineWidths = new StylePropertyLabelDescriptor(){

        private LineWidth findValue(Object element) {
            if (element instanceof LineWidth) {
                return (LineWidth)element;
            }
            if (element instanceof String) {
                return LineWidth.findByValue((String)((String)element));
            }
            return null;
        }

        public String getText(Object element) {
            LineWidth value = this.findValue(element);
            if (value != null) {
                return value.getName();
            }
            return super.getText(element);
        }

        public ImageDescriptor getImage(Object element) {
            LineWidth value = this.findValue(element);
            if (value != null) {
                return value.getIcon();
            }
            return super.getImage(element);
        }
    };
    private static final ILabelDescriptor forLinePatterns = new StylePropertyLabelDescriptor(){

        private LinePattern findValue(Object element) {
            if (element instanceof LinePattern) {
                return (LinePattern)element;
            }
            if (element instanceof String) {
                return LinePattern.findByValue((String)((String)element));
            }
            return null;
        }

        public String getText(Object element) {
            LinePattern value = this.findValue(element);
            if (value != null) {
                return value.getName();
            }
            return super.getText(element);
        }

        public ImageDescriptor getImage(Object element) {
            LinePattern value = this.findValue(element);
            if (value != null) {
                return value.getIcon();
            }
            return super.getImage(element);
        }
    };
    private static final ILabelDescriptor forOpacities = new StylePropertyLabelDescriptor(){

        public String getText(Object element) {
            if (element instanceof String) {
                try {
                    double opacity = Double.parseDouble((String)element);
                    return String.format("%.0f %%", opacity * 100.0);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return super.getText(element);
        }
    };
    private static final ILabelDescriptor forColors = new StylePropertyLabelDescriptor(){

        public ImageDescriptor getImage(Object element) {
            RGB color;
            if ("none".equals(element) || "$system$".equals(element)) {
                return null;
            }
            if (element instanceof String && (color = ColorUtils.toRGB((String)((String)element))) != null) {
                return ColorBlockImageDescriptor.createFromRGB((RGB)color);
            }
            return super.getImage(element);
        }
    };
    private static final ILabelDescriptor forFontSize = new StylePropertyLabelDescriptor(){

        public String getText(Object element) {
            String value;
            if (element instanceof String && (value = (String)element).endsWith("pt")) {
                return value.substring(0, value.length() - 2);
            }
            return super.getText(element);
        }
    };
    private static final ILabelDescriptor forTextStyles = new StylePropertyLabelDescriptor(){

        public String getText(Object element) {
            if ("italic".equals(element)) {
                return StyleEditorMessages.StyleProperty_PropertyValue_FontStyle_Italic;
            }
            if ("bold".equals(element)) {
                return StyleEditorMessages.StyleProperty_PropertyValue_FontWeight_Bold;
            }
            if ("line-through".equals(element)) {
                return StyleEditorMessages.StyleProperty_PropertyValue_TextDecoration_LineThrough;
            }
            if ("underline".equals(element)) {
                return StyleEditorMessages.StyleProperty_PropertyValue_TextDecoration_Underline;
            }
            if ("underline line-through".equals(element)) {
                return StyleEditorMessages.StyleProperty_PropertyValue_TextDecoration_UnderlineAndLineThrough;
            }
            return super.getText(element);
        }
    };

    protected StylePropertyLabelDescriptor() {
    }

    public String getText(Object element) {
        if (element == null) {
            return StyleEditorMessages.StyleProperty_PropertyValue_Default;
        }
        if ("none".equals(element)) {
            return StyleEditorMessages.StyleProperty_PropertyValue_None;
        }
        if ("$system$".equals(element)) {
            return StyleEditorMessages.StyleProperty_PropertyValue_System;
        }
        if ("normal".equals(element)) {
            return StyleEditorMessages.StyleProperty_PropertyValue_Normal;
        }
        return element.toString();
    }

    public ImageDescriptor getImage(Object element) {
        return null;
    }

    public ColorDescriptor getForeground(Object element) {
        if (element == null) {
            return grayColor;
        }
        return null;
    }

    public ColorDescriptor getBackground(Object element) {
        return null;
    }

    public FontDescriptor getFont(Object element) {
        return null;
    }

    public static ILabelDescriptor getDefault() {
        return defaultInstance;
    }

    public static ILabelDescriptor getBlank() {
        return forBlank;
    }

    public static ILabelDescriptor forColors() {
        return forColors;
    }

    public static ILabelDescriptor forDecorations() {
        return forDecorations;
    }

    public static ILabelDescriptor forAlignments() {
        return forAlignments;
    }

    public static ILabelDescriptor forTextCase() {
        return forTextCase;
    }

    public static ILabelDescriptor forLineWidths() {
        return forLineWidths;
    }

    public static ILabelDescriptor forLinePatterns() {
        return forLinePatterns;
    }

    public static ILabelDescriptor forOpacities() {
        return forOpacities;
    }

    public static ILabelDescriptor forFontSize() {
        return forFontSize;
    }

    public static ILabelDescriptor forMultiBranchColor() {
        return forMultiBranchColor;
    }

    public static ILabelDescriptor forTextStyles() {
        return forTextStyles;
    }
}

