/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.views.ThemeFigure;
import org.xmind.ui.internal.views.ThemesViewer;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedThemesViewer
extends ThemesViewer
implements ICoreEventListener {
    public static final Object ADD_THEME = "ADD_THEME";
    private ICoreEventRegister register;

    public AdvancedThemesViewer(Composite parent) {
        super(parent);
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserThemeSheet().getAdapter(ICoreEventSupport.class);
        if (ces != null) {
            this.register = new CoreEventRegister((ICoreEventListener)this);
            this.register.setNextSupport(ces);
            this.register.register("styleAdd");
            this.register.register("styleRemove");
            this.register.register("name");
        }
    }

    protected void init() {
        super.init();
        this.setPartFactory(new AdvancedThemePartFactory(this.getPartFactory()));
        this.setLabelProvider((IBaseLabelProvider)new AdvancedThemeLabelProvider());
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(128, 64));
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.register != null) {
            this.register.unregisterAll();
        }
        super.handleDispose(event);
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            public void run() {
                if ("name".equals(event.getType())) {
                    AdvancedThemesViewer.this.refresh();
                } else {
                    Object target = event.getTarget();
                    if (target instanceof IStyle && !((IStyle)target).getType().equals("theme")) {
                        return;
                    }
                    if (event.getType().equals("styleRemove")) {
                        AdvancedThemesViewer.this.setSelection((ISelection)new StructuredSelection((Object)MindMapUI.getResourceManager().getBlankTheme()));
                    }
                    AdvancedThemesViewer.this.setInput(AdvancedThemesViewer.this.getThemeViewerInput());
                }
            }
        });
    }

    private Object getThemeViewerInput() {
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        IStyleSheet systemThemeSheets = resourceManager.getSystemThemeSheet();
        Set systemThemes = systemThemeSheets.getStyles("master-styles");
        IStyleSheet userThemeSheets = resourceManager.getUserThemeSheet();
        Set userThemes = userThemeSheets.getStyles("master-styles");
        ArrayList<Object> list = new ArrayList<Object>(systemThemes.size() + userThemes.size() + 2);
        list.add(ADD_THEME);
        list.addAll(this.getReversed(userThemes));
        list.addAll(systemThemes);
        list.add(resourceManager.getBlankTheme());
        return list;
    }

    private List<Object> getReversed(Collection<?> sourceList) {
        LinkedList<Object> targetList = new LinkedList<Object>();
        for (Object item : sourceList) {
            targetList.add(0, item);
        }
        return targetList;
    }

    private static class AdvancedThemeLabelProvider
    extends LabelProvider {
        private AdvancedThemeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getName();
            }
            if (element instanceof String) {
                return null;
            }
            return super.getText(element);
        }
    }

    private static class AdvancedThemePart
    extends GraphicalEditPart {
        public AdvancedThemePart(Object style) {
            this.setModel(style);
        }

        public IStyle getStyle() {
            if (super.getModel() == ADD_THEME) {
                return null;
            }
            return (IStyle)super.getModel();
        }

        protected IFigure createFigure() {
            if (super.getModel() == ADD_THEME) {
                return new ThemeADDFigure();
            }
            return new ThemeFigure();
        }

        protected void updateView() {
            super.updateView();
            if (super.getModel() == ADD_THEME) {
                this.getFigure().setPreferredSize(new Dimension(64, 64));
                return;
            }
            ((ThemeFigure)this.getFigure()).setTheme(this.getStyle());
            Properties properties = ((GalleryViewer)this.getSite().getViewer()).getProperties();
            Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            if (size != null) {
                this.getFigure().setPreferredSize(size);
            }
        }

        protected void register() {
            IStyle style = this.getStyle();
            if (style != null) {
                this.registerModel(style.getId());
            } else {
                this.registerModel(ADD_THEME);
            }
            super.register();
        }

        protected void unregister() {
            super.unregister();
            IStyle style = this.getStyle();
            if (style != null) {
                this.unregisterModel(style.getId());
            } else {
                this.unregisterModel(ADD_THEME);
            }
        }
    }

    private static class AdvancedThemePartFactory
    implements IPartFactory {
        private IPartFactory factory;

        public AdvancedThemePartFactory(IPartFactory factory) {
            this.factory = factory;
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof FramePart && model instanceof IStyle) {
                return new AdvancedThemePart((IStyle)model);
            }
            if (context instanceof FramePart && model == ADD_THEME) {
                return new AdvancedThemePart(ADD_THEME);
            }
            return this.factory.createPart(context, model);
        }
    }

    private static class ThemeADDFigure
    extends Figure {
        private ThemeADDFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.setAntialias(1);
            graphics.setTextAntialias(1);
            Rectangle r = this.getClientArea(new Rectangle());
            graphics.setBackgroundColor(new Color(null, 192, 192, 192));
            int[] points = new int[]{r.x + r.width * 15 / 32, r.y + r.height / 16, r.x + r.width * 17 / 32, r.y + r.height / 16, r.x + r.width * 17 / 32, r.y + r.height * 15 / 32, r.x + r.width * 30 / 32, r.y + r.height * 15 / 32, r.x + r.width * 30 / 32, r.y + r.height * 17 / 32, r.x + r.width * 17 / 32, r.y + r.height * 17 / 32, r.x + r.width * 17 / 32, r.y + r.height * 30 / 32, r.x + r.width * 15 / 32, r.y + r.height * 30 / 32, r.x + r.width * 15 / 32, r.y + r.height * 17 / 32, r.x + r.width * 1 / 16, r.y + r.height * 17 / 32, r.x + r.width * 1 / 16, r.y + r.height * 15 / 32, r.x + r.width * 15 / 32, r.y + r.height * 15 / 32, r.x + r.width * 15 / 32, r.y + r.height / 16};
            graphics.fillPolygon(points);
        }
    }
}

