/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.xmind.cathy.internal.dashboard.CategorizedTemplateViewer;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dashboard.pages.DashboardPage;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.mindmap.IResourceManagerListener;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.MindMapUI;

public class NewFromTemplatesDashboardPage
extends DashboardPage
implements IResourceManagerListener,
IAdaptable {
    private CategorizedTemplateViewer viewer;
    private boolean templateOpening;

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        MindMapUI.getResourceManager().removeResourceManagerListener((IResourceManagerListener)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 60;
        layout.marginRight = 0;
        layout.marginHeight = 7;
        container.setLayout((Layout)layout);
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ShowTemplatesCount");
        this.viewer = new CategorizedTemplateViewer(container);
        Control control = this.viewer.getControl();
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (!NewFromTemplatesDashboardPage.this.templateOpening) {
                    NewFromTemplatesDashboardPage.this.handleTemplateSelected(event.getSelection());
                    MindMapUIPlugin.getDefault().getUsageDataCollector().increase("CreateWorkbookCount");
                    MindMapUIPlugin.getDefault().getUsageDataCollector().increase("UseTemplatesCount");
                }
            }
        });
        MindMapUI.getResourceManager().addResourceManagerListener((IResourceManagerListener)this);
        this.registerContextMenu(control);
        this.setControl((Control)container);
    }

    public void registerAvailableCommands() {
        IDashboardContext context = this.getContext();
        context.registerAvailableCommandId("org.xmind.ui.command.template.duplicate");
        context.registerAvailableCommandId("org.xmind.ui.command.template.rename");
        context.registerAvailableCommandId("org.xmind.ui.command.template.delete");
    }

    private void registerContextMenu(Control control) {
        this.getContext().registerContextMenu((Object)control, "org.xmind.ui.popup.template");
        Object input = this.viewer.getInput();
        if (input instanceof Object[]) {
            Object[] groups;
            Object[] objectArray = groups = (Object[])this.viewer.getInput();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Object group = objectArray[n2];
                GalleryViewer nestedViewer = this.viewer.getNestedViewer(group);
                if (nestedViewer != null) {
                    nestedViewer.getControl().setMenu(control.getMenu());
                }
                ++n2;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        }
    }

    public void userTemplateAdded(ITemplate template) {
        if (this.viewer != null) {
            this.viewer.userTemplateAdded(template);
        }
    }

    public void userTemplateRemoved(ITemplate template) {
        if (this.viewer != null) {
            this.viewer.userTemplateRemoved(template);
        }
    }

    private void handleTemplateSelected(ISelection selection) {
        this.templateOpening = true;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NewFromTemplatesDashboardPage.this.viewer == null || NewFromTemplatesDashboardPage.this.viewer.getControl() == null || NewFromTemplatesDashboardPage.this.viewer.getControl().isDisposed()) {
                    return;
                }
                NewFromTemplatesDashboardPage.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.templateOpening = false;
            return;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement == null || !(selectedElement instanceof ITemplate)) {
            return;
        }
        ITemplate template = (ITemplate)selectedElement;
        if (template != null && template.getName() != null) {
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase(String.format("Template/UseCount/%s", template.getName().replaceAll(" ", "_")));
        }
        IEditorInput editorInput = MindMapUI.getEditorInputFactory().createEditorInput(template.createWorkbookRef());
        this.getContext().openEditor(editorInput, "org.xmind.ui.MindMapEditor");
        this.templateOpening = false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.viewer != null) {
            if (adapter.isAssignableFrom(((Object)((Object)this.viewer)).getClass())) {
                return adapter.cast((Object)this.viewer);
            }
            T obj = this.viewer.getAdapter(adapter);
            if (obj != null) {
                return obj;
            }
        }
        return null;
    }
}

