/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimBarLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSPropertyMarginXHandler
extends AbstractCSSPropertySWTHandler {
    public static final CSSPropertyMarginXHandler INSTANCE = new CSSPropertyMarginXHandler();
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof Composite)) {
            return;
        }
        Composite composite = (Composite)control;
        if ("xmind-margin".equals(property)) {
            this.applyCSSPropertyMargin(composite, value, pseudo, engine);
        } else if ("xmind-margin-top".equals(property)) {
            this.applyCSSPropertyMarginTop(composite, value, pseudo, engine);
        } else if ("xmind-margin-right".equals(property)) {
            this.applyCSSPropertyMarginRight(composite, value, pseudo, engine);
        } else if ("xmind-margin-bottom".equals(property)) {
            this.applyCSSPropertyMarginBottom(composite, value, pseudo, engine);
        } else if ("xmind-margin-left".equals(property)) {
            this.applyCSSPropertyMarginLeft(composite, value, pseudo, engine);
        }
    }

    public void applyCSSPropertyMargin(Composite element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            this.setMargin(element, 0, value, pseudo);
            this.setMargin(element, 1, value, pseudo);
            this.setMargin(element, 2, value, pseudo);
            this.setMargin(element, 3, value, pseudo);
            return;
        }
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            if (length < 2 || length > 4) {
                return;
            }
            switch (length) {
                case 4: {
                    this.setMargin(element, 0, valueList.item(0), pseudo);
                    this.setMargin(element, 1, valueList.item(1), pseudo);
                    this.setMargin(element, 2, valueList.item(2), pseudo);
                    this.setMargin(element, 3, valueList.item(3), pseudo);
                    break;
                }
                case 3: {
                    this.setMargin(element, 0, valueList.item(0), pseudo);
                    this.setMargin(element, 1, valueList.item(1), pseudo);
                    this.setMargin(element, 2, valueList.item(2), pseudo);
                    this.setMargin(element, 3, valueList.item(1), pseudo);
                }
                case 2: {
                    this.setMargin(element, 0, valueList.item(0), pseudo);
                    this.setMargin(element, 1, valueList.item(1), pseudo);
                    this.setMargin(element, 2, valueList.item(0), pseudo);
                    this.setMargin(element, 3, valueList.item(1), pseudo);
                }
            }
        }
    }

    private void applyCSSPropertyMarginTop(Composite element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 0, value, pseudo);
    }

    private void applyCSSPropertyMarginRight(Composite element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 1, value, pseudo);
    }

    private void applyCSSPropertyMarginBottom(Composite element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 2, value, pseudo);
    }

    private void applyCSSPropertyMarginLeft(Composite element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 3, value, pseudo);
    }

    private void setMargin(Composite composite, int side, CSSValue value, String pseudo) {
        if (value.getCssValueType() != 1) {
            return;
        }
        int pixelValue = (int)((CSSPrimitiveValue)value).getFloatValue((short)5);
        Layout layout = composite.getLayout();
        if (layout == null || !(layout instanceof TrimBarLayout)) {
            return;
        }
        TrimBarLayout trimBarLayout = (TrimBarLayout)layout;
        switch (side) {
            case 0: {
                trimBarLayout.marginTop = pixelValue;
                break;
            }
            case 1: {
                trimBarLayout.marginRight = pixelValue;
                break;
            }
            case 2: {
                trimBarLayout.marginBottom = pixelValue;
                break;
            }
            case 3: {
                trimBarLayout.marginLeft = pixelValue;
            }
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

