/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import org.xmind.core.IWorkbook;
import org.xmind.gef.command.SourceCommand;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.editor.IEditorLayout;
import org.xmind.ui.internal.editor.IEditorLayoutManager;
import org.xmind.ui.internal.presentation.slide.PresentationEditorLayout;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryManager;

public class AddStoryCommand
extends SourceCommand {
    private IWorkbook workbook;
    private PresentationStory story;
    private IGraphicalEditor editor;
    private PresentationStory oldStory;
    private IEditorLayoutManager layoutManager;

    public AddStoryCommand(IWorkbook workbook, PresentationStory story, IGraphicalEditor editor) {
        super((Object)story);
        this.workbook = workbook;
        this.story = story;
        this.editor = editor;
        this.layoutManager = (IEditorLayoutManager)editor.getAdapter(IEditorLayoutManager.class);
    }

    public void redo() {
        PresentationStoryManager.instance.addStory(this.workbook, this.story);
        IEditorLayout currentEditorLayout = this.layoutManager.getActiveLayout();
        if (currentEditorLayout instanceof PresentationEditorLayout) {
            PresentationEditorLayout layout = (PresentationEditorLayout)currentEditorLayout;
            this.oldStory = layout.getCurrentStory();
            layout.setCurrentStory(this.story);
        } else {
            this.layoutManager.restoreDefault();
            PresentationEditorLayout layout = new PresentationEditorLayout(this.layoutManager, this.story, this.editor);
            layout.setSelectionProvider(this.editor.getSite().getSelectionProvider());
            this.layoutManager.setActiveLayout((IEditorLayout)layout);
        }
        super.redo();
    }

    public void undo() {
        PresentationStoryManager.instance.deleteStory(this.workbook, this.story);
        if (this.oldStory == null) {
            this.layoutManager.restoreDefault();
        } else {
            IEditorLayout currentEditorLayout = this.layoutManager.getActiveLayout();
            if (currentEditorLayout instanceof PresentationEditorLayout) {
                PresentationEditorLayout layout = (PresentationEditorLayout)currentEditorLayout;
                layout.setCurrentStory(this.oldStory);
            } else {
                this.layoutManager.restoreDefault();
            }
        }
        super.undo();
    }
}

