/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.index;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.index.Messages;
import org.xmind.ui.internal.index.resource.IAZResource;
import org.xmind.ui.internal.index.resource.IAssigneeResource;
import org.xmind.ui.internal.index.resource.IIndexResource;
import org.xmind.ui.internal.index.resource.ILabelResource;
import org.xmind.ui.internal.index.resource.IMarkerResource;
import org.xmind.ui.internal.index.resource.ITaskDateResource;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;

public class IndexViewer
extends TreeViewer {
    public static final String VIEWERTYPE_SINGLECOLUMN = "singleColumn";
    public static final String VIEWERTYPE_MULITCOLUMN = "multiColumn";
    private String viewerType;
    private LocalResourceManager localResourceManager;

    public IndexViewer(Composite parent, String viewerType) {
        super(parent, 66306);
        this.viewerType = viewerType;
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.initViewer(viewerType);
    }

    private void initViewer(String viewerType) {
        this.setContentProvider((IContentProvider)new IndexContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new IndexLabelProvider());
        this.setSorter(new IndexViewerSorter());
        if (VIEWERTYPE_MULITCOLUMN.equals(viewerType)) {
            this.getTree().setHeaderVisible(true);
            TreeViewerColumn dateColumn = new TreeViewerColumn((TreeViewer)this, 16384);
            dateColumn.getColumn().setWidth(200);
            dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Object input = IndexViewer.this.getInput();
                    if (input instanceof ITaskDateResource && element instanceof ITopic) {
                        return ((ITaskDateResource)input).getTaskDate((ITopic)element);
                    }
                    return null;
                }
            });
            TreeViewerColumn taskColumn = new TreeViewerColumn((TreeViewer)this, 16384);
            taskColumn.getColumn().setText(Messages.IndexViewer_TaskDateType_TaskColumn_text);
            taskColumn.getColumn().setWidth(300);
            taskColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Object input = IndexViewer.this.getInput();
                    if (input instanceof ITaskDateResource && element instanceof ITopic) {
                        return ((ITopic)element).getTitleText();
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    if (element instanceof ITopic) {
                        return IndexViewer.this.localResourceManager.createImage(MindMapUI.getImages().getTopicIcon((ITopic)element, true));
                    }
                    return super.getImage(element);
                }
            });
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    public String getViewerType() {
        return this.viewerType;
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    private class IndexContentProvider
    implements ITreeContentProvider {
        private IndexContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof ITaskDateResource) {
                TreeColumn column;
                int taskDateType = ((ITaskDateResource)newInput).getTaskDateResourceType();
                Tree tree = IndexViewer.this.getTree();
                if (tree != null && !tree.isDisposed() && (column = tree.getColumn(0)) != null && !column.isDisposed()) {
                    if (taskDateType == 4) {
                        column.setText(Messages.IndexViewer_TaskDateType_StartDateColumn_text);
                    } else if (taskDateType == 8) {
                        column.setText(Messages.IndexViewer_TaskDateType_EndDateColumn_text);
                    }
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITaskDateResource) {
                return ((ITaskDateResource)inputElement).getAllTopicsForTaskDate().toArray();
            }
            if (inputElement instanceof IIndexResource) {
                IIndexResource input = (IIndexResource)inputElement;
                return new Object[]{input.getSource()};
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            Object input = IndexViewer.this.getInput();
            if (input instanceof IMarkerResource) {
                IMarkerResource resource = (IMarkerResource)input;
                return this.getChildrenForMarkerResource(resource, parentElement);
            }
            if (input instanceof ILabelResource) {
                ILabelResource resource = (ILabelResource)input;
                return this.getChildrenForLabelResource(resource, parentElement);
            }
            if (input instanceof IAssigneeResource) {
                return this.getChildrenForAssigneeResource((IAssigneeResource)input, parentElement);
            }
            if (input instanceof ITaskDateResource) {
                return null;
            }
            if (input instanceof IAZResource && (parentElement instanceof IWorkbook || parentElement instanceof ISheet)) {
                return ((IAZResource)input).getTopics().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            Object input = IndexViewer.this.getInput();
            if (input instanceof IMarkerResource) {
                IMarkerResource resource = (IMarkerResource)input;
                return this.getParentForMarkerResource(resource, element);
            }
            if (input instanceof ILabelResource) {
                ILabelResource resource = (ILabelResource)input;
                return this.getParentForLabelResource(resource, element);
            }
            if (input instanceof IAssigneeResource) {
                return this.getParentForAssigneeResource((IAssigneeResource)input, element);
            }
            if (input instanceof ITaskDateResource) {
                return null;
            }
            if (input instanceof IAZResource && element instanceof ITopic) {
                return ((IAZResource)input).getSource();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object input = IndexViewer.this.getInput();
            if (input instanceof IMarkerResource) {
                return element instanceof IWorkbook || element instanceof ISheet || element instanceof IMarkerGroup || element instanceof IMarker;
            }
            if (input instanceof ILabelResource) {
                return element instanceof IWorkbook || element instanceof ISheet || element instanceof String;
            }
            if (input instanceof IAssigneeResource) {
                return element instanceof IWorkbook || element instanceof ISheet || element instanceof String;
            }
            if (input instanceof IAZResource) {
                return element instanceof IWorkbook || element instanceof ISheet;
            }
            return false;
        }

        private Object[] getChildrenForMarkerResource(IMarkerResource resource, Object parentElement) {
            Set<String> ids = resource.getMarkerIds();
            if (parentElement instanceof IMarkerGroup) {
                HashSet<IMarker> childrenIds = new HashSet<IMarker>();
                for (String id : ids) {
                    IMarker marker = resource.getMarker(id);
                    if (marker.getParent() != parentElement) continue;
                    childrenIds.add(marker);
                }
                return childrenIds.toArray();
            }
            if (parentElement instanceof IMarker) {
                return resource.getTopics(((IMarker)parentElement).getId()).toArray();
            }
            if (parentElement instanceof IWorkbook || parentElement instanceof ISheet) {
                HashSet<IMarkerGroup> group = new HashSet<IMarkerGroup>();
                for (String markerId : ids) {
                    IMarker marker = resource.getMarker(markerId);
                    group.add(marker.getParent());
                }
                return group.toArray();
            }
            return null;
        }

        private Object[] getChildrenForLabelResource(ILabelResource resource, Object parentElement) {
            if (parentElement instanceof IWorkbook || parentElement instanceof ISheet) {
                return resource.getLabels().toArray();
            }
            if (parentElement instanceof String) {
                return resource.getTopics((String)parentElement).toArray();
            }
            return null;
        }

        private Object[] getChildrenForAssigneeResource(IAssigneeResource resource, Object parentElement) {
            if (parentElement instanceof IWorkbook || parentElement instanceof ISheet) {
                return resource.getAssignees().toArray();
            }
            if (parentElement instanceof String) {
                return resource.getTopics((String)parentElement).toArray();
            }
            return null;
        }

        private Object getParentForMarkerResource(IMarkerResource resource, Object element) {
            if (element instanceof IMarkerGroup) {
                return resource.getSource();
            }
            if (element instanceof IMarker) {
                return ((IMarker)element).getParent();
            }
            if (element instanceof ITopic) {
                Set<String> ids = resource.getMarkerIds();
                for (String markerId : ids) {
                    if (!resource.getTopics(markerId).contains(element)) continue;
                    IMarker marker = resource.getMarker(markerId);
                    return marker;
                }
            }
            return null;
        }

        private Object getParentForLabelResource(ILabelResource resource, Object element) {
            if (element instanceof String) {
                return resource.getSource();
            }
            if (element instanceof ITopic) {
                Set<String> labels = resource.getLabels();
                for (String lab : labels) {
                    if (!resource.getTopics(lab).contains(element)) continue;
                    return lab;
                }
            }
            return null;
        }

        private Object getParentForAssigneeResource(IAssigneeResource resource, Object element) {
            if (element instanceof String) {
                return resource.getSource();
            }
            if (element instanceof ITopic) {
                Set<String> assignees = resource.getAssignees();
                for (String assignee : assignees) {
                    if (!resource.getTopics(assignee).contains(element)) continue;
                    return assignee;
                }
            }
            return null;
        }
    }

    private class IndexLabelProvider
    extends LabelProvider {
        private IndexLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IWorkbook) {
                String name = this.getNameForWorkbook((IWorkbook)element);
                if (name == null) {
                    name = Messages.IndexViewer_ForWorkbook_Root_text;
                }
                return name;
            }
            if (element instanceof ISheet) {
                return ((ISheet)element).getTitleText();
            }
            if (element instanceof IMarkerGroup) {
                return ((IMarkerGroup)element).getName();
            }
            if (element instanceof IMarker) {
                return ((IMarker)element).getName();
            }
            if (element instanceof ITopic) {
                return ((ITopic)element).getTitleText();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return super.getText(element);
        }

        private String getNameForWorkbook(IWorkbook workbook) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IEditorReference[] editorReferences = window.getActivePage().getEditorReferences();
            IEditorInput editorInput = MME.getEditorInputWithWorkbookAndEditors((IWorkbook)workbook, (IEditorReference[])editorReferences);
            return editorInput.getName();
        }

        public Image getImage(Object element) {
            if (element instanceof IWorkbook) {
                ImageDescriptor imageDescriptor = MindMapUI.getImages().get("workbook.png", true);
                return IndexViewer.this.localResourceManager.createImage(imageDescriptor);
            }
            if (element instanceof ISheet) {
                return IndexViewer.this.localResourceManager.createImage(MindMapUI.getImages().get("sheet.png", true));
            }
            if (element instanceof ITopic) {
                return IndexViewer.this.localResourceManager.createImage(MindMapUI.getImages().getTopicIcon((ITopic)element, true));
            }
            if (element instanceof IMarker) {
                ImageDescriptor imageDescriptor = MarkerImageDescriptor.createFromMarker((IMarker)((IMarker)element));
                return IndexViewer.this.localResourceManager.createImage(imageDescriptor);
            }
            Object input = IndexViewer.this.getInput();
            if (input instanceof ILabelResource) {
                if (element instanceof String) {
                    return IndexViewer.this.localResourceManager.createImage(MindMapUI.getImages().get("label.png", true));
                }
            } else if (input instanceof IAssigneeResource && element instanceof String) {
                URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.ui.index"), (IPath)new Path("$nl$/icons/assignee.gif"), null);
                return IndexViewer.this.localResourceManager.createImage(ImageDescriptor.createFromURL((URL)url));
            }
            return super.getImage(element);
        }
    }

    private class IndexViewerSorter
    extends ViewerSorter {
        private IndexViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof IWorkbook || element instanceof ISheet) {
                return 1;
            }
            if (element instanceof IMarkerGroup) {
                return 2;
            }
            if (element instanceof IMarker) {
                return 4;
            }
            if (element instanceof String) {
                return 8;
            }
            if (element instanceof ITopic) {
                return 16;
            }
            return super.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IMarkerGroup qMarkerGroup;
            IMarkerGroup pMarkerGroup;
            Object input = IndexViewer.this.getInput();
            if (input instanceof ITaskDateResource) {
                ITaskDateResource resource = (ITaskDateResource)input;
                if (e1 instanceof ITopic && e2 instanceof ITopic) {
                    String qTaskDate;
                    String pTaskDate = resource.getTaskDate((ITopic)e1);
                    int compareDate = super.compare(viewer, (Object)pTaskDate, (Object)(qTaskDate = resource.getTaskDate((ITopic)e2)));
                    return compareDate == 0 ? super.compare(viewer, e1, e2) : compareDate;
                }
            }
            if (input instanceof IAZResource && e1 instanceof ITopic && e2 instanceof ITopic) {
                if (((IAZResource)input).isPositiveSequence()) {
                    return super.compare(viewer, e1, e2);
                }
                return super.compare(viewer, e2, e1);
            }
            if (e1 instanceof IMarkerGroup && e2 instanceof IMarkerGroup) {
                IMarkerSheet qSheet;
                IMarkerSheet pSheet = ((IMarkerGroup)e1).getOwnedSheet();
                if (pSheet == (qSheet = ((IMarkerGroup)e2).getOwnedSheet())) {
                    List markerGroups = pSheet.getMarkerGroups();
                    return markerGroups.indexOf(e1) - markerGroups.indexOf(e2);
                }
                if (MindMapUI.getResourceManager().getSystemMarkerSheet() == pSheet) {
                    return -10000;
                }
                return 10000;
            }
            if (e1 instanceof IMarker && e2 instanceof IMarker && (pMarkerGroup = ((IMarker)e1).getParent()) == (qMarkerGroup = ((IMarker)e2).getParent()) && pMarkerGroup != null) {
                List markers = pMarkerGroup.getMarkers();
                return markers.indexOf(e1) - markers.indexOf(e2);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

