/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.Calendar;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.ITopic;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.gefext.AbstractDragTracker;
import org.xmind.ui.gantt2.gefext.AbstractFeedback;
import org.xmind.ui.gantt2.gefext.ITracker;
import org.xmind.ui.gantt2.viewer.IHasOffset;
import org.xmind.ui.gantt2.viewer.IHostFigureProvider;
import org.xmind.ui.gantt2.viewer.TaskBar;
import org.xmind.ui.gantt2.viewer.TaskBarFigure;
import org.xmind.ui.gantt2.viewer.TaskBarPart;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class TaskBarCreateFeedback
extends AbstractFeedback {
    private static final String LOCATION = "location";
    private static final String OFFSET = "offset";
    private static final String LENGTH = "length";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private ITracker createTracker;

    public TaskBarPart getHost() {
        return (TaskBarPart)super.getHost();
    }

    protected IFigure getMainFigure() {
        return this.getHost().getBarFigure();
    }

    public ITracker findTracker(Point point) {
        if (this.shouldActivateTracker(point)) {
            if (this.createTracker == null) {
                this.createTracker = new TaskBarCreateTracker();
            }
            return this.createTracker;
        }
        return super.findTracker(point);
    }

    public Cursor findCursor(Point point) {
        if (this.shouldActivateTracker(point)) {
            return Cursors.CROSS;
        }
        return super.findCursor(point);
    }

    private boolean shouldActivateTracker(Point point) {
        if (this.isHostFigureVisible()) {
            return this.isTrackerLocation(point) && this.isTaskBarUncreated();
        }
        return false;
    }

    private boolean isTrackerLocation(Point point) {
        IFigure figure = this.getMainFigure();
        Rectangle r = figure.getBounds();
        return point.y >= r.y - 2 && point.y < r.y + r.height + 2;
    }

    private boolean isTaskBarUncreated() {
        IFigure figure = this.getMainFigure();
        return figure instanceof IHasOffset && !((IHasOffset)figure).hasOffset();
    }

    private boolean isHostFigureVisible() {
        if (this.getHost() instanceof IHostFigureProvider) {
            return this.getHost().isHostFigureVisible();
        }
        return true;
    }

    private class TaskBarCreateTracker
    extends AbstractDragTracker {
        private TaskBarCreateTracker() {
        }

        public Cursor getCurrentCursor(Point pos, IPart host) {
            return Cursors.SIZEWE;
        }

        private TaskBarFigure getBarFigure() {
            return (TaskBarFigure)TaskBarCreateFeedback.this.getHost().getBarFigure();
        }

        protected void applyStatus(AbstractDragTracker.Status status) {
            TaskBar bar = TaskBarCreateFeedback.this.getHost().getTaskBar();
            bar.setStartDate((DateInfo)status.get(TaskBarCreateFeedback.START_DATE));
            bar.setEndDate((DateInfo)status.get(TaskBarCreateFeedback.END_DATE));
            TaskBarFigure figure = this.getBarFigure();
            figure.setOffset((Integer)status.get(TaskBarCreateFeedback.OFFSET));
            figure.setLength(status.getInteger(TaskBarCreateFeedback.LENGTH, 1));
            figure.setVisible(figure.hasOffset());
            if (figure.isVisible()) {
                TaskBarCreateFeedback.this.getHost().addTooltipRequester(this);
            } else {
                TaskBarCreateFeedback.this.getHost().removeTooltipRequester(this);
            }
        }

        protected boolean captureInitialStatus(MouseEvent me, AbstractDragTracker.Status status) {
            status.set((Object)TaskBarCreateFeedback.LOCATION, me.cursorLocation.x);
            TaskBarFigure figure = this.getBarFigure();
            status.set((Object)TaskBarCreateFeedback.OFFSET, figure.hasOffset() ? Integer.valueOf(figure.getOffset()) : null);
            status.set((Object)TaskBarCreateFeedback.LENGTH, figure.getLength());
            TaskBar bar = TaskBarCreateFeedback.this.getHost().getTaskBar();
            status.set((Object)TaskBarCreateFeedback.START_DATE, bar.getStartDate());
            status.set((Object)TaskBarCreateFeedback.END_DATE, bar.getEndDate());
            return true;
        }

        protected Command getCommand(AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            DateInfo startDate = (DateInfo)status.get(TaskBarCreateFeedback.START_DATE);
            DateInfo endDate = (DateInfo)status.get(TaskBarCreateFeedback.END_DATE);
            if (startDate == null && endDate == null) {
                return null;
            }
            ITopic task = TaskBarCreateFeedback.this.getHost().getTask();
            Command c1 = TaskInfoUtils.createChangeStartDateCommand((ITopic)task, (DateInfo)startDate);
            DurationInfo duration = DurationInfo.calcDuration((DateInfo)startDate, (DateInfo)endDate);
            Command c2 = TaskInfoUtils.createChangeDurationCommand((ITopic)task, (DurationInfo)duration);
            return new CompoundCommand(GanttMessages.Command_ChangeDates, new Command[]{c1, c2});
        }

        protected boolean updateStatus(MouseEvent me, AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            int currentLocation = me.cursorLocation.x;
            int initLocation = initStatus.getInteger(TaskBarCreateFeedback.LOCATION, currentLocation);
            if (currentLocation == initLocation) {
                status.putAll(initStatus);
            } else {
                int start = Math.min(currentLocation, initLocation);
                int end = Math.max(currentLocation, initLocation);
                TimelineModel timeline = TaskBarCreateFeedback.this.getHost().getTimelineModel();
                Calendar originDate = timeline.getOriginDate();
                long startOffsetMillis = timeline.getMillisFromPixels(start);
                long endOffsetMillis = timeline.getMillisFromPixels(end);
                boolean allDay = timeline.getPrecision() >= 3456.0;
                DateInfo startDate = this.getAdded(originDate, startOffsetMillis, allDay);
                DateInfo endDate = this.getAdded(originDate, endOffsetMillis, allDay);
                status.set((Object)TaskBarCreateFeedback.START_DATE, startDate);
                status.set((Object)TaskBarCreateFeedback.END_DATE, endDate);
                status.set((Object)TaskBarCreateFeedback.OFFSET, timeline.getPixelsFromMillis(startDate.date.getTimeInMillis() - originDate.getTimeInMillis()));
                status.set((Object)TaskBarCreateFeedback.LENGTH, timeline.getPixelsFromMillis(endDate.date.getTimeInMillis() - startDate.date.getTimeInMillis()));
            }
            return true;
        }

        private DateInfo getAdded(Calendar origin, long delta, boolean allDay) {
            DateInfo date = new DateInfo();
            date.date.setTimeInMillis(origin.getTimeInMillis() + delta);
            date.allDay = allDay;
            if (allDay) {
                date.setTime(0, 0, 0);
            }
            return date;
        }
    }
}

