/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.samples.svg.SVGView;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class ViewSourceAction
extends AbstractViewAction {
    public static final String ID = "view.viewSource";
    private static final String DIALOG_CLIENT_PROPERTY = "view.viewSource.dialog";

    public ViewSourceAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final SVGView p = (SVGView)this.getActiveView();
        SVGOutputFormat format = new SVGOutputFormat();
        format.setPrettyPrint(true);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            JTextArea ta;
            JDialog dialog;
            format.write(buf, p.getDrawing());
            String source = buf.toString("UTF-8");
            if (p.getClientProperty(DIALOG_CLIENT_PROPERTY) == null) {
                dialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(p.getComponent()));
                p.putClientProperty(DIALOG_CLIENT_PROPERTY, dialog);
                dialog.setTitle(p.getTitle());
                dialog.setResizable(true);
                dialog.setDefaultCloseOperation(2);
                ta = new JTextArea(source);
                ta.setWrapStyleWord(true);
                ta.setLineWrap(true);
                JScrollPane sp = new JScrollPane(ta);
                dialog.getContentPane().add(sp);
                dialog.setSize(400, 400);
                dialog.setLocationByPlatform(true);
            } else {
                dialog = (JDialog)p.getClientProperty(DIALOG_CLIENT_PROPERTY);
                ta = (JTextArea)((JScrollPane)dialog.getContentPane().getComponent(0)).getViewport().getView();
                ta.setText(source);
            }
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            PreferencesUtil.installFramePrefsHandler(prefs, "viewSource", dialog);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent evt) {
                    ViewSourceAction.this.getApplication().removeWindow(dialog);
                    p.putClientProperty(ViewSourceAction.DIALOG_CLIENT_PROPERTY, null);
                }
            });
            this.getApplication().addWindow(dialog, this.getActiveView());
            dialog.setVisible(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

