/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierTool;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;

public class PathTool
extends BezierTool {
    private static final boolean DEBUG = false;
    private SVGPathFigure pathPrototype;

    public PathTool(SVGPathFigure pathPrototype, SVGBezierFigure bezierPrototype) {
        this(pathPrototype, bezierPrototype, null);
    }

    public PathTool(SVGPathFigure pathPrototype, SVGBezierFigure bezierPrototype, Map<AttributeKey, Object> attributes) {
        super(bezierPrototype, attributes);
        this.pathPrototype = pathPrototype;
    }

    protected SVGPathFigure createPath() {
        SVGPathFigure f = this.pathPrototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                ((AttributeKey)entry.getKey()).basicSet(f, entry.getValue());
            }
        }
        return f;
    }

    @Override
    protected void finishCreation(BezierFigure createdFigure, DrawingView creationView) {
        creationView.getDrawing().remove(createdFigure);
        SVGPathFigure createdPath = this.createPath();
        createdPath.removeAllChildren();
        createdPath.add(createdFigure);
        creationView.getDrawing().add(createdPath);
        creationView.addToSelection(createdPath);
        this.fireUndoEvent(createdPath, creationView);
    }
}

