/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleUnauthorizedException;
import org.apache.guacamole.rest.APIError;
import org.apache.guacamole.rest.auth.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class RESTExceptionMapper
implements ExceptionMapper<Throwable> {
    private final Logger logger = LoggerFactory.getLogger(RESTExceptionMapper.class);
    @Context
    private HttpServletRequest request;
    @Inject
    private AuthenticationService authenticationService;

    private String getAuthenticationToken() {
        String token = this.request.getParameter("token");
        if (token != null && !token.isEmpty()) {
            return token;
        }
        return null;
    }

    public Response toResponse(Throwable t) {
        String token;
        if (t instanceof GuacamoleUnauthorizedException && this.authenticationService.destroyGuacamoleSession(token = this.getAuthenticationToken())) {
            this.logger.debug("Implicitly invalidated session for token \"{}\"", (Object)token);
        }
        if (t instanceof GuacamoleException) {
            return Response.status((int)((GuacamoleException)t).getHttpStatusCode()).entity((Object)new APIError((GuacamoleException)t)).type("application/json").build();
        }
        String message = t.getMessage();
        if (message != null) {
            this.logger.error("Unexpected internal error: {}", (Object)message);
        } else {
            this.logger.error("An internal error occurred, but did not contain an error message. Enable debug-level logging for details.");
        }
        this.logger.debug("Unexpected error in REST endpoint.", t);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new APIError(new GuacamoleException("Unexpected internal error", t))).type("application/json").build();
    }
}

