/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.filechooser.FileSystemView;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());
    public static final String BACKUP_EXTENSION = ".backup";

    private FileUtils() {
    }

    public static OutputStream createEmptyFile(File f, long size, long startPosition, DownloadTask task) throws IOException {
        int megabyte = 0x100000;
        byte[] bytes = new byte[0x100000];
        RandomAccessFile fos = null;
        long startSeek = f.exists() ? f.length() : 0L;
        try {
            fos = new RandomAccessFile(f, "rw");
            fos.setLength(size);
            fos.seek(startSeek);
            int toWrite = 0x100000;
            for (long written = startSeek; written != size; written += (long)toWrite) {
                if (task.isTerminated()) {
                    return null;
                }
                if (size - written < 0x100000L) {
                    toWrite = (int)(size - written);
                }
                fos.write(bytes, 0, toWrite);
            }
        }
        catch (IOException e) {
            if (fos != null) {
                fos.close();
            }
            throw e;
        }
        fos.seek(startPosition);
        return new FileOutputStream(fos.getFD());
    }

    public static void makeBackup(File srcFile) throws IOException {
        boolean result;
        if (!srcFile.exists() || srcFile.length() <= 0L) {
            return;
        }
        File backupFile = FileUtils.getBackupFile(srcFile);
        File tmp = new File(srcFile.getParentFile(), "FRD" + (int)(Math.random() * 1000000.0) + "templist.txt");
        boolean b = srcFile.renameTo(tmp);
        if (!b) {
            logger.warning("Failed to rename oldSrc file to " + tmp);
        }
        if (backupFile.exists() && !(result = backupFile.delete())) {
            logger.warning("Deleting old backup file " + backupFile + " failed.");
        }
        if (!(result = tmp.renameTo(backupFile))) {
            logger.warning("Making backup of file " + srcFile + " to backup file " + backupFile + " failed.");
        }
    }

    public static void renewBackup(File srcFile) throws IOException {
        File backupFile = FileUtils.getBackupFile(srcFile);
        try {
            if (!backupFile.exists()) {
                throw new FileNotFoundException("Backup file does not exists");
            }
            FileUtils.copyfile(backupFile, srcFile);
        }
        catch (IOException e) {
            logger.warning("Renewing file " + srcFile + " from backup file " + backupFile + " failed.");
            throw e;
        }
    }

    public static File getBackupFile(File srcFile) {
        return new File(srcFile.getParentFile(), srcFile.getName() + BACKUP_EXTENSION);
    }

    public static File getRelativeDirectory(File base, File file) {
        String relativeFile;
        try {
            relativeFile = FileUtils.getRelativePath(base, file);
            logger.info("Relative path of '" + file + "' to " + base + " is " + relativeFile);
        }
        catch (IOException e) {
            return file;
        }
        if (relativeFile == null) {
            return file;
        }
        return new File(relativeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZipFileInto(File zipFile, File targetDirectory) {
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
            byte[] buffer = new byte[8192];
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File outputFile = new File(targetDirectory, entry.getName());
                OutputStream os = null;
                try {
                    int len;
                    os = new BufferedOutputStream(new FileOutputStream(outputFile));
                    while ((len = zis.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                }
                finally {
                    if (os == null) continue;
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        LogUtils.processException(logger, e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to extract archive", e);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception e) {
                    LogUtils.processException(logger, e);
                }
            }
        }
    }

    private static String getRelativePath(File base, File file) throws IOException {
        String newPrefix;
        String basePath;
        String filePath = file.getCanonicalPath();
        if (base.isFile()) {
            File baseParent = base.getParentFile();
            if (baseParent == null) {
                return null;
            }
            basePath = baseParent.getCanonicalPath();
        } else {
            basePath = base.getCanonicalPath();
        }
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        int p = basePath.indexOf(File.separatorChar);
        String prefix = null;
        while (p != -1 && filePath.startsWith(newPrefix = basePath.substring(0, p + 1))) {
            prefix = newPrefix;
            p = basePath.indexOf(File.separatorChar, p + 1);
        }
        if (prefix == null) {
            return null;
        }
        filePath = filePath.substring(prefix.length());
        if (prefix.length() == basePath.length()) {
            return filePath;
        }
        int c = 0;
        p = basePath.indexOf(File.separatorChar, prefix.length());
        while (p != -1) {
            ++c;
            p = basePath.indexOf(File.separatorChar, p + 1);
        }
        for (int i = 0; i < c; ++i) {
            filePath = ".." + File.separator + filePath;
        }
        return filePath;
    }

    public static void copyfile(File srcFile, File dstFile) throws IOException {
        if (!srcFile.exists() || !srcFile.isFile()) {
            return;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            boolean result;
            File parentFile = dstFile.getParentFile();
            if (!parentFile.exists() && !(result = parentFile.mkdirs())) {
                logger.warning("Creating path " + parentFile + " failed");
            }
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(dstFile);
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            LogUtils.processException(logger, e);
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    LogUtils.processException(logger, e1);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e1) {
                    LogUtils.processException(logger, e1);
                }
            }
        }
    }

    public static String getAbsolutPath(String path) {
        return FileUtils.getAbsolutPath(new File(path));
    }

    public static String getAbsolutPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static File getAbsolutFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static File getFileDrive(File file) {
        FileSystemView fsView = FileSystemView.getFileSystemView();
        while (!fsView.isDrive(file)) {
            file = file.getParentFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = null;
        try {
            int offset;
            int numRead;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static boolean supportsRecycleBin() {
        return com.sun.jna.platform.FileUtils.getInstance().hasTrash();
    }

    public static boolean deleteFileWithRecycleBin(File ... filesToDelete) {
        if (AppPrefs.getProperty("useRecycleBin", false) && FileUtils.supportsRecycleBin()) {
            com.sun.jna.platform.FileUtils fileUtils = com.sun.jna.platform.FileUtils.getInstance();
            boolean failed = false;
            for (File file : filesToDelete) {
                if (!file.exists()) continue;
                try {
                    fileUtils.moveToTrash(new File[]{file});
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to delete file via recycle bin: " + file, e);
                    failed = true;
                }
            }
            return !failed;
        }
        return FileUtils.deleteFile(filesToDelete);
    }

    public static boolean deleteFile(File ... filesToDelete) {
        boolean failed = false;
        for (File file : filesToDelete) {
            boolean delete;
            if (!file.exists() || (delete = file.delete())) continue;
            failed = true;
            logger.warning("Failed to delete file " + file);
        }
        return !failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileWithValue(File file, String stringValue) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(stringValue.getBytes("UTF-8"));
        }
        catch (Exception e) {
            logger.warning("Failed to write plugin version file: " + e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    LogUtils.processException(logger, e);
                }
            }
        }
    }
}

