/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.Proxy;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jdesktop.application.Application;

public class ConnectionSettings {
    private String userName;
    private String password;
    private String proxyURL;
    private int proxyPort;
    private boolean proxySet;
    private boolean enabled = true;
    private String defaultConnectionLabel;
    private final PropertyChangeSupport pcs;
    private boolean isDefault = false;
    private Proxy.Type proxyType = Proxy.Type.DIRECT;

    public ConnectionSettings() {
        this.defaultConnectionLabel = Application.getInstance().getContext().getResourceMap().getString("defaultConnection", new Object[0]);
        this.pcs = new SwingPropertyChangeSupport(this);
        this.proxyType = Proxy.Type.DIRECT;
    }

    public void setProxy(String proxyURL, int proxyPort, Proxy.Type proxyType, String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.setProxy(proxyURL, proxyPort, proxyType);
    }

    public void setProxy(String proxyURL, int proxyPort) {
        this.setProxy(proxyURL, proxyPort, Proxy.Type.HTTP);
    }

    public void setProxy(String proxyURL, int proxyPort, Proxy.Type proxyType) {
        this.proxyURL = proxyURL;
        this.proxyPort = proxyPort;
        this.proxyType = proxyType;
        this.proxySet = true;
    }

    public boolean isProxySet() {
        return this.proxySet;
    }

    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean hasUserName() {
        return this.userName != null;
    }

    public String toString() {
        if (this.isProxySet()) {
            StringBuilder builder = new StringBuilder();
            if (this.hasUserName()) {
                builder.append(this.getUserName()).append('@');
            }
            builder.append(this.getProxyURL()).append(':').append(this.getProxyPort()).append(' ').append('(').append((Object)this.getProxyType()).append(')');
            return builder.toString();
        }
        return this.defaultConnectionLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionSettings that = (ConnectionSettings)o;
        if (this.proxyPort != that.proxyPort) {
            return false;
        }
        if (this.proxySet != that.proxySet) {
            return false;
        }
        if (this.proxyType != that.proxyType) {
            return false;
        }
        if (this.proxyURL != null ? !this.proxyURL.equalsIgnoreCase(that.proxyURL) : that.proxyURL != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    public void setProxyType(Proxy.Type proxyType) {
        this.proxyType = proxyType;
    }

    public int hashCode() {
        int result = this.userName != null ? this.userName.hashCode() : 0;
        result = 31 * result + (this.proxyURL != null ? this.proxyURL.toLowerCase().hashCode() : 0);
        result = 31 * result + this.proxyPort;
        result = 31 * result + (this.proxySet ? 1 : 0);
        result = 31 * result + (this.proxyType != null ? this.proxyType.hashCode() : 0);
        return result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.enabled = enabled;
        this.pcs.firePropertyChange("enabled", oldValue, enabled);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }
}

