/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonListener;

public class RolloverButtonListener
extends BasicButtonListener {
    public RolloverButtonListener(AbstractButton b) {
        super(b);
        b.setRolloverEnabled(true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(e)) {
            model.setRollover(true);
        }
        if (model.isPressed()) {
            model.setArmed(true);
        }
        b.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled()) {
            model.setRollover(false);
        }
        if (model.isPressed()) {
            model.setArmed(false);
        }
        b.repaint();
    }
}

