/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.proxy.AbstractProxyLogicHandler;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpProxyResponse;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.IoBufferDecoder;
import org.apache.mina.proxy.utils.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpLogicHandler
extends AbstractProxyLogicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpLogicHandler.class);
    private static final String DECODER = AbstractHttpLogicHandler.class.getName() + ".Decoder";
    private static final byte[] HTTP_DELIMITER = new byte[]{13, 10, 13, 10};
    private static final byte[] CRLF_DELIMITER = new byte[]{13, 10};
    private IoBuffer responseData = null;
    private HttpProxyResponse parsedResponse = null;
    private int contentLength = -1;
    private boolean hasChunkedData;
    private boolean waitingChunkedData;
    private boolean waitingFooters;
    private int entityBodyStartPosition;
    private int entityBodyLimitPosition;

    public AbstractHttpLogicHandler(ProxyIoSession proxyIoSession) {
        super(proxyIoSession);
    }

    public synchronized void messageReceived(IoFilter.NextFilter nextFilter, IoBuffer ioBuffer) throws ProxyAuthException {
        LOGGER.debug(" messageReceived()");
        IoBufferDecoder ioBufferDecoder = (IoBufferDecoder)this.getSession().getAttribute(DECODER);
        if (ioBufferDecoder == null) {
            ioBufferDecoder = new IoBufferDecoder(HTTP_DELIMITER);
            this.getSession().setAttribute(DECODER, ioBufferDecoder);
        }
        try {
            String string;
            Object object;
            if (this.parsedResponse == null) {
                this.responseData = ioBufferDecoder.decodeFully(ioBuffer);
                if (this.responseData == null) {
                    return;
                }
                object = this.responseData.getString(this.getProxyIoSession().getCharset().newDecoder());
                this.entityBodyStartPosition = this.responseData.position();
                LOGGER.debug("  response header received:\n{}", (Object)((String)object).replace("\r", "\\r").replace("\n", "\\n\n"));
                this.parsedResponse = this.decodeResponse((String)object);
                if (this.parsedResponse.getStatusCode() == 200 || this.parsedResponse.getStatusCode() >= 300 && this.parsedResponse.getStatusCode() <= 307) {
                    ioBuffer.position(0);
                    this.setHandshakeComplete();
                    return;
                }
                string = StringUtilities.getSingleValuedHeader(this.parsedResponse.getHeaders(), "Content-Length");
                if (string == null) {
                    this.contentLength = 0;
                } else {
                    this.contentLength = Integer.parseInt(string.trim());
                    ioBufferDecoder.setContentLength(this.contentLength, true);
                }
            }
            if (!this.hasChunkedData) {
                if (this.contentLength > 0) {
                    object = ioBufferDecoder.decodeFully(ioBuffer);
                    if (object == null) {
                        return;
                    }
                    this.responseData.setAutoExpand(true);
                    this.responseData.put((IoBuffer)object);
                    this.contentLength = 0;
                }
                if ("chunked".equalsIgnoreCase(StringUtilities.getSingleValuedHeader(this.parsedResponse.getHeaders(), "Transfer-Encoding"))) {
                    LOGGER.debug("Retrieving additional http response chunks");
                    this.hasChunkedData = true;
                    this.waitingChunkedData = true;
                }
            }
            if (this.hasChunkedData) {
                while (this.waitingChunkedData) {
                    if (this.contentLength == 0) {
                        ioBufferDecoder.setDelimiter(CRLF_DELIMITER, false);
                        object = ioBufferDecoder.decodeFully(ioBuffer);
                        if (object == null) {
                            return;
                        }
                        string = ((IoBuffer)object).getString(this.getProxyIoSession().getCharset().newDecoder());
                        int n = string.indexOf(59);
                        string = n >= 0 ? string.substring(0, n) : string.substring(0, string.length() - 2);
                        this.contentLength = Integer.decode("0x" + string);
                        if (this.contentLength > 0) {
                            this.contentLength += 2;
                            ioBufferDecoder.setContentLength(this.contentLength, true);
                        }
                    }
                    if (this.contentLength == 0) {
                        this.waitingChunkedData = false;
                        this.waitingFooters = true;
                        this.entityBodyLimitPosition = this.responseData.position();
                        break;
                    }
                    object = ioBufferDecoder.decodeFully(ioBuffer);
                    if (object == null) {
                        return;
                    }
                    this.contentLength = 0;
                    this.responseData.put((IoBuffer)object);
                    ioBuffer.position(ioBuffer.position());
                }
                while (this.waitingFooters) {
                    ioBufferDecoder.setDelimiter(CRLF_DELIMITER, false);
                    object = ioBufferDecoder.decodeFully(ioBuffer);
                    if (object == null) {
                        return;
                    }
                    if (((IoBuffer)object).remaining() == 2) {
                        this.waitingFooters = false;
                        break;
                    }
                    string = ((IoBuffer)object).getString(this.getProxyIoSession().getCharset().newDecoder());
                    String[] stringArray = string.split(":\\s?", 2);
                    StringUtilities.addValueToHeader(this.parsedResponse.getHeaders(), stringArray[0], stringArray[1], false);
                    this.responseData.put((IoBuffer)object);
                    this.responseData.put(CRLF_DELIMITER);
                }
            }
            this.responseData.flip();
            LOGGER.debug("  end of response received:\n{}", (Object)this.responseData.getString(this.getProxyIoSession().getCharset().newDecoder()));
            this.responseData.position(this.entityBodyStartPosition);
            this.responseData.limit(this.entityBodyLimitPosition);
            this.parsedResponse.setBody(this.responseData.getString(this.getProxyIoSession().getCharset().newDecoder()));
            this.responseData.free();
            this.responseData = null;
            this.handleResponse(this.parsedResponse);
            this.parsedResponse = null;
            this.hasChunkedData = false;
            this.contentLength = -1;
            ioBufferDecoder.setDelimiter(HTTP_DELIMITER, true);
            if (!this.isHandshakeComplete()) {
                this.doHandshake(nextFilter);
            }
        }
        catch (Exception exception) {
            if (exception instanceof ProxyAuthException) {
                throw (ProxyAuthException)exception;
            }
            throw new ProxyAuthException("Handshake failed", exception);
        }
    }

    public abstract void handleResponse(HttpProxyResponse var1) throws ProxyAuthException;

    public void writeRequest(IoFilter.NextFilter nextFilter, HttpProxyRequest httpProxyRequest) {
        ProxyIoSession proxyIoSession = this.getProxyIoSession();
        if (proxyIoSession.isReconnectionNeeded()) {
            this.reconnect(nextFilter, httpProxyRequest);
        } else {
            this.writeRequest0(nextFilter, httpProxyRequest);
        }
    }

    private void writeRequest0(IoFilter.NextFilter nextFilter, HttpProxyRequest httpProxyRequest) {
        try {
            String string = httpProxyRequest.toHttpString();
            IoBuffer ioBuffer = IoBuffer.wrap(string.getBytes(this.getProxyIoSession().getCharsetName()));
            LOGGER.debug("   write:\n{}", (Object)string.replace("\r", "\\r").replace("\n", "\\n\n"));
            this.writeData(nextFilter, ioBuffer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.closeSession("Unable to send HTTP request: ", unsupportedEncodingException);
        }
    }

    private void reconnect(final IoFilter.NextFilter nextFilter, final HttpProxyRequest httpProxyRequest) {
        LOGGER.debug("Reconnecting to proxy ...");
        final ProxyIoSession proxyIoSession = this.getProxyIoSession();
        proxyIoSession.getConnector().connect((IoSessionInitializer<? extends ConnectFuture>)new IoSessionInitializer<ConnectFuture>(){

            @Override
            public void initializeSession(IoSession ioSession, ConnectFuture connectFuture) {
                LOGGER.debug("Initializing new session: {}", (Object)ioSession);
                ioSession.setAttribute(ProxyIoSession.PROXY_SESSION, proxyIoSession);
                proxyIoSession.setSession(ioSession);
                LOGGER.debug("  setting up proxyIoSession: {}", (Object)proxyIoSession);
                connectFuture.addListener(new IoFutureListener<ConnectFuture>(){

                    @Override
                    public void operationComplete(ConnectFuture connectFuture) {
                        proxyIoSession.setReconnectionNeeded(false);
                        AbstractHttpLogicHandler.this.writeRequest0(nextFilter, httpProxyRequest);
                    }
                });
            }
        });
    }

    protected HttpProxyResponse decodeResponse(String string) throws Exception {
        LOGGER.debug("  parseResponse()");
        String[] stringArray = string.split("\r\n");
        String[] stringArray2 = stringArray[0].trim().split(" ", 2);
        if (stringArray2.length < 2) {
            throw new Exception("Invalid response status line (" + stringArray2 + "). Response: " + string);
        }
        if (stringArray2[1].matches("^\\d\\d\\d")) {
            throw new Exception("Invalid response code (" + stringArray2[1] + "). Response: " + string);
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split(":\\s?", 2);
            StringUtilities.addValueToHeader(hashMap, stringArray3[0], stringArray3[1], false);
        }
        return new HttpProxyResponse(stringArray2[0], stringArray2[1], hashMap);
    }
}

