/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class PNMImageEncoder
extends ImageEncoderImpl {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.jai.codecimpl.PNMImageEncoder";
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;

    public PNMImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new PNMEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n;
        Object[] objectArray;
        boolean bl;
        boolean bl2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n2;
        SampleModel sampleModel;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        block61: {
            ComponentSampleModel componentSampleModel;
            ColorModel colorModel;
            block60: {
                int n8;
                n7 = renderedImage.getMinX();
                n6 = renderedImage.getMinY();
                n5 = renderedImage.getWidth();
                n4 = renderedImage.getHeight();
                n3 = renderedImage.getTileHeight();
                sampleModel = renderedImage.getSampleModel();
                colorModel = renderedImage.getColorModel();
                String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
                this.lineSeparator = string.getBytes();
                int n9 = sampleModel.getTransferType();
                if (n9 == 4 || n9 == 5) {
                    throw new RuntimeException(JaiI18N.getString("PNMImageEncoder0"));
                }
                int[] nArray = sampleModel.getSampleSize();
                n2 = sampleModel.getNumBands();
                byArray3 = null;
                byArray2 = null;
                byArray = null;
                bl2 = false;
                if (n2 == 1) {
                    if (colorModel instanceof IndexColorModel) {
                        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                        n8 = indexColorModel.getMapSize();
                        if (n8 < 1 << nArray[0]) {
                            throw new RuntimeException(JaiI18N.getString("PNMImageEncoder1"));
                        }
                        if (nArray[0] == 1) {
                            this.variant = 52;
                            bl2 = indexColorModel.getRed(1) + indexColorModel.getGreen(1) + indexColorModel.getBlue(1) > indexColorModel.getRed(0) + indexColorModel.getGreen(0) + indexColorModel.getBlue(0);
                        } else {
                            this.variant = 54;
                            byArray3 = new byte[n8];
                            byArray2 = new byte[n8];
                            byArray = new byte[n8];
                            indexColorModel.getReds(byArray3);
                            indexColorModel.getGreens(byArray2);
                            indexColorModel.getBlues(byArray);
                        }
                    } else {
                        this.variant = nArray[0] == 1 ? 52 : (nArray[0] <= 8 ? 53 : 50);
                    }
                } else if (n2 == 3) {
                    this.variant = nArray[0] <= 8 && nArray[1] <= 8 && nArray[2] <= 8 ? 54 : 51;
                } else {
                    throw new RuntimeException(JaiI18N.getString("PNMImageEncoder2"));
                }
                if (((PNMEncodeParam)this.param).getRaw()) {
                    if (!this.isRaw(this.variant)) {
                        boolean bl3 = true;
                        for (n8 = 0; n8 < nArray.length; ++n8) {
                            if (nArray[n8] <= 8) continue;
                            bl3 = false;
                            break;
                        }
                        if (bl3) {
                            this.variant += 3;
                        }
                    }
                } else if (this.isRaw(this.variant)) {
                    this.variant -= 3;
                }
                this.maxValue = (1 << nArray[0]) - 1;
                this.output.write(80);
                this.output.write(this.variant);
                this.output.write(this.lineSeparator);
                this.output.write(COMMENT.getBytes());
                this.output.write(this.lineSeparator);
                this.writeInteger(this.output, n5);
                this.output.write(32);
                this.writeInteger(this.output, n4);
                if (this.variant != 52 && this.variant != 49) {
                    this.output.write(this.lineSeparator);
                    this.writeInteger(this.output, this.maxValue);
                }
                if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
                    this.output.write(10);
                }
                bl = false;
                if (this.variant != 52 || sampleModel.getTransferType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel)) break block60;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                if (multiPixelPackedSampleModel.getDataBitOffset() != 0 || multiPixelPackedSampleModel.getPixelBitStride() != 1) break block61;
                bl = true;
                break block61;
            }
            if ((this.variant == 53 || this.variant == 54) && sampleModel instanceof ComponentSampleModel && !(colorModel instanceof IndexColorModel) && (componentSampleModel = (ComponentSampleModel)sampleModel).getPixelStride() == n2) {
                bl = true;
                if (this.variant == 54) {
                    objectArray = componentSampleModel.getBandOffsets();
                    for (n = 0; n < n2; ++n) {
                        if (objectArray[n] == n) continue;
                        bl = false;
                        break;
                    }
                }
            }
        }
        if (bl) {
            int n10 = this.variant == 52 ? (n5 + 7) / 8 : n5 * sampleModel.getNumBands();
            int n11 = renderedImage.getNumYTiles();
            Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinTileY() * renderedImage.getTileHeight() + renderedImage.getTileGridYOffset(), renderedImage.getWidth(), renderedImage.getTileHeight());
            byte[] byArray4 = null;
            if (bl2) {
                byArray4 = new byte[n10];
            }
            for (int i = 0; i < n11; ++i) {
                int n12;
                if (i == n11 - 1) {
                    rectangle2.height = renderedImage.getHeight() - rectangle2.y;
                }
                Rectangle rectangle3 = rectangle2.intersection(rectangle);
                Raster raster = renderedImage.getData(rectangle3);
                byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n13 = n12 = this.variant == 52 ? ((MultiPixelPackedSampleModel)raster.getSampleModel()).getScanlineStride() : ((ComponentSampleModel)raster.getSampleModel()).getScanlineStride();
                if (n12 == n10 && !bl2) {
                    this.output.write(byArray5, 0, byArray5.length);
                } else {
                    int n14 = 0;
                    for (int j = 0; j < rectangle3.height; ++j) {
                        if (bl2) {
                            for (int k = 0; k < n10; ++k) {
                                byArray4[k] = (byte)(~(byArray5[n14 + k] & 0xFF));
                            }
                            this.output.write(byArray4, 0, n10);
                        } else {
                            this.output.write(byArray5, n14, n10);
                        }
                        n14 += n12;
                    }
                }
                rectangle2.y += n3;
            }
            this.output.flush();
            return;
        }
        int[] nArray = new int[8 * n5 * n2];
        objectArray = byArray3 == null ? new byte[8 * n5 * n2] : new byte[8 * n5 * 3];
        n = 0;
        int n15 = n6 + n4;
        block12: for (int i = n6; i < n15; i += 8) {
            int n16;
            int n17 = Math.min(8, n15 - i);
            int n18 = n17 * n5 * n2;
            Raster raster = renderedImage.getData(new Rectangle(n7, i, n5, n17));
            raster.getPixels(n7, i, n5, n17, nArray);
            if (bl2) {
                n16 = 0;
                while (n16 < n18) {
                    int n19 = n16++;
                    nArray[n19] = nArray[n19] ^ 1;
                }
            }
            switch (this.variant) {
                case 49: 
                case 50: {
                    for (n16 = 0; n16 < n18; ++n16) {
                        if (n++ % 16 == 0) {
                            this.output.write(this.lineSeparator);
                        } else {
                            this.output.write(32);
                        }
                        this.writeInteger(this.output, nArray[n16]);
                    }
                    this.output.write(this.lineSeparator);
                    continue block12;
                }
                case 51: {
                    if (byArray3 == null) {
                        for (n16 = 0; n16 < n18; ++n16) {
                            if (n++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, nArray[n16]);
                        }
                    } else {
                        for (n16 = 0; n16 < n18; ++n16) {
                            if (n++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, byArray3[nArray[n16]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray2[nArray[n16]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray[nArray[n16]] & 0xFF);
                        }
                    }
                    this.output.write(this.lineSeparator);
                    continue block12;
                }
                case 52: {
                    int n20;
                    int n21;
                    n16 = 0;
                    int n22 = 0;
                    for (n21 = 0; n21 < n18 / 8; ++n21) {
                        n20 = nArray[n22++] << 7 | nArray[n22++] << 6 | nArray[n22++] << 5 | nArray[n22++] << 4 | nArray[n22++] << 3 | nArray[n22++] << 2 | nArray[n22++] << 1 | nArray[n22++];
                        objectArray[n16++] = (byte)n20;
                    }
                    if (n18 % 8 > 0) {
                        n21 = 0;
                        for (n20 = 0; n20 < n18 % 8; ++n20) {
                            n21 |= nArray[n18 + n20] << 7 - n20;
                        }
                        objectArray[n16++] = (byte)n21;
                    }
                    this.output.write((byte[])objectArray, 0, (n18 + 7) / 8);
                    continue block12;
                }
                case 53: {
                    int n21;
                    for (n21 = 0; n21 < n18; ++n21) {
                        objectArray[n21] = (byte)nArray[n21];
                    }
                    this.output.write((byte[])objectArray, 0, n18);
                    continue block12;
                }
                case 54: {
                    int n20;
                    int n21;
                    if (byArray3 == null) {
                        for (n21 = 0; n21 < n18; ++n21) {
                            objectArray[n21] = (byte)(nArray[n21] & 0xFF);
                        }
                    } else {
                        n20 = 0;
                        for (n21 = 0; n21 < n18; ++n21) {
                            objectArray[n20++] = byArray3[nArray[n21]];
                            objectArray[n20++] = byArray2[nArray[n21]];
                            objectArray[n20++] = byArray[nArray[n21]];
                        }
                    }
                    this.output.write((byte[])objectArray, 0, objectArray.length);
                }
            }
        }
        this.output.flush();
    }

    private void writeInteger(OutputStream outputStream, int n) throws IOException {
        outputStream.write(Integer.toString(n).getBytes());
    }

    private void writeByte(OutputStream outputStream, byte by) throws IOException {
        outputStream.write(Byte.toString(by).getBytes());
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }
}

