/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.FlatIconButtonUI;
import net.infonode.gui.UIManagerUtil;
import net.infonode.gui.border.HighlightBorder;
import net.infonode.util.ColorUtil;

public class ButtonFactory {
    private static final Border normalBorder = new CompoundBorder(new LineBorder(new Color(70, 70, 70)), new CompoundBorder(new HighlightBorder(), new EmptyBorder(1, 6, 1, 6)));
    private static final Border pressedBorder = new CompoundBorder(new LineBorder(new Color(70, 70, 70)), new CompoundBorder(new HighlightBorder(true), new EmptyBorder(2, 7, 0, 5)));
    static /* synthetic */ Class class$net$infonode$gui$ButtonFactory;

    private ButtonFactory() {
    }

    private static JButton initButton(final JButton jButton) {
        jButton.setMargin(null);
        jButton.setBorder(normalBorder);
        jButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                jButton.setBorder(pressedBorder);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                jButton.setBorder(normalBorder);
            }
        });
        return jButton;
    }

    private static JButton newButton(String string) {
        return ButtonFactory.initButton(new JButton(string));
    }

    private static JButton newButton(Icon icon) {
        return ButtonFactory.initButton(new JButton(icon));
    }

    private static JButton newButton(Icon icon, String string) {
        return ButtonFactory.initButton(new JButton(string, icon));
    }

    public static final JButton createDialogButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setFont(jButton.getFont().deriveFont(1));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static final JButton createButton(String string, ActionListener actionListener) {
        return ButtonFactory.createButton(string, true, actionListener);
    }

    public static final JButton createButton(String string, boolean bl, ActionListener actionListener) {
        JButton jButton = ButtonFactory.newButton(string);
        jButton.setOpaque(bl);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static final JButton createButton(String string, String string2, ActionListener actionListener) {
        URL uRL = (class$net$infonode$gui$ButtonFactory == null ? (class$net$infonode$gui$ButtonFactory = ButtonFactory.class$("net.infonode.gui.ButtonFactory")) : class$net$infonode$gui$ButtonFactory).getClassLoader().getResource(string);
        return ButtonFactory.createButton(uRL == null ? null : new ImageIcon(uRL), string2, actionListener);
    }

    public static final JButton createButton(Icon icon, String string, ActionListener actionListener) {
        JButton jButton;
        if (icon != null) {
            jButton = ButtonFactory.newButton(icon);
            jButton.setToolTipText(string);
        } else {
            jButton = ButtonFactory.newButton(string);
        }
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static final JButton createButton(Icon icon, String string, boolean bl, ActionListener actionListener) {
        JButton jButton = ButtonFactory.newButton(icon);
        jButton.setToolTipText(string);
        jButton.addActionListener(actionListener);
        jButton.setOpaque(bl);
        return jButton;
    }

    public static final JButton createFlatHighlightButton(Icon icon, String string, int n, ActionListener actionListener) {
        JButton jButton = new JButton(icon){

            public void setUI(ButtonUI buttonUI) {
                super.setUI(new FlatIconButtonUI());
            }
        };
        jButton.setVerticalAlignment(0);
        jButton.setToolTipText(string);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        new ButtonHighlighter(jButton, n);
        jButton.setRolloverEnabled(true);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    public static final void applyButtonHighlighter(JButton jButton, int n) {
        jButton.setVerticalAlignment(0);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        new ButtonHighlighter(jButton, n);
        jButton.setRolloverEnabled(true);
    }

    public static final JButton createFlatHighlightButton(Icon icon, String string, int n, boolean bl, ActionListener actionListener) {
        JButton jButton = ButtonFactory.createFlatHighlightButton(icon, string, n, actionListener);
        jButton.setFocusable(bl);
        return jButton;
    }

    public static final JButton createHighlightButton(String string, ActionListener actionListener) {
        JButton jButton = ButtonFactory.newButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static final JButton createHighlightButton(Icon icon, ActionListener actionListener) {
        JButton jButton = ButtonFactory.newButton(icon);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static final JButton createHighlightButton(Icon icon, String string, ActionListener actionListener) {
        JButton jButton = ButtonFactory.newButton(icon, string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static final JButton createFlatIconHoverButton(Icon icon, Icon icon2, Icon icon3) {
        JButton jButton = new JButton(icon){

            public void setUI(ButtonUI buttonUI) {
                super.setUI(new FlatIconButtonUI());
            }
        };
        jButton.setPressedIcon(icon3);
        jButton.setRolloverEnabled(true);
        jButton.setRolloverIcon(icon2);
        jButton.setVerticalAlignment(0);
        return jButton;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ButtonHighlighter
    implements ComponentListener,
    HierarchyListener {
        private JButton button;
        private Border pressedBorder;
        private Border highlightedBorder;
        private Border normalBorder;
        private boolean rollover;
        private long rolloverStart;

        ButtonHighlighter(JButton jButton, int n) {
            this.button = jButton;
            this.normalBorder = new EmptyBorder(n + 2, n + 2, n + 2, n + 2);
            this.pressedBorder = new EmptyBorder(n + 2, n + 2, n, n);
            this.highlightedBorder = new EmptyBorder(n + 1, n + 1, n + 1, n + 1);
            jButton.setContentAreaFilled(false);
            this.setNormalState();
            jButton.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ ButtonHighlighter this$0;
                {
                    this.this$0 = buttonHighlighter;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    ButtonHighlighter.access$002(this.this$0, System.currentTimeMillis() - ButtonHighlighter.access$100(this.this$0) > 20L && ButtonHighlighter.access$200(this.this$0).getModel().isRollover());
                    ButtonHighlighter.access$300(this.this$0);
                    if (ButtonHighlighter.access$200(this.this$0).getModel().isRollover()) {
                        ButtonHighlighter.access$102(this.this$0, 0L);
                    }
                }
            });
            jButton.addHierarchyListener(this);
            jButton.addComponentListener(this);
        }

        private void setNormalState() {
            this.button.setBackground(null);
            this.button.setOpaque(false);
            this.button.setBorder(this.normalBorder);
            this.rollover = false;
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        private void update() {
            boolean bl = this.button.getModel().isArmed();
            if (this.button.isEnabled() && (this.rollover || bl)) {
                this.button.setOpaque(true);
                Color color = ComponentUtil.getBackgroundColor(this.button.getParent());
                color = color == null ? UIManagerUtil.getColor("control", Color.LIGHT_GRAY) : color;
                this.button.setBackground(ColorUtil.mult(color, bl ? 0.8 : 1.15));
                this.button.setBorder(bl ? new CompoundBorder(new LineBorder(ColorUtil.mult(color, 0.3)), this.pressedBorder) : new CompoundBorder(new LineBorder(ColorUtil.mult(color, 0.5)), this.highlightedBorder));
            } else {
                this.setNormalState();
            }
        }

        static /* synthetic */ boolean access$002(ButtonHighlighter buttonHighlighter, boolean bl) {
            buttonHighlighter.rollover = bl;
            return buttonHighlighter.rollover;
        }

        static /* synthetic */ long access$100(ButtonHighlighter buttonHighlighter) {
            return buttonHighlighter.rolloverStart;
        }

        static /* synthetic */ JButton access$200(ButtonHighlighter buttonHighlighter) {
            return buttonHighlighter.button;
        }

        static /* synthetic */ void access$300(ButtonHighlighter buttonHighlighter) {
            buttonHighlighter.update();
        }

        static /* synthetic */ long access$102(ButtonHighlighter buttonHighlighter, long l) {
            buttonHighlighter.rolloverStart = l;
            return buttonHighlighter.rolloverStart;
        }
    }
}

