/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class FileExtensionFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private String _description;
    private String[] _exts;

    public FileExtensionFilter(String description, String[] exts) {
        this._exts = exts;
        StringBuffer buf = new StringBuffer(description);
        buf.append(" (");
        for (int i = 0; i < this._exts.length; ++i) {
            buf.append("*").append(this._exts[i]);
            if (i == this._exts.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        this._description = buf.toString();
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.checkFileName(name.toLowerCase());
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.checkFileName(file.getName().toLowerCase());
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    private boolean checkFileName(String name) {
        for (int i = 0; i < this._exts.length; ++i) {
            if (!name.endsWith(this._exts[i])) continue;
            return true;
        }
        return false;
    }
}

