/**
 * The CSS2Properties interface represents a convenience mechanism for retrieving and setting properties within a CSSStyleDeclaration. The attributes of this interface correspond to all the properties specified in CSS2. Getting an attribute of this interface is equivalent to calling the getPropertyValue method of the CSSStyleDeclaration interface. Setting an attribute of this interface is equivalent to calling the setProperty method of the CSSStyleDeclaration interface.A conformant implementation of the CSS module is not required to implement the CSS2Properties interface. If an implementation does implement this interface, the expectation is that language-specific methods can be used to cast from an instance of the CSSStyleDeclaration interface to the CSS2Properties interface.If an implementation does implement this interface, it is expected to understand the specific syntax of the shorthand properties, and apply their semantics; when the margin property is set, for example, the marginTop, marginRight, marginBottom and marginLeft properties are actually being set by the underlying implementation.When dealing with CSS "shorthand" properties, the shorthand properties should be decomposed into their component longhand properties as appropriate, and when querying for their value, the form returned should be the shortest form exactly equivalent to the declarations made in the ruleset. However, if there is no shorthand declaration that could be added to the ruleset without changing in any way the rules already declared in the ruleset (i.e., by adding longhand rules that were previously not declared in the ruleset), then the empty string should be returned for the shorthand property.For example, querying for the font property should not return "normal normal normal 14pt/normal Arial, sans-serif", when "14pt Arial, sans-serif" suffices. (The normals are initial values, and are implied by use of the longhand property.)If the values for all the longhand properties that compose a particular string are the initial values, then a string consisting of all the initial values should be returned (e.g. a border-width value of "medium" should be returned as such, not as "").For some shorthand properties that take missing values from other sides, such as the margin, padding, and border-[width|style|color] properties, the minimum number of sides possible should be used; i.e., "0px 10px" will be returned instead of "0px 10px 0px 10px".If the value of a shorthand property can not be decomposed into its component longhand properties, as is the case for the font property with a value of "menu", querying for the values of the component longhand properties should return the empty string.
 */
var CSS2Properties = {
}
/**
 * See the line-height property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.lineHeight
 * @returns {String} 
 */
CSS2Properties.prototype.lineHeight = new String();

/**
 * See the cursor property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.cursor
 * @returns {String} 
 */
CSS2Properties.prototype.cursor = new String();

/**
 * See the border-right-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderRightStyle
 * @returns {String} 
 */
CSS2Properties.prototype.borderRightStyle = new String();

/**
 * See the visibility property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.visibility
 * @returns {String} 
 */
CSS2Properties.prototype.visibility = new String();

/**
 * See the speak-punctuation property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.speakPunctuation
 * @returns {String} 
 */
CSS2Properties.prototype.speakPunctuation = new String();

/**
 * See the font-variant property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.fontVariant
 * @returns {String} 
 */
CSS2Properties.prototype.fontVariant = new String();

/**
 * See the background-attachment property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.backgroundAttachment
 * @returns {String} 
 */
CSS2Properties.prototype.backgroundAttachment = new String();

/**
 * See the pause-before property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pauseBefore
 * @returns {String} 
 */
CSS2Properties.prototype.pauseBefore = new String();

/**
 * See the cue property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.cue
 * @returns {String} 
 */
CSS2Properties.prototype.cue = new String();

/**
 * See the text-decoration property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.textDecoration
 * @returns {String} 
 */
CSS2Properties.prototype.textDecoration = new String();

/**
 * See the float property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.cssFloat
 * @returns {String} 
 */
CSS2Properties.prototype.cssFloat = new String();

/**
 * See the page property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.page
 * @returns {String} 
 */
CSS2Properties.prototype.page = new String();

/**
 * See the margin property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.margin
 * @returns {String} 
 */
CSS2Properties.prototype.margin = new String();

/**
 * See the border property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.border
 * @returns {String} 
 */
CSS2Properties.prototype.border = new String();

/**
 * See the right property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.right
 * @returns {String} 
 */
CSS2Properties.prototype.right = new String();

/**
 * See the border-spacing property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderSpacing
 * @returns {String} 
 */
CSS2Properties.prototype.borderSpacing = new String();

/**
 * See the list-style-position property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.listStylePosition
 * @returns {String} 
 */
CSS2Properties.prototype.listStylePosition = new String();

/**
 * See the padding-top property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.paddingTop
 * @returns {String} 
 */
CSS2Properties.prototype.paddingTop = new String();

/**
 * See the pitch-range property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pitchRange
 * @returns {String} 
 */
CSS2Properties.prototype.pitchRange = new String();

/**
 * See the border-bottom property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderBottom
 * @returns {String} 
 */
CSS2Properties.prototype.borderBottom = new String();

/**
 * See the font-size property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.fontSize
 * @returns {String} 
 */
CSS2Properties.prototype.fontSize = new String();

/**
 * See the padding-left property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.paddingLeft
 * @returns {String} 
 */
CSS2Properties.prototype.paddingLeft = new String();

/**
 * See the content property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.content
 * @returns {String} 
 */
CSS2Properties.prototype.content = new String();

/**
 * See the outline-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.outlineWidth
 * @returns {String} 
 */
CSS2Properties.prototype.outlineWidth = new String();

/**
 * See the font-weight property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.fontWeight
 * @returns {String} 
 */
CSS2Properties.prototype.fontWeight = new String();

/**
 * See the min-height property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.minHeight
 * @returns {String} 
 */
CSS2Properties.prototype.minHeight = new String();

/**
 * See the border-top property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderTop
 * @returns {String} 
 */
CSS2Properties.prototype.borderTop = new String();

/**
 * See the border-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderWidth
 * @returns {String} 
 */
CSS2Properties.prototype.borderWidth = new String();

/**
 * See the bottom property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.bottom
 * @returns {String} 
 */
CSS2Properties.prototype.bottom = new String();

/**
 * See the border-right-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderRightWidth
 * @returns {String} 
 */
CSS2Properties.prototype.borderRightWidth = new String();

/**
 * See the position property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.position
 * @returns {String} 
 */
CSS2Properties.prototype.position = new String();

/**
 * See the border-color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderColor
 * @returns {String} 
 */
CSS2Properties.prototype.borderColor = new String();

/**
 * See the outline property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.outline
 * @returns {String} 
 */
CSS2Properties.prototype.outline = new String();

/**
 * See the marker-offset property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.markerOffset
 * @returns {String} 
 */
CSS2Properties.prototype.markerOffset = new String();

/**
 * See the unicode-bidi property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.unicodeBidi
 * @returns {String} 
 */
CSS2Properties.prototype.unicodeBidi = new String();

/**
 * See the vertical-align property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.verticalAlign
 * @returns {String} 
 */
CSS2Properties.prototype.verticalAlign = new String();

/**
 * See the caption-side property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.captionSide
 * @returns {String} 
 */
CSS2Properties.prototype.captionSide = new String();

/**
 * See the clear property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.clear
 * @returns {String} 
 */
CSS2Properties.prototype.clear = new String();

/**
 * See the speech-rate property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.speechRate
 * @returns {String} 
 */
CSS2Properties.prototype.speechRate = new String();

/**
 * See the richness property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.richness
 * @returns {String} 
 */
CSS2Properties.prototype.richness = new String();

/**
 * See the border-left-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderLeftWidth
 * @returns {String} 
 */
CSS2Properties.prototype.borderLeftWidth = new String();

/**
 * See the left property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.left
 * @returns {String} 
 */
CSS2Properties.prototype.left = new String();

/**
 * See the font-family property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.fontFamily
 * @returns {String} 
 */
CSS2Properties.prototype.fontFamily = new String();

/**
 * See the padding-bottom property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.paddingBottom
 * @returns {String} 
 */
CSS2Properties.prototype.paddingBottom = new String();

/**
 * See the cue-after property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.cueAfter
 * @returns {String} 
 */
CSS2Properties.prototype.cueAfter = new String();

/**
 * See the page-break-inside property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pageBreakInside
 * @returns {String} 
 */
CSS2Properties.prototype.pageBreakInside = new String();

/**
 * See the elevation property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.elevation
 * @returns {String} 
 */
CSS2Properties.prototype.elevation = new String();

/**
 * See the speak property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.speak
 * @returns {String} 
 */
CSS2Properties.prototype.speak = new String();

/**
 * See the font-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.fontStyle
 * @returns {String} 
 */
CSS2Properties.prototype.fontStyle = new String();

/**
 * See the list-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.listStyle
 * @returns {String} 
 */
CSS2Properties.prototype.listStyle = new String();

/**
 * See the padding-right property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.paddingRight
 * @returns {String} 
 */
CSS2Properties.prototype.paddingRight = new String();

/**
 * See the margin-bottom property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.marginBottom
 * @returns {String} 
 */
CSS2Properties.prototype.marginBottom = new String();

/**
 * See the orphans property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.orphans
 * @returns {String} 
 */
CSS2Properties.prototype.orphans = new String();

/**
 * See the outline-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.outlineStyle
 * @returns {String} 
 */
CSS2Properties.prototype.outlineStyle = new String();

/**
 * See the background property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.background
 * @returns {String} 
 */
CSS2Properties.prototype.background = new String();

/**
 * See the volume property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.volume
 * @returns {String} 
 */
CSS2Properties.prototype.volume = new String();

/**
 * See the page-break-after property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pageBreakAfter
 * @returns {String} 
 */
CSS2Properties.prototype.pageBreakAfter = new String();

/**
 * See the border-bottom-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderBottomStyle
 * @returns {String} 
 */
CSS2Properties.prototype.borderBottomStyle = new String();

/**
 * See the background-color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.backgroundColor
 * @returns {String} 
 */
CSS2Properties.prototype.backgroundColor = new String();

/**
 * See the margin-left property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.marginLeft
 * @returns {String} 
 */
CSS2Properties.prototype.marginLeft = new String();

/**
 * See the marks property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.marks
 * @returns {String} 
 */
CSS2Properties.prototype.marks = new String();

/**
 * See the min-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.minWidth
 * @returns {String} 
 */
CSS2Properties.prototype.minWidth = new String();

/**
 * See the border-left-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderLeftStyle
 * @returns {String} 
 */
CSS2Properties.prototype.borderLeftStyle = new String();

/**
 * See the border-top-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderTopStyle
 * @returns {String} 
 */
CSS2Properties.prototype.borderTopStyle = new String();

/**
 * See the speak-header property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.speakHeader
 * @returns {String} 
 */
CSS2Properties.prototype.speakHeader = new String();

/**
 * See the border-left property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderLeft
 * @returns {String} 
 */
CSS2Properties.prototype.borderLeft = new String();

/**
 * See the padding property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.padding
 * @returns {String} 
 */
CSS2Properties.prototype.padding = new String();

/**
 * See the border-collapse property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderCollapse
 * @returns {String} 
 */
CSS2Properties.prototype.borderCollapse = new String();

/**
 * See the pause property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pause
 * @returns {String} 
 */
CSS2Properties.prototype.pause = new String();

/**
 * See the height property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.height
 * @returns {String} 
 */
CSS2Properties.prototype.height = new String();

/**
 * See the max-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.maxWidth
 * @returns {String} 
 */
CSS2Properties.prototype.maxWidth = new String();

/**
 * See the border-right property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderRight
 * @returns {String} 
 */
CSS2Properties.prototype.borderRight = new String();

/**
 * See the white-space property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.whiteSpace
 * @returns {String} 
 */
CSS2Properties.prototype.whiteSpace = new String();

/**
 * See the widows property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.widows
 * @returns {String} 
 */
CSS2Properties.prototype.widows = new String();

/**
 * See the letter-spacing property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.letterSpacing
 * @returns {String} 
 */
CSS2Properties.prototype.letterSpacing = new String();

/**
 * See the margin-top property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.marginTop
 * @returns {String} 
 */
CSS2Properties.prototype.marginTop = new String();

/**
 * See the font property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.font
 * @returns {String} 
 */
CSS2Properties.prototype.font = new String();

/**
 * See the background-repeat property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.backgroundRepeat
 * @returns {String} 
 */
CSS2Properties.prototype.backgroundRepeat = new String();

/**
 * See the width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.width
 * @returns {String} 
 */
CSS2Properties.prototype.width = new String();

/**
 * See the empty-cells property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.emptyCells
 * @returns {String} 
 */
CSS2Properties.prototype.emptyCells = new String();

/**
 * See the stress property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.stress
 * @returns {String} 
 */
CSS2Properties.prototype.stress = new String();

/**
 * See the background-image property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.backgroundImage
 * @returns {String} 
 */
CSS2Properties.prototype.backgroundImage = new String();

/**
 * See the display property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.display
 * @returns {String} 
 */
CSS2Properties.prototype.display = new String();

/**
 * See the size property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.size
 * @returns {String} 
 */
CSS2Properties.prototype.size = new String();

/**
 * See the border-left-color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderLeftColor
 * @returns {String} 
 */
CSS2Properties.prototype.borderLeftColor = new String();

/**
 * See the overflow property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.overflow
 * @returns {String} 
 */
CSS2Properties.prototype.overflow = new String();

/**
 * See the max-height property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.maxHeight
 * @returns {String} 
 */
CSS2Properties.prototype.maxHeight = new String();

/**
 * See the azimuth property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.azimuth
 * @returns {String} 
 */
CSS2Properties.prototype.azimuth = new String();

/**
 * See the word-spacing property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.wordSpacing
 * @returns {String} 
 */
CSS2Properties.prototype.wordSpacing = new String();

/**
 * See the list-style-type property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.listStyleType
 * @returns {String} 
 */
CSS2Properties.prototype.listStyleType = new String();

/**
 * See the pitch property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pitch
 * @returns {String} 
 */
CSS2Properties.prototype.pitch = new String();

/**
 * See the border-right-color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderRightColor
 * @returns {String} 
 */
CSS2Properties.prototype.borderRightColor = new String();

/**
 * See the border-style property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderStyle
 * @returns {String} 
 */
CSS2Properties.prototype.borderStyle = new String();

/**
 * See the z-index property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.zIndex
 * @returns {String} 
 */
CSS2Properties.prototype.zIndex = new String();

/**
 * See the counter-increment property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.counterIncrement
 * @returns {String} 
 */
CSS2Properties.prototype.counterIncrement = new String();

/**
 * See the border-bottom-color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderBottomColor
 * @returns {String} 
 */
CSS2Properties.prototype.borderBottomColor = new String();

/**
 * See the direction property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.direction
 * @returns {String} 
 */
CSS2Properties.prototype.direction = new String();

/**
 * See the table-layout property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.tableLayout
 * @returns {String} 
 */
CSS2Properties.prototype.tableLayout = new String();

/**
 * See the cue-before property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.cueBefore
 * @returns {String} 
 */
CSS2Properties.prototype.cueBefore = new String();

/**
 * See the text-indent property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.textIndent
 * @returns {String} 
 */
CSS2Properties.prototype.textIndent = new String();

/**
 * See the background-position property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.backgroundPosition
 * @returns {String} 
 */
CSS2Properties.prototype.backgroundPosition = new String();

/**
 * See the counter-reset property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.counterReset
 * @returns {String} 
 */
CSS2Properties.prototype.counterReset = new String();

/**
 * See the text-transform property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.textTransform
 * @returns {String} 
 */
CSS2Properties.prototype.textTransform = new String();

/**
 * See the text-align property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.textAlign
 * @returns {String} 
 */
CSS2Properties.prototype.textAlign = new String();

/**
 * See the border-top-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderTopWidth
 * @returns {String} 
 */
CSS2Properties.prototype.borderTopWidth = new String();

/**
 * See the top property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.top
 * @returns {String} 
 */
CSS2Properties.prototype.top = new String();

/**
 * See the clip property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.clip
 * @returns {String} 
 */
CSS2Properties.prototype.clip = new String();

/**
 * See the margin-right property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.marginRight
 * @returns {String} 
 */
CSS2Properties.prototype.marginRight = new String();

/**
 * See the border-top-color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderTopColor
 * @returns {String} 
 */
CSS2Properties.prototype.borderTopColor = new String();

/**
 * See the page-break-before property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pageBreakBefore
 * @returns {String} 
 */
CSS2Properties.prototype.pageBreakBefore = new String();

/**
 * See the outline-color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.outlineColor
 * @returns {String} 
 */
CSS2Properties.prototype.outlineColor = new String();

/**
 * See the voice-family property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.voiceFamily
 * @returns {String} 
 */
CSS2Properties.prototype.voiceFamily = new String();

/**
 * See the pause-after property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.pauseAfter
 * @returns {String} 
 */
CSS2Properties.prototype.pauseAfter = new String();

/**
 * See the speak-numeral property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.speakNumeral
 * @returns {String} 
 */
CSS2Properties.prototype.speakNumeral = new String();

/**
 * See the quotes property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.quotes
 * @returns {String} 
 */
CSS2Properties.prototype.quotes = new String();

/**
 * See the color property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.color
 * @returns {String} 
 */
CSS2Properties.prototype.color = new String();

/**
 * See the text-shadow property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.textShadow
 * @returns {String} 
 */
CSS2Properties.prototype.textShadow = new String();

/**
 * See the font-size-adjust property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.fontSizeAdjust
 * @returns {String} 
 */
CSS2Properties.prototype.fontSizeAdjust = new String();

/**
 * See the border-bottom-width property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.borderBottomWidth
 * @returns {String} 
 */
CSS2Properties.prototype.borderBottomWidth = new String();

/**
 * See the list-style-image property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.listStyleImage
 * @returns {String} 
 */
CSS2Properties.prototype.listStyleImage = new String();

/**
 * See the font-stretch property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.fontStretch
 * @returns {String} 
 */
CSS2Properties.prototype.fontStretch = new String();

/**
 * See the play-during property definition in CSS2. Exceptions on setting DOMException SYNTAX_ERR: Raised if the new value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this property is readonly.
 * @syntax cSS2Properties.playDuring
 * @returns {String} 
 */
CSS2Properties.prototype.playDuring = new String();

/**
 * Represents the CSS2Properties prototype object.
 * @syntax CSS2Properties.prototype
 * @static
 */
CSS2Properties.prototype;

