/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.tm4e.core.internal.utils.CompareUtils;
import org.eclipse.tm4e.core.theme.ColorMap;
import org.eclipse.tm4e.core.theme.IRawTheme;
import org.eclipse.tm4e.core.theme.IRawThemeSetting;
import org.eclipse.tm4e.core.theme.ParsedThemeRule;
import org.eclipse.tm4e.core.theme.ThemeTrieElement;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class Theme {
    private static final Pattern rrggbb = Pattern.compile("^#[0-9a-f]{6}", 2);
    private static final Pattern rrggbbaa = Pattern.compile("^#[0-9a-f]{8}", 2);
    private static final Pattern rgb = Pattern.compile("^#[0-9a-f]{3}", 2);
    private static final Pattern rgba = Pattern.compile("^#[0-9a-f]{4}", 2);
    private final ColorMap colorMap;
    private final ThemeTrieElement root;
    private final ThemeTrieElementRule defaults;
    private final Map<String, List<ThemeTrieElementRule>> cache;

    public static Theme createFromRawTheme(IRawTheme source) {
        return Theme.createFromParsedTheme(Theme.parseTheme(source));
    }

    public static List<ParsedThemeRule> parseTheme(IRawTheme source) {
        if (source == null || source.getSettings() == null) {
            return Collections.emptyList();
        }
        Collection<IRawThemeSetting> settings = source.getSettings();
        ArrayList<ParsedThemeRule> result = new ArrayList<ParsedThemeRule>();
        int i = 0;
        for (IRawThemeSetting entry : settings) {
            if (entry.getSetting() == null) continue;
            Object settingScope = entry.getScope();
            List<Object> scopes = new ArrayList<String>();
            if (settingScope instanceof String) {
                String scope = (String)settingScope;
                scope = scope.replaceAll("^[,]+", "");
                scope = scope.replaceAll("[,]+$", "");
                scopes = Arrays.asList(scope.split(","));
            } else if (settingScope instanceof List) {
                scopes = (List)settingScope;
            } else {
                scopes.add("");
            }
            int fontStyle = -1;
            Object settingsFontStyle = entry.getSetting().getFontStyle();
            if (settingsFontStyle instanceof String) {
                String[] segments;
                fontStyle = 0;
                for (String segment : segments = ((String)settingsFontStyle).split(" ")) {
                    if ("italic".equals(segment)) {
                        fontStyle |= 1;
                        continue;
                    }
                    if ("bold".equals(segment)) {
                        fontStyle |= 2;
                        continue;
                    }
                    if (!"underline".equals(segment)) continue;
                    fontStyle |= 4;
                }
            }
            String foreground = null;
            String settingsForeground = entry.getSetting().getForeground();
            if (settingsForeground instanceof String && Theme.isValidHexColor(settingsForeground)) {
                foreground = settingsForeground;
            }
            String background = null;
            String settingsBackground = entry.getSetting().getBackground();
            if (settingsBackground instanceof String && Theme.isValidHexColor(settingsBackground)) {
                background = settingsBackground;
            }
            int lenJ = scopes.size();
            for (int j = 0; j < lenJ; ++j) {
                String _scope = ((String)scopes.get(j)).trim();
                List<String> segments = Arrays.asList(_scope.split(" "));
                String scope = segments.get(segments.size() - 1);
                List<String> parentScopes = null;
                if (segments.size() > 1) {
                    parentScopes = segments.subList(0, segments.size() - 1);
                    Collections.reverse(parentScopes);
                }
                ParsedThemeRule t = new ParsedThemeRule(scope, parentScopes, i, fontStyle, foreground, background);
                result.add(t);
            }
            ++i;
        }
        return result;
    }

    private static boolean isValidHexColor(String hex) {
        if (hex == null || hex.length() < 1) {
            return false;
        }
        if (rrggbb.matcher(hex).matches()) {
            return true;
        }
        if (rrggbbaa.matcher(hex).matches()) {
            return true;
        }
        if (rgb.matcher(hex).matches()) {
            return true;
        }
        return rgba.matcher(hex).matches();
    }

    public static Theme createFromParsedTheme(List<ParsedThemeRule> source) {
        return Theme.resolveParsedThemeRules(source);
    }

    public static Theme resolveParsedThemeRules(List<ParsedThemeRule> parsedThemeRules) {
        parsedThemeRules.sort((a, b) -> {
            int r = CompareUtils.strcmp(a.scope, b.scope);
            if (r != 0) {
                return r;
            }
            r = CompareUtils.strArrCmp(a.parentScopes, b.parentScopes);
            if (r != 0) {
                return r;
            }
            return a.index - b.index;
        });
        int defaultFontStyle = 0;
        String defaultForeground = "#000000";
        String defaultBackground = "#ffffff";
        while (parsedThemeRules.size() >= 1 && "".equals(parsedThemeRules.get((int)0).scope)) {
            ParsedThemeRule incomingDefaults = parsedThemeRules.remove(0);
            if (incomingDefaults.fontStyle != -1) {
                defaultFontStyle = incomingDefaults.fontStyle;
            }
            if (incomingDefaults.foreground != null) {
                defaultForeground = incomingDefaults.foreground;
            }
            if (incomingDefaults.background == null) continue;
            defaultBackground = incomingDefaults.background;
        }
        ColorMap colorMap = new ColorMap();
        ThemeTrieElementRule defaults = new ThemeTrieElementRule(0, null, defaultFontStyle, colorMap.getId(defaultForeground), colorMap.getId(defaultBackground));
        ThemeTrieElement root = new ThemeTrieElement(new ThemeTrieElementRule(0, null, -1, 0, 0), Collections.emptyList());
        for (ParsedThemeRule rule : parsedThemeRules) {
            root.insert(0, rule.scope, rule.parentScopes, rule.fontStyle, colorMap.getId(rule.foreground), colorMap.getId(rule.background));
        }
        return new Theme(colorMap, defaults, root);
    }

    public Theme(ColorMap colorMap, ThemeTrieElementRule defaults, ThemeTrieElement root) {
        this.colorMap = colorMap;
        this.root = root;
        this.defaults = defaults;
        this.cache = new HashMap<String, List<ThemeTrieElementRule>>();
    }

    public Set<String> getColorMap() {
        return this.colorMap.getColorMap();
    }

    public String getColor(int id) {
        return this.colorMap.getColor(id);
    }

    public ThemeTrieElementRule getDefaults() {
        return this.defaults;
    }

    public List<ThemeTrieElementRule> match(String scopeName) {
        if (!this.cache.containsKey(scopeName)) {
            this.cache.put(scopeName, this.root.match(scopeName));
        }
        return this.cache.get(scopeName);
    }

    public int hashCode() {
        return Objects.hash(this.cache, this.colorMap, this.defaults, this.root);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Theme other = (Theme)obj;
        return Objects.equals(this.cache, other.cache) && Objects.equals(this.colorMap, other.colorMap) && Objects.equals(this.defaults, other.defaults) && Objects.equals(this.root, other.root);
    }
}

