/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cloud.oracle.Bundle;
import org.netbeans.modules.cloud.oracle.DownloadWalletAction;
import org.netbeans.modules.cloud.oracle.OCIItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.windows.WindowManager;

final class DownloadWalletDialog
extends JPanel {
    private static final String LAST_USED_DIR = "lastUsedDir";
    private static final String SPECIAL_CHARACTERS = "/!#$^?:.(){}[]~-_.";
    private DialogDescriptor descriptor;
    private JButton jButtonBrowse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPasswordField jPasswordField;
    private JPasswordField jPasswordFieldConfirm;
    private JTextArea jTextArea1;
    private JTextField jTextFieldLocation;

    DownloadWalletDialog() {
        this.initComponents();
        PasswordListener docListener = new PasswordListener();
        this.jPasswordField.getDocument().addDocumentListener(docListener);
        this.jPasswordFieldConfirm.getDocument().addDocumentListener(docListener);
    }

    static Optional<Pair<String, char[]>> showDialog(OCIItem db) {
        File home = new File(System.getProperty("user.home"));
        String lastUsedDir = NbPreferences.forModule(DownloadWalletAction.class).get(LAST_USED_DIR, home.getAbsolutePath());
        DownloadWalletDialog dlgPanel = new DownloadWalletDialog();
        dlgPanel.jTextFieldLocation.setText(lastUsedDir);
        DialogDescriptor descriptor = new DialogDescriptor((Object)dlgPanel, Bundle.DownloadTitle());
        dlgPanel.setDescriptor(descriptor);
        descriptor.createNotificationLineSupport();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setMinimumSize(dlgPanel.getPreferredSize());
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION == descriptor.getValue()) {
            String path = dlgPanel.jTextFieldLocation.getText();
            NbPreferences.forModule(DownloadWalletAction.class).put(LAST_USED_DIR, path);
            return Optional.of(Pair.of((Object)path, (Object)dlgPanel.jPasswordField.getPassword()));
        }
        return Optional.empty();
    }

    private void setDescriptor(DialogDescriptor descriptor) {
        if (this.descriptor != null) {
            throw new IllegalStateException("DialogDescriptor has been already set.");
        }
        this.descriptor = descriptor;
        descriptor.setValid(false);
    }

    private void initComponents() {
        this.jTextArea1 = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldLocation = new JTextField();
        this.jPasswordFieldConfirm = new JPasswordField();
        this.jPasswordField = new JPasswordField();
        this.jButtonBrowse = new JButton();
        this.setMaximumSize(null);
        this.setMinimumSize(new Dimension(714, 234));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(1);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(null);
        this.jTextArea1.setDragEnabled(false);
        this.jTextArea1.setFocusTraversalKeysEnabled(false);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setMinimumSize(new Dimension(702, 113));
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setPreferredSize(new Dimension(702, 113));
        this.jTextArea1.setRequestFocusEnabled(false);
        this.jLabel1.setLabelFor(this.jPasswordField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jLabel1.text"));
        this.jLabel2.setLabelFor(this.jPasswordFieldConfirm);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jLabel2.text"));
        this.jLabel3.setLabelFor(this.jTextFieldLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jLabel3.text"));
        this.jTextFieldLocation.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jTextFieldLocation.text"));
        this.jPasswordFieldConfirm.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jPasswordFieldConfirm.text"));
        this.jPasswordField.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jPasswordField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowse, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jButtonBrowse.text"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadWalletDialog.this.jButtonBrowseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextArea1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPasswordField).addComponent(this.jTextFieldLocation).addComponent(this.jPasswordFieldConfirm)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBrowse))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextArea1, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordFieldConfirm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldLocation, -2, -1, -2).addComponent(this.jButtonBrowse)).addContainerGap(16, Short.MAX_VALUE)));
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.LBL_SaveWallet());
        File folder = new File(this.jTextFieldLocation.getText());
        if (!folder.exists()) {
            folder = folder.getParentFile();
        }
        chooser.setCurrentDirectory(folder);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (0 == chooser.showDialog(WindowManager.getDefault().getMainWindow(), Bundle.SelectButton())) {
            this.jTextFieldLocation.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void errorMessage(String message) {
        if (message == null) {
            this.descriptor.getNotificationLineSupport().clearMessages();
            this.descriptor.setValid(true);
        } else {
            this.descriptor.setValid(false);
            this.descriptor.getNotificationLineSupport().setErrorMessage(message);
        }
    }

    private void checkPassword() {
        char[] passwd1 = this.jPasswordField.getPassword();
        char[] passwd2 = this.jPasswordFieldConfirm.getPassword();
        DownloadWalletDialog.checkPasswordLogic(passwd1, passwd2, m -> this.errorMessage((String)m));
    }

    static void checkPasswordLogic(char[] passwd1, char[] passwd2, Consumer<String> message) {
        if (passwd1.length < 8) {
            message.accept(Bundle.Lenght());
            return;
        }
        int nSpecialCharacters = 0;
        int nLetters = 0;
        for (int i = 0; i < passwd1.length; ++i) {
            if (Character.isLetter(passwd1[i])) {
                ++nLetters;
                continue;
            }
            if (SPECIAL_CHARACTERS.indexOf(passwd1[i]) < 0 && !Character.isDigit(passwd1[i])) continue;
            ++nSpecialCharacters;
        }
        if (nSpecialCharacters < 1) {
            message.accept(Bundle.OneNumber());
        } else if (nLetters < 1) {
            message.accept(Bundle.OneLetter());
        } else if (!Arrays.equals(passwd1, passwd2)) {
            message.accept(Bundle.Match());
        } else {
            message.accept(null);
        }
    }

    private class PasswordListener
    implements DocumentListener {
        private PasswordListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DownloadWalletDialog.this.checkPassword();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DownloadWalletDialog.this.checkPassword();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DownloadWalletDialog.this.checkPassword();
        }
    }
}

