/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.spi.WebPageMetadataProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public final class WebPageMetadata {
    public static final String MIMETYPE = "mimeType";
    private Map<String, ? extends Object> metamap;

    public static WebPageMetadata getMetadata(Lookup lookup) {
        TreeMap<String, ? extends Object> mergedMap = null;
        Collection providers = Lookup.getDefault().lookupAll(WebPageMetadataProvider.class);
        for (WebPageMetadataProvider provider : providers) {
            Map<String, ? extends Object> metamap = provider.getMetadataMap(lookup);
            if (metamap == null) continue;
            if (mergedMap == null) {
                mergedMap = new TreeMap<String, Object>();
            }
            mergedMap.putAll(metamap);
        }
        return mergedMap != null ? new WebPageMetadata(mergedMap) : null;
    }

    public static String getContentMimeType(Parser.Result parsed, boolean useSnapshot) {
        String mimeType;
        WebPageMetadata wpmeta = WebPageMetadata.getMetadata(parsed);
        if (wpmeta != null && (mimeType = (String)wpmeta.value(MIMETYPE)) != null) {
            return mimeType;
        }
        if (useSnapshot) {
            FileObject fo = parsed.getSnapshot().getSource().getFileObject();
            return fo != null ? fo.getMIMEType() : parsed.getSnapshot().getMimeType();
        }
        return null;
    }

    static WebPageMetadata getMetadata(Parser.Result parsed) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)parsed);
        AbstractLookup lkp = new AbstractLookup((AbstractLookup.Content)ic);
        if (parsed instanceof Lookup.Provider) {
            lkp = new ProxyLookup(new Lookup[]{lkp, ((Lookup.Provider)parsed).getLookup()});
        }
        return WebPageMetadata.getMetadata((Lookup)lkp);
    }

    public WebPageMetadata(Map<String, ? extends Object> metamap) {
        this.metamap = metamap;
    }

    public Collection<String> keys() {
        return this.metamap.keySet();
    }

    public Object value(String key) {
        return this.metamap.get(key);
    }
}

