/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.lexer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.CharStream;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.javascript2.json.api.JsonOptionsQuery;
import org.netbeans.modules.javascript2.json.parser.JsonLexer;
import org.netbeans.modules.javascript2.lexer.NbLexerCharStream;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.filesystems.FileObject;

public class JsonLexer
implements Lexer<JsTokenId> {
    private static final Logger LOGGER = Logger.getLogger(JsonLexer.class.getName());
    private final org.netbeans.modules.javascript2.json.parser.JsonLexer scanner;
    private TokenFactory<JsTokenId> tokenFactory;

    private JsonLexer(LexerRestartInfo<JsTokenId> info) {
        this.tokenFactory = info.tokenFactory();
        NbLexerCharStream charStream = new NbLexerCharStream(info);
        FileObject fo = (FileObject)info.getAttributeValue(FileObject.class);
        boolean allowComments = fo != null ? JsonOptionsQuery.getOptions((FileObject)fo).isCommentSupported() : false;
        this.scanner = new org.netbeans.modules.javascript2.json.parser.JsonLexer((CharStream)charStream, allowComments, true);
        if (info.state() != null && info.state() instanceof JsonLexer.LexerState) {
            this.scanner.setLexerState((JsonLexer.LexerState)info.state());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonLexer create(LexerRestartInfo<JsTokenId> info) {
        Class<JsonLexer> clazz = JsonLexer.class;
        synchronized (JsonLexer.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new JsonLexer(info);
        }
    }

    public Token<JsTokenId> nextToken() {
        org.antlr.v4.runtime.Token nextToken = this.scanner.nextToken();
        Token token = null;
        if (nextToken.getType() != -1) {
            token = this.tokenFactory.createToken((TokenId)JsonLexer.tokenId(nextToken.getType()));
            LOGGER.log(Level.FINEST, "Lexed token is {0}", token.id());
            return token;
        }
        return null;
    }

    public Object state() {
        return this.scanner.getState();
    }

    public void release() {
    }

    private static JsTokenId tokenId(int type) {
        switch (type) {
            case 1: {
                return JsTokenId.OPERATOR_COLON;
            }
            case 2: {
                return JsTokenId.OPERATOR_COMMA;
            }
            case 3: {
                return JsTokenId.OPERATOR_DOT;
            }
            case 4: {
                return JsTokenId.OPERATOR_PLUS;
            }
            case 5: {
                return JsTokenId.OPERATOR_MINUS;
            }
            case 6: {
                return JsTokenId.BRACKET_LEFT_CURLY;
            }
            case 7: {
                return JsTokenId.BRACKET_RIGHT_CURLY;
            }
            case 8: {
                return JsTokenId.BRACKET_LEFT_BRACKET;
            }
            case 9: {
                return JsTokenId.BRACKET_RIGHT_BRACKET;
            }
            case 10: {
                return JsTokenId.KEYWORD_TRUE;
            }
            case 11: {
                return JsTokenId.KEYWORD_FALSE;
            }
            case 12: {
                return JsTokenId.KEYWORD_NULL;
            }
            case 13: {
                return JsTokenId.NUMBER;
            }
            case 14: {
                return JsTokenId.STRING;
            }
            case 15: {
                return JsTokenId.LINE_COMMENT;
            }
            case 16: {
                return JsTokenId.BLOCK_COMMENT;
            }
            case 17: {
                return JsTokenId.WHITESPACE;
            }
        }
        return JsTokenId.ERROR;
    }
}

