/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public class ReturnNode
extends Statement {
    private final Expression expression;

    public ReturnNode(int n, long l, int n2, Expression expression) {
        super(n, l, n2);
        this.expression = expression;
    }

    private ReturnNode(ReturnNode returnNode, Expression expression) {
        super(returnNode);
        this.expression = expression;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    public boolean hasExpression() {
        return this.expression != null;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterReturnNode(this)) {
            if (this.expression != null) {
                return nodeVisitor.leaveReturnNode(this.setExpression((Expression)this.expression.accept(nodeVisitor)));
            }
            return nodeVisitor.leaveReturnNode(this);
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterReturnNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("return");
        if (this.expression != null) {
            stringBuilder.append(' ');
            this.expression.toString(stringBuilder, bl);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ReturnNode setExpression(Expression expression) {
        if (this.expression == expression) {
            return this;
        }
        return new ReturnNode(this, expression);
    }
}

