/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.web.core.api.JspContextInfo;
import org.netbeans.modules.web.jsfapi.spi.InputTextTagValueProvider;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.openide.filesystems.FileObject;

public class JspInputTextTagValueProvider
implements InputTextTagValueProvider {
    private static final String INPUT_TEXT_TAG_NAME = "h:inputText";
    private static final String VALUE_ATTR_NAME = "value";

    public Map<String, String> getInputTextValuesMap(FileObject fobj) {
        JspParserAPI.ParseResult result;
        HashMap<String, String> properties = new HashMap<String, String>();
        JspContextInfo contextInfo = JspContextInfo.getContextInfo((FileObject)fobj);
        if (contextInfo != null && (result = contextInfo.getCachedParseResult(fobj, false, true)) != null) {
            Node.Nodes nodes = result.getNodes();
            List<Node> foundNodes = new ArrayList<Node>();
            foundNodes = this.findValue(nodes, INPUT_TEXT_TAG_NAME, foundNodes);
            for (Node node : foundNodes) {
                String ref_val = node.getAttributeValue(VALUE_ATTR_NAME);
                String key = this.generateKey(ref_val, properties);
                properties.put(key, ref_val);
            }
        }
        return properties;
    }

    private List<Node> findValue(Node.Nodes nodes, String tagName, List<Node> foundNodes) {
        if (nodes == null) {
            return foundNodes;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.getNode(i);
            if (tagName.equals(node.getQName())) {
                foundNodes.add(node);
                continue;
            }
            foundNodes = this.findValue(node.getBody(), tagName, foundNodes);
        }
        return foundNodes;
    }

    private String generateKey(String value, Map<String, String> properties) {
        if (value.startsWith("#{")) {
            value = value.substring(2, value.length() - 1);
        }
        String result = value.substring(value.lastIndexOf(".") + 1, value.length()).toLowerCase();
        int i = 0;
        String tmp = result;
        while (properties.get(tmp) != null) {
            tmp = result + ++i;
        }
        return result;
    }
}

