/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;

public class SecurityTools {
    static int[] base64 = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64, 64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64, 64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    public static String base64Decode(String orig) {
        char[] chars = orig.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int shift = 0;
        int acc = 0;
        i = 0;
        while (i < chars.length) {
            int v = base64[chars[i] & 0xFF];
            if (v >= 64) {
                if (chars[i] != '=') {
                    System.out.println("Wrong char in base64: " + chars[i]);
                }
            } else {
                acc = acc << 6 | v;
                if ((shift += 6) >= 8) {
                    sb.append((char)(acc >> (shift -= 8) & 0xFF));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static void credentials(Request req, Hashtable credentials) {
        Context ctx = req.getContext();
        String login_type = ctx.getAuthMethod();
        if ("BASIC".equals(login_type)) {
            SecurityTools.basicCredentials(req, credentials);
        }
        if ("FORM".equals(login_type)) {
            SecurityTools.formCredentials(req, credentials);
        }
    }

    public static void basicCredentials(Request req, Hashtable credentials) {
        Context ctx = req.getContext();
        String authMethod = ctx.getAuthMethod();
        if (authMethod == null || "BASIC".equals(authMethod)) {
            String authorization = req.getHeader("Authorization");
            if (authorization == null) {
                return;
            }
            if (!authorization.startsWith("Basic ")) {
                return;
            }
            String unencoded = SecurityTools.base64Decode(authorization = authorization.substring(6).trim());
            int colon = unencoded.indexOf(58);
            if (colon < 0) {
                return;
            }
            credentials.put("username", unencoded.substring(0, colon));
            credentials.put("password", unencoded.substring(colon + 1));
        }
    }

    public static void formCredentials(Request req, Hashtable credentials) {
        Context ctx = req.getContext();
        String authMethod = ctx.getAuthMethod();
        if ("FORM".equals(authMethod)) {
            HttpSession session = req.getSession(false);
            if (session == null) {
                return;
            }
            String username = (String)session.getAttribute("j_username");
            String password = (String)session.getAttribute("j_password");
            if (username != null && password != null) {
                credentials.put("username", username);
                credentials.put("password", password);
            }
        }
    }

    public static boolean haveRole(String[] userRoles, String[] requiredRoles) {
        if (userRoles == null || requiredRoles == null) {
            return false;
        }
        int i = 0;
        while (i < userRoles.length) {
            if (SecurityTools.haveRole(userRoles[i], requiredRoles)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean haveRole(String element, String[] set) {
        if (element == null || set == null) {
            return false;
        }
        int i = 0;
        while (i < set.length) {
            if (element.equals(set[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

