/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.File;
import java.util.Vector;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.connector.JNIRequestAdapter;
import org.apache.tomcat.service.connector.JNIResponseAdapter;

public class JNIConnectionHandler {
    ContextManager contextM;
    static Vector pool = new Vector();
    static boolean reuse = true;

    public void setServer(Object contextM) {
        this.contextM = (ContextManager)contextM;
    }

    public void setNativeLibrary(String lib) {
        try {
            System.loadLibrary(lib);
            System.out.println("Library " + lib + " was loaded from the lib path");
            return;
        }
        catch (UnsatisfiedLinkError usl) {
            System.err.println("Failed to loadLibrary() " + lib);
            try {
                System.load(lib);
                System.out.println("Library " + lib + " loaded");
                return;
            }
            catch (UnsatisfiedLinkError usl2) {
                System.err.println("Failed to load() " + lib);
                File f = new File(System.getProperties().getProperty("tomcat.home"), "libexec");
                f = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0 ? new File(f, "jni_connect.dll") : new File(f, "jni_connect.so");
                System.load(f.toString());
                System.out.println("Library " + f.toString() + " loaded");
                return;
            }
        }
    }

    public void processConnection(long s, long l) {
        JNIRequestAdapter reqA = null;
        JNIResponseAdapter resA = null;
        try {
            if (reuse) {
                JNIConnectionHandler jNIConnectionHandler = this;
                synchronized (jNIConnectionHandler) {
                    if (pool.size() == 0) {
                        reqA = new JNIRequestAdapter(this.contextM, this);
                        resA = new JNIResponseAdapter(this);
                        this.contextM.initRequest(reqA, resA);
                    } else {
                        reqA = (JNIRequestAdapter)pool.lastElement();
                        resA = (JNIResponseAdapter)reqA.getResponse();
                        pool.removeElement(reqA);
                    }
                }
                reqA.recycle();
                resA.recycle();
            } else {
                reqA = new JNIRequestAdapter(this.contextM, this);
                resA = new JNIResponseAdapter(this);
                this.contextM.initRequest(reqA, resA);
            }
            resA.setRequestAttr(s, l);
            reqA.readNextRequest(s, l);
            if (reqA.shutdown) {
                return;
            }
            if (resA.getStatus() >= 400) {
                resA.finish();
                return;
            }
            int contentLength = reqA.getFacade().getIntHeader("content-length");
            if (contentLength != -1) {
                BufferedServletInputStream sis = (BufferedServletInputStream)reqA.getInputStream();
                sis.setLimit(contentLength);
            }
            this.contextM.service(reqA, resA);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (reuse) {
            JNIConnectionHandler jNIConnectionHandler = this;
            synchronized (jNIConnectionHandler) {
                pool.addElement(reqA);
            }
        }
    }

    native int readEnvironment(long var1, long var3, String[] var5);

    native int getNumberOfHeaders(long var1, long var3);

    native int readHeaders(long var1, long var3, String[] var5, String[] var6);

    native int read(long var1, long var3, byte[] var5, int var6, int var7);

    native int startReasponse(long var1, long var3, int var5, String var6, String[] var7, String[] var8, int var9);

    native int write(long var1, long var3, byte[] var5, int var6, int var7);
}

