/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.File;
import java.net.URLEncoder;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;

public class WorkDirInterceptor
extends BaseInterceptor {
    boolean cleanWorkDir = false;

    public void setCleanWorkDir(boolean b) {
        this.cleanWorkDir = b;
    }

    public void contextInit(Context ctx) {
        if (ctx.getWorkDir() == null) {
            this.setWorkDir(ctx);
        }
        if (!ctx.getWorkDir().exists()) {
            ctx.getWorkDir().mkdirs();
        }
        ctx.setAttribute("sun.servlet.workdir", ctx.getWorkDir());
        ctx.setAttribute("javax.servlet.context.tempdir", ctx.getWorkDir());
        if (this.cleanWorkDir) {
            this.clearDir(ctx.getWorkDir());
        }
    }

    public void contextShutdown(Context ctx) {
        if (this.cleanWorkDir) {
            this.clearDir(ctx.getWorkDir());
        }
    }

    private void setWorkDir(Context ctx) {
        ContextManager cm = ctx.getContextManager();
        StringBuffer sb = new StringBuffer();
        sb.append(cm.getWorkDir());
        sb.append(File.separator);
        String host = ctx.getHost();
        if (host == null) {
            sb.append(cm.getHostName());
        } else {
            sb.append(host);
        }
        sb.append("_").append(cm.getPort());
        sb.append(URLEncoder.encode(ctx.getPath()));
        ctx.setWorkDir(new File(sb.toString()));
    }

    private void clearDir(File dir) {
        String[] files = dir.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = new File(dir, files[i]);
                if (f.isDirectory()) {
                    this.clearDir(f);
                }
                try {
                    f.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            try {
                dir.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

