/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.fakepeer.FakePeerContainer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GlassPane;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.UndoRedoSupport;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AddGapsAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DesignContainerAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.RemoveGapsAction;
import org.openide.actions.RedoAction;
import org.openide.actions.UndoAction;
import org.openide.awt.AcceleratorBinding;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class GridDesigner
extends JPanel {
    public static final Color SELECTION_COLOR = FormLoaderSettings.getInstance().getSelectionBorderColor();
    public static final Image RESIZE_HANDLE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/resources/resize_handle.png", (boolean)false).getImage();
    private JPanel innerPane;
    private GlassPane glassPane;
    private VisualReplicator replicator;
    private GridManager gridManager;
    private PropertySheet sheet;
    private GridCustomizer customizer;
    private FormModel formModel;
    private static final int DEFAULT_GAP_WIDTH = 5;
    private static final int DEFAULT_GAP_HEIGHT = 5;
    private JToggleButton gapButton;
    private JSpinner gapWidthSpinner;
    private JSpinner gapHeightSpinner;
    private JLabel gapWidthSpinnerLabel;
    private JLabel gapHeightSpinnerLabel;
    private Component gapWidthSpinnerBox;
    private Component gapHeightSpinnerBox;
    private Set<RADVisualComponent> metaSelection = new HashSet<RADVisualComponent>();
    private PropertyChangeListener selectedNodeListener;
    boolean updateScheduled = false;
    private List<Node> selectedNodes = new ArrayList<Node>();
    private FormModelListener formModelListener;

    public void setDesignedContainer(RADVisualContainer metaContainer) {
        this.removeAll();
        this.formModel = metaContainer.getFormModel();
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        this.innerPane = new JPanel(){

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        this.innerPane.setLayout(new OverlayLayout(this.innerPane));
        this.glassPane = new GlassPane(this);
        this.glassPane.setOpaque(false);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        UndoRedoSupport support = UndoRedoSupport.getSupport(this.formModel);
        support.reset(this.glassPane);
        JButton undoButton = this.initUndoRedoButton(toolBar.add(support.getUndoAction()));
        toolBar.add(undoButton);
        JButton redoButton = this.initUndoRedoButton(toolBar.add(support.getRedoAction()));
        toolBar.add(redoButton);
        this.setupUndoRedoShortcut(true, support.getUndoAction());
        this.setupUndoRedoShortcut(false, support.getRedoAction());
        toolBar.add(Box.createRigidArea(new Dimension(15, 10)));
        this.gapButton = this.initGapButton();
        toolBar.add(this.gapButton);
        toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        this.gapWidthSpinnerLabel = new JLabel();
        this.gapWidthSpinnerLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/layoutsupport/griddesigner/resources/gap_width.png", (boolean)false));
        toolBar.add(this.gapWidthSpinnerLabel);
        this.gapWidthSpinner = this.initGapWidthSpinner();
        toolBar.add(this.gapWidthSpinner);
        this.gapWidthSpinnerBox = Box.createRigidArea(new Dimension(5, 10));
        toolBar.add(this.gapWidthSpinnerBox);
        this.gapHeightSpinnerLabel = new JLabel();
        this.gapHeightSpinnerLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/layoutsupport/griddesigner/resources/gap_height.png", (boolean)false));
        toolBar.add(this.gapHeightSpinnerLabel);
        this.gapHeightSpinner = this.initGapHeightSpinner();
        toolBar.add(this.gapHeightSpinner);
        this.gapHeightSpinnerBox = Box.createRigidArea(new Dimension(15, 10));
        toolBar.add(this.gapHeightSpinnerBox);
        JToggleButton padButton = this.initPaddingButton();
        toolBar.add(padButton);
        toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        this.initPreviewButton(toolBar, metaContainer);
        toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        toolBar.add(Box.createGlue());
        rightPanel.add((Component)toolBar, "First");
        Dimension headerDim = new JLabel("99").getPreferredSize();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setViewportView(this.innerPane);
        scrollPane.setPreferredSize(new Dimension(500, 500));
        int unitIncrement = headerDim.height;
        scrollPane.getVerticalScrollBar().setUnitIncrement(unitIncrement);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(unitIncrement);
        rightPanel.add(scrollPane);
        splitPane.setRightComponent(rightPanel);
        this.add(splitPane);
        this.replicator = new VisualReplicator(true, FormUtils.getViewConverters(), FormEditor.getBindingSupport(this.formModel));
        this.replicator.setTopMetaComponent(metaContainer);
        final Object[] bean = new Object[1];
        FormLAF.executeWithLookAndFeel(this.formModel, new Runnable(){

            @Override
            public void run() {
                bean[0] = (Container)GridDesigner.this.replicator.createClone();
            }
        });
        Container container = metaContainer.getContainerDelegate(bean[0]);
        if (container.isPreferredSizeSet()) {
            container.setPreferredSize(null);
        }
        this.innerPane.removeAll();
        JPanel mainPanel = new JPanel();
        Color defaultBackground = UIManager.getColor("Tree.background");
        if (null == defaultBackground) {
            defaultBackground = Color.white;
        }
        mainPanel.setBackground(defaultBackground);
        GroupLayout layout = new GroupLayout(mainPanel);
        layout.setHonorsVisibility(false);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup().addGap(30 + headerDim.width).addComponent(container, -2, -2, -2).addContainerGap(-1, Short.MAX_VALUE);
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup().addGap(20 + headerDim.height).addComponent(container, -2, -2, -2).addContainerGap(-1, Short.MAX_VALUE);
        layout.setVerticalGroup(vGroup);
        mainPanel.setLayout(layout);
        this.glassPane.setPanes(this.innerPane, container);
        this.configureGridManager();
        splitPane.setLeftComponent(this.initLeftColumn());
        this.innerPane.add(this.glassPane);
        FakePeerContainer fakePeerContainer = new FakePeerContainer();
        fakePeerContainer.setLayout(new BorderLayout());
        fakePeerContainer.setBackground(mainPanel.getBackground());
        fakePeerContainer.setFont(FakePeerSupport.getDefaultAWTFont());
        fakePeerContainer.add(mainPanel);
        this.innerPane.add(fakePeerContainer);
        boolean gapSupport = this.gridManager.getGridInfo().hasGaps();
        this.updateGapProperties(gapSupport);
        this.updateGapControls(gapSupport);
        this.addFormModelListener();
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.layouts.griddesigner");
    }

    private void setupUndoRedoShortcut(boolean undo, Action ourAction) {
        KeyStroke ks = null;
        FileObject undoRedoFO = FileUtil.getConfigFile((String)(undo ? "Menu/Edit/org-openide-actions-UndoAction.shadow" : "Menu/Edit/org-openide-actions-RedoAction.shadow"));
        if (undoRedoFO != null) {
            Class undoClass = undo ? UndoAction.class : RedoAction.class;
            ContextAwareAction undoRedoAction = (ContextAwareAction)SystemAction.get(undoClass);
            Action a = undoRedoAction.createContextAwareInstance(Lookup.EMPTY);
            AcceleratorBinding.setAccelerator((Action)a, (FileObject)undoRedoFO);
            Object ksObj = a.getValue("AcceleratorKey");
            if (ksObj instanceof KeyStroke) {
                ks = (KeyStroke)ksObj;
            }
        }
        if (ks == null) {
            ks = Utilities.stringToKey((String)(undo ? "D-Z" : "D-Y"));
        }
        String actionId = ourAction.getClass().getName();
        this.getInputMap(1).put(ks, actionId);
        this.getActionMap().put(actionId, ourAction);
    }

    public void cleanup() {
        this.setSelectedNodes(Collections.EMPTY_LIST);
        this.removeFormModelListener();
    }

    private void updateGapControls(boolean gapSupport) {
        this.gapButton.setSelected(gapSupport);
        this.gapWidthSpinner.setEnabled(gapSupport);
        this.gapHeightSpinner.setEnabled(gapSupport);
        this.gapWidthSpinnerLabel.setEnabled(gapSupport);
        this.gapHeightSpinnerLabel.setEnabled(gapSupport);
        this.gapWidthSpinnerBox.setEnabled(gapSupport);
        this.gapHeightSpinnerBox.setEnabled(gapSupport);
        if (gapSupport) {
            this.gapButton.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.gapSupportDisable"));
        } else {
            this.gapButton.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.gapSupportEnable"));
        }
    }

    private void configureGridManager() {
        this.gridManager = new GridBagManager(this.replicator);
        this.glassPane.setGridManager(this.gridManager);
        this.customizer = this.gridManager.getCustomizer(this.glassPane);
    }

    private void updateGapProperties(boolean gapSupport) {
        if (gapSupport) {
            int gapWidth = this.gridManager.getGridInfo().getGapWidth();
            int gapHeight = this.gridManager.getGridInfo().getGapHeight();
            if (gapWidth < 0) {
                gapWidth = FormLoaderSettings.getInstance().getGapWidth();
            }
            if (gapHeight < 0) {
                gapHeight = FormLoaderSettings.getInstance().getGapHeight();
            }
            if (gapWidth < 0) {
                gapWidth = (Integer)this.gapWidthSpinner.getValue();
            }
            if (gapHeight < 0) {
                gapHeight = (Integer)this.gapHeightSpinner.getValue();
            }
            FormLoaderSettings.getInstance().setGapWidth(gapWidth);
            FormLoaderSettings.getInstance().setGapHeight(gapHeight);
            this.gridManager.updateGaps(true);
            this.gapWidthSpinner.setValue(gapWidth);
            this.gapHeightSpinner.setValue(gapHeight);
        } else {
            if (FormLoaderSettings.getInstance().getGapWidth() < 0) {
                FormLoaderSettings.getInstance().setGapWidth(5);
            }
            if (FormLoaderSettings.getInstance().getGapHeight() < 0) {
                FormLoaderSettings.getInstance().setGapHeight(5);
            }
        }
    }

    private JComponent initLeftColumn() {
        Object leftPanel;
        this.sheet = new PropertySheet();
        this.sheet.setPreferredSize(new Dimension(310, 300));
        if (this.customizer == null) {
            leftPanel = this.sheet;
        } else {
            leftPanel = new JPanel();
            ((Container)leftPanel).setLayout(new BorderLayout());
            ((Container)leftPanel).add((Component)this.sheet);
            ((Container)leftPanel).add(this.customizer.getComponent(), "First");
        }
        return leftPanel;
    }

    private JToggleButton initGapButton() {
        JToggleButton button = new JToggleButton();
        ImageIcon image = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/layoutsupport/griddesigner/resources/gaps.png", (boolean)false);
        button.setIcon(image);
        button.setFocusPainted(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean gapSupport = ((JToggleButton)e.getSource()).isSelected();
                GridDesigner.this.gapWidthSpinner.setEnabled(gapSupport);
                GridDesigner.this.gapHeightSpinner.setEnabled(gapSupport);
                GridDesigner.this.gapWidthSpinnerLabel.setEnabled(gapSupport);
                GridDesigner.this.gapHeightSpinnerLabel.setEnabled(gapSupport);
                GridDesigner.this.gapWidthSpinnerBox.setEnabled(gapSupport);
                GridDesigner.this.gapHeightSpinnerBox.setEnabled(gapSupport);
                if (gapSupport) {
                    assert (!GridDesigner.this.gridManager.getGridInfo().hasGaps());
                    ((JToggleButton)e.getSource()).setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.gapSupportDisable"));
                    int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
                    int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
                    GridDesigner.this.gapWidthSpinner.setValue(gapWidth);
                    GridDesigner.this.gapHeightSpinner.setValue(gapHeight);
                    GridDesigner.this.glassPane.performAction(new AddGapsAction());
                } else {
                    assert (GridDesigner.this.gridManager.getGridInfo().hasGaps());
                    ((JToggleButton)e.getSource()).setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.gapSupportEnable"));
                    GridDesigner.this.glassPane.performAction(new RemoveGapsAction());
                }
            }
        });
        return button;
    }

    private JSpinner initGapWidthSpinner() {
        SpinnerNumberModel gapWidthModel = new SpinnerNumberModel(5, 0, 100, 1);
        JSpinner spinner = new JSpinner(gapWidthModel);
        spinner.setEditor(new JSpinner.NumberEditor(spinner));
        spinner.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.gapColumnSpinner"));
        Dimension labelPrefSize = new JLabel("999").getPreferredSize();
        Dimension spinnerMinSize = spinner.getMinimumSize();
        spinner.setMaximumSize(new Dimension(labelPrefSize.width + spinnerMinSize.width, Short.MAX_VALUE));
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                int gapWidth = (Integer)spinner.getValue();
                FormLoaderSettings.getInstance().setGapWidth(gapWidth);
                GridDesigner.this.glassPane.updateLayout();
            }
        });
        return spinner;
    }

    private JSpinner initGapHeightSpinner() {
        SpinnerNumberModel gapHeightModel = new SpinnerNumberModel(5, 0, 100, 1);
        JSpinner spinner = new JSpinner(gapHeightModel);
        spinner.setEditor(new JSpinner.NumberEditor(spinner));
        spinner.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.gapRowSpinner"));
        Dimension labelPrefSize = new JLabel("999").getPreferredSize();
        Dimension spinnerMinSize = spinner.getMinimumSize();
        spinner.setMaximumSize(new Dimension(labelPrefSize.width + spinnerMinSize.width, Short.MAX_VALUE));
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                int gapHeight = (Integer)spinner.getValue();
                FormLoaderSettings.getInstance().setGapHeight(gapHeight);
                GridDesigner.this.glassPane.updateLayout();
            }
        });
        return spinner;
    }

    private JToggleButton initPaddingButton() {
        JToggleButton button = new JToggleButton();
        ImageIcon image = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/layoutsupport/griddesigner/resources/pad_empty.png", (boolean)false);
        button.setIcon(image);
        button.setFocusPainted(false);
        boolean padEmptyCells = FormLoaderSettings.getInstance().getPadEmptyCells();
        button.setSelected(padEmptyCells);
        if (padEmptyCells) {
            button.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.padEmptyCellsHide"));
        } else {
            button.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.padEmptyCellsShow"));
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean padEmptyCells = ((JToggleButton)e.getSource()).isSelected();
                FormLoaderSettings.getInstance().setPadEmptyCells(padEmptyCells);
                if (padEmptyCells) {
                    ((JToggleButton)e.getSource()).setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.padEmptyCellsHide"));
                } else {
                    ((JToggleButton)e.getSource()).setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.padEmptyCellsShow"));
                }
                GridDesigner.this.glassPane.updateLayout();
            }
        });
        return button;
    }

    private void initPreviewButton(JToolBar toolBar, RADVisualComponent metaComp) {
        TestAction testAction = (TestAction)SystemAction.get(TestAction.class);
        JButton button = toolBar.add((Action)((Object)testAction));
        button.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.previewLayout"));
        button.setFocusPainted(false);
    }

    private JButton initUndoRedoButton(JButton button) {
        String text = (String)button.getAction().getValue("Name");
        Mnemonics.setLocalizedText((AbstractButton)button, (String)text);
        text = button.getText();
        button.setText(null);
        button.setToolTipText(text);
        button.setFocusPainted(false);
        return button;
    }

    public void setSelection(Set<Component> selection) {
        this.metaSelection.clear();
        RADVisualContainer metacont = (RADVisualContainer)this.replicator.getTopMetaComponent();
        for (RADVisualComponent metacomp : metacont.getSubComponents()) {
            Component comp = (Component)this.replicator.getClonedComponent(metacomp);
            if (!selection.contains(comp)) continue;
            this.metaSelection.add(metacomp);
        }
        this.updatePropertySheet();
        this.updateCustomizer();
    }

    private PropertyChangeListener getSelectedNodeListener() {
        if (this.selectedNodeListener == null) {
            this.selectedNodeListener = this.createSelectedNodeListener();
        }
        return this.selectedNodeListener;
    }

    private PropertyChangeListener createSelectedNodeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (GridDesigner.this.isShowing() && !GridDesigner.this.glassPane.isUserActionInProgress() && !GridDesigner.this.updateScheduled) {
                    GridDesigner.this.updateScheduled = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GridDesigner.this.updateScheduled = false;
                            GridDesigner.this.glassPane.updateLayout();
                            GridDesigner.this.updateCustomizer();
                        }
                    });
                }
            }
        };
    }

    private void updatePropertySheet() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.metaSelection.size());
        for (RADVisualComponent metacomp : this.metaSelection) {
            RADComponentNode node = metacomp.getNodeReference();
            if (node == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<Node> nodes = new ArrayList<Node>(GridDesigner.this.metaSelection.size());
                        for (RADVisualComponent metacomp : GridDesigner.this.metaSelection) {
                            nodes.add((Node)new LayoutConstraintsNode((Node)metacomp.getNodeReference()));
                        }
                        GridDesigner.this.setSelectedNodes(nodes);
                        GridDesigner.this.sheet.setNodes(nodes.toArray(new Node[nodes.size()]));
                    }
                });
                return;
            }
            nodes.add((Node)new LayoutConstraintsNode((Node)node));
        }
        this.setSelectedNodes(nodes);
        this.sheet.setNodes(nodes.toArray(new Node[nodes.size()]));
    }

    void setSelectedNodes(List<Node> nodes) {
        for (Node node : this.selectedNodes) {
            node.removePropertyChangeListener(this.getSelectedNodeListener());
        }
        this.selectedNodes = nodes;
        for (Node node : this.selectedNodes) {
            node.addPropertyChangeListener(this.getSelectedNodeListener());
        }
    }

    void updateCustomizer() {
        if (this.customizer != null) {
            DesignerContext context = this.glassPane.currentContext();
            this.customizer.setContext(context);
        }
    }

    void updateContextMenu(DesignerContext context, JPopupMenu menu) {
        RADVisualContainer parent;
        RADVisualContainer root;
        if (context.getFocusedColumn() == -1 == (context.getFocusedRow() == -1) && this.haveIdenticalLayoutDelegate(root = (RADVisualContainer)this.replicator.getTopMetaComponent(), parent = root.getParentContainer())) {
            menu.add(new DesignContainerAction(this, parent, true));
        }
        if (this.metaSelection.size() == 1) {
            RADVisualContainer cont;
            root = (RADVisualContainer)this.replicator.getTopMetaComponent();
            RADVisualComponent comp = this.metaSelection.iterator().next();
            if (comp instanceof RADVisualContainer && this.haveIdenticalLayoutDelegate(root, cont = (RADVisualContainer)comp)) {
                menu.add(new DesignContainerAction(this, cont, false));
            }
        }
    }

    private FormModelListener getFormModelListener() {
        if (this.formModelListener == null) {
            this.formModelListener = this.createFormModelListener();
        }
        return this.formModelListener;
    }

    private FormModelListener createFormModelListener() {
        return new FormModelListener(){

            @Override
            public void formChanged(FormModelEvent[] events) {
                for (FormModelEvent event : events) {
                    if (!GridDesigner.this.gridManager.getGridInfo().isGapEvent(event)) continue;
                    boolean gapSupport = GridDesigner.this.gridManager.getGridInfo().hasGaps();
                    GridDesigner.this.updateGapControls(gapSupport);
                }
            }
        };
    }

    void addFormModelListener() {
        this.formModel.addFormModelListener(this.getFormModelListener());
    }

    void removeFormModelListener() {
        this.formModel.removeFormModelListener(this.getFormModelListener());
    }

    private boolean haveIdenticalLayoutDelegate(RADVisualContainer cont1, RADVisualContainer cont2) {
        if (cont1 == null || cont2 == null) {
            return false;
        }
        LayoutSupportManager support1 = cont1.getLayoutSupport();
        if (support1 == null) {
            return false;
        }
        String delegate1 = support1.getLayoutDelegate().getClass().getName();
        LayoutSupportManager support2 = cont2.getLayoutSupport();
        if (support2 == null) {
            return false;
        }
        String delegate2 = support2.getLayoutDelegate().getClass().getName();
        return delegate1.equals(delegate2);
    }

    static class LayoutConstraintsNode
    extends FilterNode {
        LayoutConstraintsNode(Node original) {
            super(original);
        }

        public Node.PropertySet[] getPropertySets() {
            for (Node.PropertySet pSet : super.getPropertySets()) {
                String name = pSet.getName();
                if (!"layout".equals(name)) continue;
                final Node.PropertySet set = pSet;
                String displayName = NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.layoutConstraints");
                return new Node.PropertySet[]{new Node.PropertySet(set.getName(), displayName, set.getShortDescription()){

                    public Node.Property<?>[] getProperties() {
                        return set.getProperties();
                    }
                }};
            }
            return new Node.PropertySet[0];
        }
    }
}

