/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.updater;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.context.IndexingContext;

public class IndexDataWriter {
    static final int VERSION = 1;
    static final int F_INDEXED = 1;
    static final int F_TOKENIZED = 2;
    static final int F_STORED = 4;
    static final int F_COMPRESSED = 8;
    private final DataOutputStream dos;
    private final GZIPOutputStream gos;
    private final BufferedOutputStream bos;
    private final Set<String> allGroups;
    private final Set<String> rootGroups;
    private boolean descriptorWritten;

    public IndexDataWriter(OutputStream os) throws IOException {
        this.bos = new BufferedOutputStream(os, 8192);
        this.gos = new GZIPOutputStream((OutputStream)this.bos, 2048);
        this.dos = new DataOutputStream(this.gos);
        this.allGroups = new HashSet<String>();
        this.rootGroups = new HashSet<String>();
        this.descriptorWritten = false;
    }

    public int write(IndexingContext context, IndexReader indexReader, List<Integer> docIndexes) throws IOException {
        this.writeHeader(context);
        int n = this.writeDocuments(indexReader, docIndexes);
        this.writeGroupFields();
        this.close();
        return n;
    }

    public void close() throws IOException {
        this.dos.flush();
        this.gos.flush();
        this.gos.finish();
        this.bos.flush();
    }

    public void writeHeader(IndexingContext context) throws IOException {
        this.dos.writeByte(1);
        Date timestamp = context.getTimestamp();
        this.dos.writeLong(timestamp == null ? -1L : timestamp.getTime());
    }

    public void writeGroupFields() throws IOException {
        ArrayList<IndexableField> allGroupsFields = new ArrayList<IndexableField>(2);
        allGroupsFields.add((IndexableField)new StringField("allGroups", "allGroups", Field.Store.YES));
        allGroupsFields.add((IndexableField)new StringField("allGroupsList", ArtifactInfo.lst2str(this.allGroups), Field.Store.YES));
        this.writeDocumentFields(allGroupsFields);
        ArrayList<IndexableField> rootGroupsFields = new ArrayList<IndexableField>(2);
        rootGroupsFields.add((IndexableField)new StringField("rootGroups", "rootGroups", Field.Store.YES));
        rootGroupsFields.add((IndexableField)new StringField("rootGroupsList", ArtifactInfo.lst2str(this.rootGroups), Field.Store.YES));
        this.writeDocumentFields(rootGroupsFields);
    }

    public int writeDocuments(IndexReader r, List<Integer> docIndexes) throws IOException {
        int n = 0;
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)r);
        if (docIndexes == null) {
            for (int i = 0; i < r.maxDoc(); ++i) {
                if (liveDocs != null && !liveDocs.get(i) || !this.writeDocument(r.document(i))) continue;
                ++n;
            }
        } else {
            for (int i : docIndexes) {
                if (liveDocs != null && !liveDocs.get(i) || !this.writeDocument(r.document(i))) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean writeDocument(Document document) throws IOException {
        List fields = document.getFields();
        ArrayList<IndexableField> storedFields = new ArrayList<IndexableField>(fields.size());
        for (IndexableField field : fields) {
            if ("DESCRIPTOR".equals(field.name())) {
                if (this.descriptorWritten) {
                    return false;
                }
                this.descriptorWritten = true;
            }
            if ("allGroups".equals(field.name())) {
                String groupList = document.get("allGroupsList");
                if (groupList != null && groupList.trim().length() > 0) {
                    this.allGroups.addAll(ArtifactInfo.str2lst(groupList));
                }
                return false;
            }
            if ("rootGroups".equals(field.name())) {
                String groupList = document.get("rootGroupsList");
                if (groupList != null && groupList.trim().length() > 0) {
                    this.rootGroups.addAll(ArtifactInfo.str2lst(groupList));
                }
                return false;
            }
            if (!field.fieldType().stored()) continue;
            storedFields.add(field);
        }
        this.writeDocumentFields(storedFields);
        return true;
    }

    public void writeDocumentFields(List<IndexableField> fields) throws IOException {
        this.dos.writeInt(fields.size());
        for (IndexableField field : fields) {
            this.writeField(field);
        }
    }

    public void writeField(IndexableField field) throws IOException {
        int flags = (field.fieldType().indexOptions() != IndexOptions.NONE ? 1 : 0) + (field.fieldType().tokenized() ? 2 : 0) + (field.fieldType().stored() ? 4 : 0);
        String name = field.name();
        String value = field.stringValue();
        this.dos.write(flags);
        this.dos.writeUTF(name);
        IndexDataWriter.writeUTF(value, this.dos);
    }

    private static void writeUTF(String str, DataOutput out) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        out.writeInt(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen);
    }
}

