/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.gsf.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;

public final class TestMethodFinderImpl
extends EmbeddingIndexer {
    public static final String NAME = "tests";
    public static final int VERSION = 1;
    public static final TestMethodFinderImpl INSTANCE = new TestMethodFinderImpl();
    private final WeakSet<BiConsumer<FileObject, Collection<TestMethodController.TestMethod>>> listeners = new WeakSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        ArrayList<TestMethodController.TestMethod> testMethods = new ArrayList<TestMethodController.TestMethod>();
        for (ComputeTestMethods ctm : MimeLookup.getLookup((String)indexable.getMimeType()).lookupAll(ComputeTestMethods.class)) {
            testMethods.addAll(ctm.computeTestMethods(parserResult, new AtomicBoolean()));
        }
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        this.store(context.getIndexFolder(), indexable.getURL(), indexable.getRelativePath(), testMethods);
        if (!context.isAllFilesIndexing()) {
            WeakSet<BiConsumer<FileObject, Collection<TestMethodController.TestMethod>>> weakSet = this.listeners;
            synchronized (weakSet) {
                for (BiConsumer listener : this.listeners) {
                    listener.accept(fo, testMethods);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BiConsumer<FileObject, Collection<TestMethodController.TestMethod>> listener) {
        WeakSet<BiConsumer<FileObject, Collection<TestMethodController.TestMethod>>> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.putIfAbsent(listener);
            Logger.getLogger(TestMethodFinderImpl.class.getName()).info("Listener added: " + listener);
        }
    }

    private void store(FileObject indexFolder, URL url, String resourceName, List<TestMethodController.TestMethod> methods) {
        File cacheRoot = FileUtil.toFile((FileObject)indexFolder);
        File output = new File(cacheRoot, resourceName + ".tests");
        if (methods.isEmpty()) {
            if (output.exists()) {
                output.delete();
            }
        } else {
            LinkedHashMap<String, List> class2methods = new LinkedHashMap<String, List>();
            HashMap<String, Integer> class2offsets = new HashMap<String, Integer>();
            for (TestMethodController.TestMethod method : methods) {
                String className = method.getTestClassName();
                if (method.getTestClassPosition() != null) {
                    class2offsets.putIfAbsent(className, method.getTestClassPosition().getOffset());
                }
                class2methods.computeIfAbsent(className, name -> new ArrayList()).add(method);
            }
            output.getParentFile().mkdirs();
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));){
                pw.print("url: ");
                pw.println(url.toString());
                for (Map.Entry entry : class2methods.entrySet()) {
                    pw.print("class: ");
                    pw.print((String)entry.getKey());
                    Integer offset = (Integer)class2offsets.get(entry.getKey());
                    if (offset != null) {
                        pw.print(':');
                        pw.println(offset);
                    } else {
                        pw.println();
                    }
                    for (TestMethodController.TestMethod method : (List)entry.getValue()) {
                        pw.print("method: ");
                        pw.print(method.method().getMethodName());
                        pw.print(':');
                        pw.print(method.start().getOffset());
                        pw.print('-');
                        pw.println(method.end().getOffset());
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            return INSTANCE;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            File cacheRoot = FileUtil.toFile((FileObject)context.getIndexFolder());
            for (Indexable indexable : deleted) {
                File output = new File(cacheRoot, indexable.getRelativePath() + ".tests");
                if (!output.exists()) continue;
                output.delete();
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return TestMethodFinderImpl.NAME;
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

