/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class NotInitializedVariable
implements ErrorRule<Void> {
    private static final String DIAGNOSTIC_KEY = "compiler.err.var.might.not.have.been.initialized";
    private volatile boolean canceled;

    public Set<String> getCodes() {
        return Collections.singleton(DIAGNOSTIC_KEY);
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        assert (DIAGNOSTIC_KEY.equals(diagnosticKey));
        ArrayList<Fix> result = new ArrayList<Fix>();
        if (!this.canceled) {
            Trees t = compilationInfo.getTrees();
            Element e = t.getElement(treePath);
            if (!this.canceled && e != null && e.getKind() == ElementKind.LOCAL_VARIABLE) {
                TreePath declaration = t.getPath(e);
                if (!this.canceled && declaration != null) {
                    result.add(new NIVFix(e.getSimpleName().toString(), TreePathHandle.create((TreePath)declaration, (CompilationInfo)compilationInfo)).toEditorFix());
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public String getId() {
        return "NotInitializedVariable";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable");
    }

    public void cancel() {
        this.canceled = true;
    }

    private static class NIVFix
    extends JavaFix {
        private final String variableName;

        public NIVFix(String variableName, TreePathHandle variable) {
            super(variable);
            assert (variableName != null);
            assert (variable != null);
            this.variableName = variableName;
        }

        public String getText() {
            return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable_fix", (Object)this.variableName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            VariableTree vt = (VariableTree)tp.getLeaf();
            ExpressionTree init = vt.getInitializer();
            if (init != null) {
                return;
            }
            Element decl = wc.getTrees().getElement(tp);
            if (decl == null) {
                return;
            }
            TypeMirror type = decl.asType();
            TypeKind kind = type.getKind();
            Comparable<Boolean> value = kind.isPrimitive() ? (kind == TypeKind.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)) : null;
            LiteralTree newInit = wc.getTreeMaker().Literal((Object)value);
            VariableTree newVt = wc.getTreeMaker().Variable(vt.getModifiers(), (CharSequence)vt.getName(), vt.getType(), (ExpressionTree)newInit);
            wc.rewrite((Tree)vt, (Tree)newVt);
        }
    }
}

