/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.openide.util.EditableProperties;

public class ProjectUpgrader {
    private final ClientSideProject project;
    private static final String LEGACY_GRUNT_ACTION_PREFIX = "grunt.action.";
    private static final String GRUNT_ACTION_PREFIX = "auxiliary.org-netbeans-modules-javascript-grunt.action_2e_";

    public ProjectUpgrader(ClientSideProject project) {
        assert (project != null);
        this.project = project;
    }

    public void upgrade() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                ProjectUpgrader.this.upgradeProjectProperties();
            }
        });
    }

    void upgradeProjectProperties() {
        EditableProperties properties = this.project.getProjectHelper().getProperties(CommonProjectHelper.PROJECT_PROPERTIES_PATH);
        this.upgradeGrunt(properties);
        this.project.getProjectHelper().putProperties(CommonProjectHelper.PROJECT_PROPERTIES_PATH, properties);
    }

    private void upgradeGrunt(EditableProperties properties) {
        HashSet<String> toRemove = null;
        HashMap<String, String> toAdd = null;
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(LEGACY_GRUNT_ACTION_PREFIX)) continue;
            if (toRemove == null) {
                toRemove = new HashSet<String>();
            }
            toRemove.add(key);
            if (toAdd == null) {
                toAdd = new HashMap<String, String>();
            }
            String newKey = GRUNT_ACTION_PREFIX + key.replace(LEGACY_GRUNT_ACTION_PREFIX, "");
            toAdd.put(newKey, (String)entry.getValue());
        }
        if (toRemove != null) {
            for (String key : toRemove) {
                properties.remove((Object)key);
            }
        }
        if (toAdd != null) {
            properties.putAll(toAdd);
        }
    }
}

