/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.util;

import io.foojay.api.discoclient.pkg.TermOfSupport;
import io.foojay.api.discoclient.util.Constants;
import java.io.IOException;
import java.net.URI;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequests;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.io.CloseMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Helper.class);
    public static final Pattern NUMBER_IN_TEXT_PATTERN = Pattern.compile("(.*)?([0-9]+)(.*)?");

    public static boolean isPositiveInteger(String text) {
        if (null == text) {
            return false;
        }
        return Constants.POSITIVE_INTEGER_PATTERN.matcher(text).matches();
    }

    public static String trimPrefix(String text, String prefix) {
        return text.replaceFirst(prefix, "");
    }

    public static boolean isSTS(int featureVersion) {
        if (featureVersion < 9) {
            return false;
        }
        switch (featureVersion) {
            case 9: 
            case 10: {
                return true;
            }
        }
        return !Helper.isLTS(featureVersion);
    }

    public static boolean isMTS(int featureVersion) {
        if (featureVersion < 13) {
            return false;
        }
        return !Helper.isLTS(featureVersion) && featureVersion % 2 != 0;
    }

    public static boolean isLTS(int featureVersion) {
        if (featureVersion < 1) {
            throw new IllegalArgumentException("Feature version number cannot be smaller than 1");
        }
        if (featureVersion <= 8) {
            return true;
        }
        if (featureVersion < 11) {
            return false;
        }
        return ((double)featureVersion - 11.0) / 6.0 % 1.0 == 0.0;
    }

    public static TermOfSupport getTermOfSupport(int featureVersion) {
        if (featureVersion < 1) {
            throw new IllegalArgumentException("Feature version number cannot be smaller than 1");
        }
        if (Helper.isLTS(featureVersion)) {
            return TermOfSupport.LTS;
        }
        if (Helper.isMTS(featureVersion)) {
            return TermOfSupport.MTS;
        }
        if (Helper.isSTS(featureVersion)) {
            return TermOfSupport.STS;
        }
        return TermOfSupport.NOT_FOUND;
    }

    public static Stream<MatchResult> findAll(final Scanner s, final Pattern pattern) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<MatchResult>(1000L, 272){

            @Override
            public boolean tryAdvance(Consumer<? super MatchResult> action) {
                if (s.findWithinHorizon(pattern, 0) != null) {
                    action.accept(s.match());
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static final String get(String uri) {
        String result;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(URI.create(uri));
            httpGet.addHeader("User-Agent", (Object)"DiscoClient");
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);){
                if (response.getCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    result = null == entity ? "" : EntityUtils.toString((HttpEntity)entity);
                    EntityUtils.consume((HttpEntity)entity);
                } else {
                    result = "";
                    LOGGER.debug("Error executing get request {}, response code {}", (Object)uri, (Object)response.getCode());
                }
            }
        }
        catch (IOException | ParseException e) {
            LOGGER.debug("Error executing get request {}", (Object)uri);
            result = "";
        }
        return result;
    }

    public static final CompletableFuture<String> getAsync(final String uri) {
        CloseableHttpAsyncClient client = HttpAsyncClients.createHttp2Default();
        client.start();
        final CompletableFuture<String> toComplete = new CompletableFuture<String>();
        SimpleHttpRequest request = SimpleHttpRequests.get((URI)URI.create(uri));
        Future future = client.execute(request, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                toComplete.complete(response.getBodyText());
            }

            public void failed(Exception e) {
                LOGGER.debug("Error executing get request {}, {}", (Object)uri, (Object)e.getMessage());
                toComplete.completeExceptionally(e);
            }

            public void cancelled() {
                LOGGER.debug("Request to {} was cancelled", (Object)uri);
                toComplete.cancel(true);
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.debug("Error executing get request {}, {}", (Object)uri, (Object)e.getMessage());
        }
        client.close(CloseMode.GRACEFUL);
        return toComplete;
    }
}

