/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.InitParamTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class InitParamsPanel
extends DefaultTablePanel {
    private InitParamTableModel model;
    private Servlet servlet;
    private DDDataObject dObj;

    public InitParamsPanel(final DDDataObject dObj, final InitParamTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.dObj = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = InitParamsPanel.this.getTable().getSelectedRow();
                dObj.modelUpdatedFromUI();
                dObj.setChangedFromUI(true);
                model.removeRow(row);
                dObj.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(Servlet servlet, InitParam[] params) {
        this.model.setData((CommonDDBean)servlet, (CommonDDBean[])params);
        this.servlet = servlet;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int row = this.add ? -1 : InitParamsPanel.this.getTable().getSelectedRow();
            String[] labels = new String[]{NbBundle.getMessage(InitParamsPanel.class, (String)"LBL_initParamName"), NbBundle.getMessage(InitParamsPanel.class, (String)"LBL_initParamValue"), NbBundle.getMessage(InitParamsPanel.class, (String)"LBL_description")};
            String[] a11y_desc = new String[]{NbBundle.getMessage(InitParamsPanel.class, (String)"ACSD_init_param_name"), NbBundle.getMessage(InitParamsPanel.class, (String)"ACSD_init_param_value"), NbBundle.getMessage(InitParamsPanel.class, (String)"ACSD_init_param_desc")};
            SimpleDialogPanel.DialogDescriptor descriptor = new SimpleDialogPanel.DialogDescriptor(labels, true);
            if (!this.add) {
                String[] initValues = new String[]{(String)InitParamsPanel.this.model.getValueAt(row, 0), (String)InitParamsPanel.this.model.getValueAt(row, 1), (String)InitParamsPanel.this.model.getValueAt(row, 2)};
                descriptor.setInitValues(initValues);
            }
            descriptor.setTextField(new boolean[]{true, true, false});
            descriptor.setA11yDesc(a11y_desc);
            final SimpleDialogPanel dialogPanel = new SimpleDialogPanel(descriptor);
            if (this.add) {
                dialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InitParamsPanel.class, (String)"ACSD_add_initParam"));
                dialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamsPanel.class, (String)"ACSD_add_initParam"));
            } else {
                dialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamsPanel.class, (String)"ACSD_edit_initParam"));
                dialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InitParamsPanel.class, (String)"ACSD_edit_initParam"));
            }
            EditDialog dialog = new EditDialog((JPanel)dialogPanel, NbBundle.getMessage(InitParamsPanel.class, (String)"TTL_InitParam"), this.add){

                protected String validate() {
                    String[] values = dialogPanel.getValues();
                    String name = values[0];
                    String value = values[1];
                    if (name.length() == 0) {
                        return NbBundle.getMessage(InitParamsPanel.class, (String)"TXT_EmptyInitParamName");
                    }
                    InitParam[] params = InitParamsPanel.this.servlet.getInitParam();
                    boolean exists = false;
                    for (int i = 0; i < params.length; ++i) {
                        if (row == i || !name.equals(params[i].getParamName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        return NbBundle.getMessage(InitParamsPanel.class, (String)"TXT_InitParamNameExists", (Object)name);
                    }
                    if (value.length() == 0) {
                        return NbBundle.getMessage(InitParamsPanel.class, (String)"TXT_EmptyInitParamValue");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getTextComponents()[0].getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getTextComponents()[0].getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                InitParamsPanel.this.dObj.modelUpdatedFromUI();
                InitParamsPanel.this.dObj.setChangedFromUI(true);
                String[] values = dialogPanel.getValues();
                String name = values[0];
                String value = values[1];
                String description = values[2];
                if (this.add) {
                    InitParamsPanel.this.model.addRow(new String[]{name, value, description});
                } else {
                    InitParamsPanel.this.model.editRow(row, new String[]{name, value, description});
                }
                InitParamsPanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

