/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.jshell.model.JShellToken;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenPropertyProvider;

public class JShellLexer
implements Lexer<JShellToken>,
TokenPropertyProvider<JShellToken> {
    private final TokenFactory<JShellToken> tokenFactory;
    private final LexerInput input;
    private S state = S.INITIAL;
    private static final String[] COMMANDS = new String[]{"list", "drop", "save", "open", "vars", "methods", "types", "imports", "exit", "reset", "reload", "classpath", "history", "debug", "help", "set", "?", "!"};
    private static final String[] COMMAND_STRINGS = new String[]{"l", "list", "dr", "drop", "sa", "save", "o", "open", "v", "vars", "m", "methods", "cl", "types", "im", "imports", "ex", "exit", "res", "reset", "rel", "reload", "c", "classpath", "hi", "history", "de", "debug", "he", "?", "help", "se", "set", "!", ""};
    private S prevState = S.INITIAL;
    private static final Map<String, String> commandUniquePrefixes = new HashMap<String, String>();

    private static void initCommandPrefixes() {
        HashSet<String> seenPrefixes = new HashSet<String>();
        for (String s : COMMANDS) {
            for (int i = 1; i <= s.length(); ++i) {
                String x = s.substring(0, i);
                if (seenPrefixes.contains(x)) {
                    commandUniquePrefixes.remove(x);
                    continue;
                }
                commandUniquePrefixes.put(x, s);
                seenPrefixes.add(x);
            }
        }
    }

    public static List<String> getCommandsFromPrefix(String prefix) {
        ArrayList<String> commands = new ArrayList<String>();
        for (String s : COMMANDS) {
            if (!s.startsWith(prefix)) continue;
            commands.add(s);
        }
        return commands;
    }

    public JShellLexer(LexerRestartInfo<JShellToken> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        Object s = info.state();
        if (s != null) {
            LexState ls = (LexState)s;
            this.state = ls.s;
            this.prevState = ls.prev;
        }
    }

    private void setState(S ns, S ps) {
        this.prevState = ps;
        this.state = ns;
    }

    private void setState(S ns) {
        this.prevState = this.state;
        this.state = ns;
    }

    private Token<JShellToken> possibleSpace(JShellToken t, int spaces, S next, boolean flyweight) {
        this.state = next;
        for (int s = spaces; s > 0; --s) {
            int c = this.input.read();
            if (c == 32 || c == 10) continue;
            this.input.backup(1);
            return this.blockToken(t);
        }
        if (flyweight) {
            return this.tokenFactory.getFlyweightToken((TokenId)t, t.fixedText());
        }
        return this.tokenFactory.createToken((TokenId)t);
    }

    private Token<JShellToken> promptOrDefault(boolean continuation) {
        int c = this.input.read();
        if (c != 62) {
            return this.state == S.JAVA ? this.eoln(JShellToken.JAVA) : this.eoln(JShellToken.OUTPUT);
        }
        return this.possibleSpace(continuation ? JShellToken.CONTINUATION_PROMPT : JShellToken.PROMPT, 1, S.PROMPT_INPUT, false);
    }

    private Token<JShellToken> blockToken(JShellToken id) {
        return this.tokenFactory.createPropertyToken((TokenId)id, this.input.readLength(), (TokenPropertyProvider)this);
    }

    private Token<JShellToken> messageLine() {
        int s = 0;
        int mark = -1;
        block8: while (true) {
            int c = this.input.read();
            switch (c) {
                case 10: {
                    this.setState(S.INITIAL, S.MESSAGE);
                    return this.blockToken(JShellToken.MESSAGE_TEXT);
                }
                case 32: {
                    continue block8;
                }
                case 45: {
                    if (s == 1 || s == 2) {
                        s = 2;
                        continue block8;
                    }
                    s = 10;
                    continue block8;
                }
                case 46: {
                    if (s >= 2 && ++s == 5) {
                        int c2 = this.input.read();
                        if (c2 != 46) {
                            this.input.backup(1);
                            this.setState(S.PROMPT_MESSAGE);
                            return this.tokenFactory.createToken((TokenId)JShellToken.ERROR_MARKER);
                        }
                        this.input.backup(1);
                    }
                    s = 10;
                    continue block8;
                }
                case 94: {
                    if (s == 0) {
                        mark = this.input.readLength();
                        s = 1;
                        if (this.input.readLength() <= 1) continue block8;
                        this.input.backup(1);
                        this.setState(S.PROMPT_MESSAGE);
                        return this.blockToken(JShellToken.MESSAGE_TEXT);
                    }
                    if (s >= 1 && s < 3) {
                        this.setState(S.PROMPT_MESSAGE);
                        return this.tokenFactory.createToken((TokenId)JShellToken.ERROR_MARKER);
                    }
                    s = 10;
                    continue block8;
                }
                case -1: {
                    break block8;
                }
                default: {
                    s = 10;
                    continue block8;
                }
            }
            break;
        }
        this.setState(S.INITIAL, S.MESSAGE);
        return this.blockToken(JShellToken.MESSAGE_TEXT);
    }

    private Token<JShellToken> eoln(JShellToken id) {
        return this.eoln(id, S.INITIAL);
    }

    private Token<JShellToken> eoln(JShellToken id, S nextState) {
        int c;
        while ((c = this.input.read()) != -1 && c != 10) {
        }
        this.setState(nextState);
        return this.input.readLength() > 0 ? this.blockToken(id) : null;
    }

    private boolean eatWhitespace() {
        int c;
        boolean wh = true;
        if (this.input.readLength() > 0) {
            this.input.backup(1);
        }
        while ((c = this.input.read()) != -1 && c != 10 && (wh = Character.isWhitespace(c))) {
        }
        return wh;
    }

    private int startsCommand(String s) {
        int l = s.length();
        if (l == 0) {
            return 20;
        }
        int idx = 0;
        char first = s.charAt(0);
        if (first == '-') {
            if (l == 1) {
                return 2;
            }
            first = s.charAt(1);
            ++idx;
        }
        if (Character.isDigit(first)) {
            try {
                Integer.parseInt(s.substring(idx));
                return 0;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        String full = commandUniquePrefixes.get(s);
        if (full != null) {
            return full.length() - l;
        }
        return -1;
    }

    private Token<JShellToken> commandOrJava() {
        boolean cont;
        int c = this.input.read();
        if (c == -1) {
            return null;
        }
        if (Character.isWhitespace(c) && this.eatWhitespace()) {
            this.setState(S.JAVA);
            return this.blockToken(JShellToken.JAVA);
        }
        if (c != 47) {
            return this.eoln(JShellToken.JAVA, S.JAVA);
        }
        while ((cont = (c = this.input.read()) != -1 && c != 10) && !Character.isWhitespace(c)) {
        }
        String cmd = this.input.readText().toString();
        cmd = cmd.substring(1).trim();
        this.setState(cont ? S.COMMAND : S.INITIAL);
        if ("".equals(cmd)) {
            return this.blockToken(JShellToken.ERR_COMMAND);
        }
        int status = this.startsCommand(cmd);
        if (status == -1) {
            return this.blockToken(JShellToken.ERR_COMMAND);
        }
        if (status > 0) {
            if (c == 10) {
                this.input.backup(1);
            } else if (c != -1) {
                return this.blockToken(JShellToken.ERR_COMMAND);
            }
        } else if (status == 0 && c != -1) {
            if (!Character.isWhitespace(c)) {
                while ((c = this.input.read()) != -1 && !Character.isWhitespace(c)) {
                }
                if (c != -1) {
                    this.input.backup(1);
                }
                return this.tokenFactory.createToken((TokenId)JShellToken.ERR_COMMAND);
            }
            this.input.backup(1);
        }
        this.setState(S.COMMAND);
        return this.blockToken(JShellToken.COMMAND);
    }

    private Token<JShellToken> possibleNumberPrompt() {
        int c = this.input.read();
        while (Character.isDigit(c)) {
            c = this.input.read();
        }
        if (c != 93) {
            return null;
        }
        c = this.input.read();
        if (c == 32) {
            c = this.input.read();
        }
        if (c == 45 || c == 62) {
            return this.promptOrDefault(c == 62);
        }
        return null;
    }

    private Token<JShellToken> createContinuationTokenForState(S s) {
        switch (s) {
            case INITIAL: {
                return this.tokenFactory.createToken((TokenId)JShellToken.WHITESPACE);
            }
            case PROMPT_INPUT: {
                return this.blockToken(JShellToken.JAVA);
            }
            case PROMPT_MESSAGE: {
                return this.blockToken(JShellToken.MESSAGE_TEXT);
            }
            case MESSAGE: {
                return this.blockToken(JShellToken.MESSAGE_TEXT);
            }
            case JAVA: {
                return this.blockToken(JShellToken.JAVA);
            }
            case COMMAND: {
                return this.blockToken(JShellToken.OUTPUT);
            }
        }
        return null;
    }

    public Token<JShellToken> nextToken() {
        Token<JShellToken> token = null;
        switch (this.state) {
            case INITIAL: 
            case JAVA: {
                int c = this.input.read();
                switch (c) {
                    case 91: {
                        token = this.possibleNumberPrompt();
                        if (token == null) break;
                        return token;
                    }
                    case 124: {
                        return this.possibleSpace(JShellToken.MESSAGE_MARK, 2, S.PROMPT_MESSAGE, true);
                    }
                    case 45: {
                        return this.promptOrDefault(false);
                    }
                    case 62: {
                        return this.promptOrDefault(true);
                    }
                    case -1: {
                        return null;
                    }
                    default: {
                        this.input.backup(1);
                    }
                }
                if (this.state == S.JAVA) {
                    return this.eoln(JShellToken.JAVA, S.JAVA);
                }
                if (this.prevState != S.INITIAL && this.eatWhitespace()) {
                    return this.createContinuationTokenForState(this.prevState);
                }
                return this.eoln(JShellToken.OUTPUT, this.state);
            }
            case COMMAND: {
                return this.commandLine();
            }
            case MESSAGE: {
                return this.eoln(JShellToken.MESSAGE_TEXT);
            }
            case PROMPT_MESSAGE: {
                return this.messageLine();
            }
            case PROMPT_INPUT: {
                return this.commandOrJava();
            }
        }
        throw new IllegalStateException(this.state.toString());
    }

    private Token<JShellToken> commandLine() {
        int c = this.input.read();
        if (c == -1) {
            return null;
        }
        if (Character.isWhitespace(c)) {
            boolean endsNonWhite = this.eatWhitespace();
            if (!endsNonWhite) {
                this.input.backup(1);
            } else {
                this.setState(S.INITIAL);
            }
            return this.blockToken(JShellToken.WHITESPACE);
        }
        int quote = 0;
        if (c == 39 || c == 34) {
            quote = c;
            c = this.input.read();
        }
        if (c == 45) {
            return this.readParameter(JShellToken.COMMAND_OPTION, quote);
        }
        return this.readParameter(quote == 0 ? JShellToken.COMMAND_PARAM : JShellToken.COMMAND_STRING, quote);
    }

    private Token<JShellToken> readParameter(JShellToken tokenId, int quote) {
        int c = this.input.read();
        boolean verbatim = false;
        while (true) {
            if (c == -1) {
                this.state = S.INITIAL;
                return this.tokenFactory.createToken((TokenId)tokenId, this.input.readLength(), PartType.START);
            }
            if (c == 92) {
                verbatim = true;
                c = this.input.read();
                continue;
            }
            if (!verbatim && c == quote) break;
            if (!verbatim && quote == 0) {
                if (Character.isWhitespace(c)) {
                    this.input.backup(1);
                    break;
                }
            } else if (c == 10) {
                this.input.backup(1);
                this.state = S.INITIAL;
                return this.tokenFactory.createToken((TokenId)tokenId, this.input.readLength(), PartType.START);
            }
            verbatim = false;
            c = this.input.read();
        }
        return this.tokenFactory.createToken((TokenId)tokenId, this.input.readLength());
    }

    public Object state() {
        LexState ls = new LexState();
        ls.prev = this.prevState;
        ls.s = this.state;
        return ls;
    }

    public void release() {
    }

    public Object getValue(Token<JShellToken> token, Object key) {
        if ("highlight.block".equals(key)) {
            switch ((JShellToken)token.id()) {
                case MESSAGE_TEXT: 
                case JAVA: 
                case COMMAND: 
                case COMMAND_PARAM: 
                case OUTPUT: {
                    return true;
                }
            }
        }
        return null;
    }

    static {
        JShellLexer.initCommandPrefixes();
    }

    private static class LexState {
        S s;
        S prev;

        private LexState() {
        }
    }

    private static enum S {
        INITIAL,
        PROMPT_INPUT,
        PROMPT_MESSAGE,
        MESSAGE,
        JAVA,
        COMMAND,
        START_MARKER;

    }
}

