/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Util {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());

    public static boolean waitForURLConnection(URL url, int timeout, int retryTime) {
        Connect connect = new Connect(url, retryTime);
        Thread t = new Thread(connect);
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException ie) {
            LOG.log(Level.FINE, "error", ie);
        }
        if (t.isAlive()) {
            connect.finishLoop();
            t.interrupt();
        }
        return connect.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String issueGetRequest(URL url) {
        BufferedReader in = null;
        StringBuffer input = new StringBuffer();
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((inputLine = in.readLine()) != null) {
                input.append(inputLine);
                input.append("\n");
            }
            String string = input.toString();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "error", e);
                }
            }
        }
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> testGroups = Util.getTestSourceGroups(project, sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroups) {
            if (testGroups.contains(sourceGroup)) continue;
            result.add(sourceGroup);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    private static Set<SourceGroup> getTestSourceGroups(Project project, SourceGroup[] sourceGroups) {
        Map<FileObject, SourceGroup> foldersToSourceGroupsMap = Util.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet<SourceGroup> testGroups = new HashSet<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroups) {
            testGroups.addAll(Util.getTestTargets(sourceGroup, foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static Map<FileObject, SourceGroup> createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        Map<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length, 0.5f);
            for (SourceGroup sourceGroup : sourceGroups) {
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static List<FileObject> getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.log(Level.FINE, null, new IllegalStateException("No FileObject found for the following URL: " + urls[i]));
        }
        return result;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return new ArrayList<SourceGroup>();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List<FileObject> sourceRoots = Util.getFileObjects(rootURLs);
        for (FileObject sourceRoot : sourceRoots) {
            SourceGroup srcGroup = (SourceGroup)foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    public static Set getTagValues(InputStream is, String elName, String tagName) throws IOException, SAXException {
        return Util.getTagValues(is, new String[]{elName}, tagName);
    }

    public static Set getTagValues(InputStream is, String[] elNames, String tagName) throws IOException, SAXException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setValidating(false);
        try {
            SAXParser parser = fact.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            TLDVersionHandler handler = new TLDVersionHandler(elNames, tagName);
            reader.setContentHandler(handler);
            try {
                reader.parse(new InputSource(is));
            }
            catch (SAXException ex) {
                LOG.log(Level.FINE, "error", ex);
            }
            return handler.getValues();
        }
        catch (ParserConfigurationException ex) {
            return new HashSet();
        }
    }

    private static class TLDVersionHandler
    extends DefaultHandler {
        private String tagName;
        private Set<String> elNames = new HashSet<String>();
        private Set<String> values;
        private boolean insideEl;
        private boolean insideTag;

        TLDVersionHandler(String[] elNames, String tagName) {
            for (int i = 0; i < elNames.length; ++i) {
                this.elNames.add(elNames[i]);
            }
            this.tagName = tagName;
            this.values = new HashSet<String>();
        }

        @Override
        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            if (this.elNames.contains(rawName)) {
                this.insideEl = true;
            } else if (this.tagName.equals(rawName) && this.insideEl) {
                this.insideTag = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String rawName) throws SAXException {
            if (this.elNames.contains(rawName)) {
                this.insideEl = false;
            } else if (this.tagName.equals(rawName) && this.insideEl) {
                this.insideTag = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideTag) {
                this.values.add(String.valueOf(ch, start, length).trim());
            }
        }

        public Set getValues() {
            return this.values;
        }
    }

    private static class Connect
    implements Runnable {
        URL url = null;
        int retryTime;
        boolean status = false;
        boolean loop = true;

        public Connect(URL url, int retryTime) {
            this.url = url;
            this.retryTime = retryTime;
        }

        public void finishLoop() {
            this.loop = false;
        }

        @Override
        public void run() {
            try {
                InetAddress.getByName(this.url.getHost());
            }
            catch (UnknownHostException e) {
                LOG.log(Level.FINE, "error", e);
                return;
            }
            while (this.loop) {
                try {
                    Socket socket = new Socket(this.url.getHost(), this.url.getPort());
                    socket.close();
                    this.status = true;
                    break;
                }
                catch (UnknownHostException e) {
                    LOG.log(Level.FINE, "error", e);
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "error", e);
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.FINE, "error", ie);
                }
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }
}

