/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.layout;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.component.layout.LayoutUnit;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ResizeEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="layout/layout.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="primefaces.js"), @ResourceDependency(library="primefaces", name="layout/layout.js")})
public class Layout
extends UIPanel
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Layout";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.LayoutRenderer";
    public static final String UNIT_CLASS = "ui-layout-unit ui-widget ui-widget-content ui-corner-all";
    public static final String UNIT_HEADER_CLASS = "ui-layout-unit-header ui-widget-header ui-corner-all";
    public static final String UNIT_CONTENT_CLASS = "ui-layout-unit-content ui-widget-content";
    public static final String UNIT_FOOTER_CLASS = "ui-layout-unit-footer ui-widget-header ui-corner-all";
    public static final String UNIT_HEADER_TITLE_CLASS = "ui-layout-unit-header-title";
    public static final String UNIT_FOOTER_TITLE_CLASS = "ui-layout-unit-footer-title";
    public static final String UNIT_HEADER_ICON_CLASS = "ui-layout-unit-header-icon ui-state-default ui-corner-all";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("toggle", "close", "resize"));

    public Layout() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public boolean isFullPage() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fullPage), (Object)false);
    }

    public void setFullPage(boolean _fullPage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fullPage), (Object)_fullPage);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String getOnResize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onResize), null);
    }

    public void setOnResize(String _onResize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onResize), (Object)_onResize);
    }

    public String getOnClose() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onClose), null);
    }

    public void setOnClose(String _onClose) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onClose), (Object)_onClose);
    }

    public String getOnToggle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onToggle), null);
    }

    public void setOnToggle(String _onToggle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onToggle), (Object)_onToggle);
    }

    public String getResizeTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizeTitle), null);
    }

    public void setResizeTitle(String _resizeTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizeTitle), (Object)_resizeTitle);
    }

    public String getCollapseTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.collapseTitle), (Object)"Collapse");
    }

    public void setCollapseTitle(String _collapseTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.collapseTitle), (Object)_collapseTitle);
    }

    public String getExpandTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expandTitle), null);
    }

    public void setExpandTitle(String _expandTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expandTitle), (Object)_expandTitle);
    }

    public String getCloseTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.closeTitle), (Object)"Close");
    }

    public void setCloseTitle(String _closeTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.closeTitle), (Object)_closeTitle);
    }

    public boolean isStateful() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stateful), (Object)false);
    }

    public void setStateful(boolean _stateful) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stateful), (Object)_stateful);
    }

    protected LayoutUnit getLayoutUnitByPosition(String name) {
        for (UIComponent child : this.getChildren()) {
            LayoutUnit layoutUnit;
            if (!(child instanceof LayoutUnit) || !(layoutUnit = (LayoutUnit)child).getPosition().equalsIgnoreCase(name)) continue;
            return layoutUnit;
        }
        return null;
    }

    public boolean isNested() {
        return this.getParent() instanceof LayoutUnit;
    }

    public boolean isElementLayout() {
        return !this.isNested() && !this.isFullPage();
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void processDecodes(FacesContext context) {
        if (this.isSelfRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processUpdates(context);
        }
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            AjaxBehaviorEvent wrapperEvent = null;
            if (eventName.equals("toggle")) {
                boolean collapsed = Boolean.valueOf((String)params.get(clientId + "_collapsed"));
                LayoutUnit unit = this.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
                Visibility visibility = collapsed ? Visibility.HIDDEN : Visibility.VISIBLE;
                unit.setCollapsed(collapsed);
                wrapperEvent = new ToggleEvent((UIComponent)unit, behaviorEvent.getBehavior(), visibility);
            } else if (eventName.equals("close")) {
                LayoutUnit unit = this.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
                unit.setVisible(false);
                wrapperEvent = new CloseEvent((UIComponent)unit, behaviorEvent.getBehavior());
            } else if (eventName.equals("resize")) {
                LayoutUnit unit = this.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
                String position = unit.getPosition();
                int width = Integer.valueOf((String)params.get(clientId + "_width"));
                int height = Integer.valueOf((String)params.get(clientId + "_height"));
                if (position.equals("west") || position.equals("east")) {
                    unit.setSize(String.valueOf(width));
                } else if (position.equals("north") || position.equals("south")) {
                    unit.setSize(String.valueOf(height));
                }
                wrapperEvent = new ResizeEvent((UIComponent)unit, behaviorEvent.getBehavior(), width, height);
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent(wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        fullPage,
        style,
        styleClass,
        onResize,
        onClose,
        onToggle,
        resizeTitle,
        collapseTitle,
        expandTitle,
        closeTitle,
        stateful;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

